#define REV "1"
#define AUTH "merlucion@spontz.es"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iostream.h>
#include <unistd.h>
#include <signal.h>
#include <stdlib.h>

#include <sys/time.h>
#include <time.h>

#include <math.h>
#include "Messagetypes.h"


#define MAXACCEL 2
#define MAXSPEED 10

// Valor Absoluto
#define abs(x) ((x>0) ? (x) : -(x))

// Reduccion a un angulo entre -PI y PI
float mindiff(float inangle);

double radar_angle;
bool objeto; 

volatile sig_atomic_t exit_robot=false;

message_to_robot_type name2msg_to_robot_type(char* msg_name)
 {
  for(int i=0;message_to_robot[i].msg[0]!='\0';i++)
   {
    if (strcmp(message_to_robot[i].msg,msg_name)==0)
     return (message_to_robot_type)i;
   }
  return UNKNOWN_MESSAGE_TO_ROBOT;
 }

void check_messages(int sig)
 { 
  int i; 
  double e;
  exit_robot=false;
  char msg_name[81];
  char text[81];
  message_to_robot_type msg_t;
  timeval current_time;
  gettimeofday(&current_time,NULL);
  srand(current_time.tv_usec);
  cin.clear();
  while(!cin.eof())
   {
    cin>>msg_name;
    msg_t=name2msg_to_robot_type(msg_name);
    switch(msg_t)
     {
      case INITIALIZE:
       int init;
       cin>>init ;
       if (init==1)
        {
         cout<<"Name Merlucin"<<endl;
         cout<<"Colour 00ff00 ff5500"<<endl;
         cout<<"Print "<<REV<<endl;
         cout<<"Print "<<AUTH<<endl;
        }
       break;
      case GAME_STARTS:
       cout<<"Accelerate "<<MAXACCEL<<endl;
       cout<<"Rotate 6 "<<M_PI<<endl;
       cout<<"Sweep 6 1 -1 1"<<endl;
       cout<<"Rotate 1 "<<M_PI_2<<endl;	   
       break;
      case RADAR:
       {
        double dist, energy;
        int object;
        if (dist<10)
         objeto=true;
//      cout<<"Print objeto "<<object<<" distancia "<<dist<<" "<<objeto<<endl;
        cin >> dist >> object >> radar_angle;
        radar_angle=mindiff(radar_angle);
        switch(object)
         {
          case ROBOT:
           e=64/dist;
           cout<<"Shoot "<<e<<endl;
//           cout<<"Shoot "<<e<<endl;
//           cout<<"Shoot "<<e<<endl;
           if (dist<2)                           // si el enemigo esta suficientemente cerca
            {                                    // hacemos dos disparos 
//             cout<<"Shoot "<<e<<endl;     
//             cout<<"Shoot "<<e<<endl;     
             cout<<"Shoot "<<e<<endl;     
            }
           cout<<"Accelerate 1"<<endl;
           cout<<"RotateAmount 1 6 "<<radar_angle<<endl;
           cout<<"Rotate 6 0 10"<<endl;
           objeto=true;
           break;
          case WALL:
           cout<<"Brake "<<40/dist<<endl;
           cout<<"RotateAmount 1 "<<10/dist/dist<<" "<<-1*radar_angle<<endl;
           break;
          case SHOT:
//          cout<<"Shoot 1"<<endl;                // para disparar a las balas enemigas - no va bien
  
           cout<<"Accelerate 1"<<endl;
           cout<<"RotateAmount 1 "<<10/dist/dist<<" "<<-1*radar_angle<<endl;
           objeto=true;
           break;
          case COOKIE:
           cout<<"Accelerate 1"<<endl;
           cout<<"RotateAmount 1 6 "<<radar_angle<<endl;
           break;
          case MINE:
           cout<<"Brake "<<40/dist<<endl;
           cout<<"RotateAmount 1 "<<10/dist/dist<<" "<<-1*radar_angle+(radar_angle<0 ? .5 : -.5)<<endl;
           break;
         }
        break;
       }                                         // fin case RADAR
      case COLLISION:
       int tmp;
       double coll_angle;
       cin>>tmp>>coll_angle;
       coll_angle=mindiff(coll_angle);
       switch(tmp)
        {
         case ROBOT: 
          cout<<"RotateAmount 1 1 "<<coll_angle<<endl;
          break;
         case SHOT:
          objeto=true;
          cout<<"Sweep 6 6 "<<coll_angle-0.5<<" "<<coll_angle+0.5<<endl;
          break;
         case MINE: 
          cout<<"Print Oh no! la pise!"<<endl;
          break;
         case COOKIE: 
          cout<<"Ummm, que rica!"<<endl; 
          break;
         case WALL:
//   cout<<"RotateAmount 1 6 "<<-1*(coll_angle)+(coll_angle < 0? 1 : -1 ); //para dar la vuelta - no va bien
          cout<<"Accelerate 0"<<endl;
//        cout<<"Print Jo, que golpe mas tonto"<<endl;; 
          break;
        }
        break;
      case WARNING:
       cin.getline(text,80,'\n');
//     cout<<"Print Warning! "<<text<<endl;
       break;
      case EXIT_ROBOT:
       cout<<"Print A tomar por culo"<<endl;
       exit_robot=true;
       break;
      default:
       break;
     }
   }
  signal (sig, check_messages);
 }

float mindiff(float inangle)
 {
  float modder=2*M_PI;
  while (abs(inangle)>modder)
   {
    inangle=inangle > 0?inangle - modder : inangle + modder;
   }
   if (inangle>M_PI)
    inangle=inangle - (2*M_PI);
   else
    if(inangle<-M_PI)
     inangle=inangle + (2*M_PI);
  return inangle;
 }

void handle_alarm(int sig)
 {
  cout<<"Print Cuidado, Alarma!"<<endl;
 }

int  main(int argc,char * argv[])
 {
  sigset_t usr1set;
  int iteracion=0;
  int iteracionultimoobjeto=0;
  objeto=false;

  //check_messages(SIGUSR1);
  signal(SIGUSR1, check_messages);
  signal(SIGALRM, handle_alarm);

  // libpthread seems to block USR1 sometimes for some reason
  sigemptyset(&usr1set);
  sigaddset(&usr1set, SIGUSR1);
  sigprocmask(SIG_UNBLOCK, &usr1set, NULL);
 
  cout<<"RobotOption "<<(int)SIGNAL<<" "<<(int)SIGUSR1<<endl;
  cout<<"RobotOption "<<(int)SEND_ROTATION_REACHED<<endl;

  for(;;sleep(1))
   {
//  cout<<"Print Iteracion "<<iteracion<<endl;
    if (objeto)
     iteracionultimoobjeto=iteracion;
    if (iteracion-iteracionultimoobjeto>=10)     
     {
//    cout<<"Print Vamos a buscar"<<endl;
      cout<<"Sweep 6 10 -3 3"<<endl;
     }
    iteracion++;
    objeto=false;
    if( exit_robot ) 
     {
      return(EXIT_SUCCESS);
     }
   }
  return(EXIT_SUCCESS);
 }
