// TO DO:
// -----
//
// - tener en cuenta la escala del tablero
// - memoria compartida para identificar colegas
//
//////////////////////////


#include <iostream.h>
#include <unistd.h>
#include <signal.h>
#include <stdlib.h>

#ifdef TIME_WITH_SYS_TIME
# include <sys/time.h>
# include <time.h>
#else
# if HAVE_SYS_TIME_H
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif

#include <math.h>
#include "Messagetypes.h"

#define absoluto(x) x > 0 ? x : -x

////////
// variables globales
////////
double gSHOT_MIN_ENERGY, gSHOT_MAX_ENERGY, gROBOT_RADAR_MAX_ROTATE;
double gROBOT_MAX_ROTATE;

double tid, speed, cannon_angle;
volatile double robot_rotate;
volatile double aceleracion;
double gEnergia;
double radar_angle;
volatile sig_atomic_t exit_robot = false;
int gRobotGirando, gDisparosCargador, gInteresante;

message_to_robot_type
name2msg_to_robot_type(char* msg_name)
{
  for(int i=0; message_to_robot[i].msg[0] != '\0'; i++)
    {
      if( strcmp(message_to_robot[i].msg, msg_name) == 0 )
        return (message_to_robot_type)i;
    }
  return UNKNOWN_MESSAGE_TO_ROBOT;
}

////////
// bucle de gestin de mensajes
////////

void
check_messages(int sig)
{
  exit_robot = false;
  robot_rotate = 0.0;

  char msg_name[81];
  char text[81];
  message_to_robot_type msg_t;

  cin.clear();
  while( !cin.eof() )
    {
      cin >> msg_name;
      msg_t = name2msg_to_robot_type(msg_name);

      switch(msg_t)
        {
        case INITIALIZE:
          int init;
          cin >> init;
          if (init == 1)
            {
              cout << "Name Adler's Blade" << endl;
              cout << "Colour 57aeb6 fe0fe0" << endl;
            }
          break;
        case GAME_STARTS:
          cout << "Sweep 6 " << M_PI/2.0 << " " << -M_PI/2.0 << " " << M_PI/2.0 << endl;
          aceleracion = 10.0;
	  gRobotGirando = 0;
	  gInteresante = 0;
          break;
        case GAME_FINISHES:
          break;

	case GAME_OPTION:
          int opcion;
	  double valor;
	  cin >> opcion >> valor;
	  switch (opcion)
	  {
	    case SHOT_MIN_ENERGY:
		gSHOT_MIN_ENERGY = valor;
		break;
	    case SHOT_MAX_ENERGY:
		gSHOT_MAX_ENERGY = valor;
		break;
	    case ROBOT_START_ENERGY:
		gEnergia = valor;
		break;
	    case ROBOT_RADAR_MAX_ROTATE:
		gROBOT_RADAR_MAX_ROTATE = valor;
	    case ROBOT_MAX_ROTATE:
		gROBOT_MAX_ROTATE = valor;
	  }
	  break;

        case INFO:
          cin >> tid >> speed  >> cannon_angle;
	  if (speed < 5)
            cout << "Accelerate " << 10.0 << endl;
          break;

	case ENERGY:
	  cin >> gEnergia;
	  break;
          
        case ROBOTS_LEFT:
          break;

	case ROTATION_REACHED:
	  cin >> valor;
	  if ( ((int)valor) & 1)
	    gRobotGirando = 0;
	  break;

        case RADAR:
          {
            double dist;
            int object;

            cin >> dist >> object >> radar_angle;
            switch(object)
              {
              case ROBOT:
		if (gEnergia > 0)
		{
		  gDisparosCargador = 12;

		  if (dist < 8)
		    cout << "Shoot " << gSHOT_MAX_ENERGY*0.8 << endl;
		  else
		    cout << "Shoot " << gSHOT_MAX_ENERGY*0.2 << endl;

		  robot_rotate = radar_angle;
		  gInteresante = 10;
	          aceleracion = 1.2;
	          cout << "Accelerate " << aceleracion << endl;
		}
		else
		{
		  if (radar_angle < 0)
		    robot_rotate = 0.7;
		  else robot_rotate = -0.7;

	          aceleracion = 10.0;
	          cout << "Accelerate " << aceleracion << endl;
		}
                break;
              case WALL:
		if ( (dist < 5) && (gInteresante <= 0) )
		{
		  robot_rotate = 0.7;
		  cout << "Brake 1.0" << endl;
		}
                break;
              case SHOT:
		if (dist < 0.5)
		  cout << "Shoot " << gSHOT_MAX_ENERGY*0.2 << endl;
                break;
              case COOKIE:
		robot_rotate = radar_angle;
		gInteresante = 10;
	        aceleracion = 1.2;
	        cout << "Accelerate " << aceleracion << endl;
                break;
              case MINE:
		if ( (dist < 10) && (gEnergia > 0) )
		    cout << "Shoot " << gSHOT_MIN_ENERGY << endl;
		else if ( (dist < 5) && (gInteresante <= 0) )
		  if (radar_angle < 0)
		    robot_rotate = 0.7;
		  else robot_rotate = -0.7;
                break;
              }
          break;
          }

        case COLLISION:
          {
              case SHOT:
		if (gInteresante <= 0)
		{
	          aceleracion = 10.0;
	          cout << "Accelerate " << aceleracion << endl;
		}
                break;
          }
          break;
        case WARNING:
          cin.getline(text,80,'\n');
          cout << "Print FALLO EN " << text << endl;
          break;
        case EXIT_ROBOT:
          cout << "Print Oyasumi nasai!!!" << endl;
          exit_robot = true;
          break;
        default:
          break;
        }
    }

  if (gInteresante-- > 0)
    cout << "Sweep 6 " << M_PI/2.0 << " " << -M_PI/60.0 << " " << M_PI/60.0 << endl;
  else
    cout << "Sweep 6 " << M_PI/2.0 << " " << -M_PI/2.0 << " " << M_PI/2.0 << endl;

  if (!gRobotGirando)
  {
    cout << "RotateAmount 1 " << gROBOT_MAX_ROTATE << " " << robot_rotate << endl;
    gRobotGirando = 1;
  }

  if (--gDisparosCargador > 0) 
    cout << "Shoot " << gSHOT_MAX_ENERGY*0.3 << endl;

  signal (sig, check_messages);
}

int 
main(int argc, char * argv[])
{
  sigset_t usr1set;

  //check_messages(SIGUSR1);
  signal(SIGUSR1, check_messages);

  // libpthread seems to block USR1 sometimes for some reason
  sigemptyset(&usr1set);
  sigaddset(&usr1set, SIGUSR1);
  sigprocmask(SIG_UNBLOCK, &usr1set, NULL);

  cout << "RobotOption " << (int)SIGNAL << " " << (int)SIGUSR1 << endl;
  cout << "RobotOption " << SEND_ROTATION_REACHED << " 1" << endl;

  while (!exit_robot)
  {
    sleep(1);
  };

  return(EXIT_SUCCESS);
}
