#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "NullFile.h"

/****************************************************************************/
// Cargar de PCX

int NULL_CargarFicheroPCX (char *nomfic, void *buf, char *paleta)
{
    unsigned char basura[64];
    FILE *fichero;
    unsigned char charaux;
    unsigned short int Xmin,Ymin,Xmax,Ymax;
    unsigned int contador, repeticiones;

    unsigned int anchopcx, altopcx;
    unsigned int comprimido;
    unsigned char bits_por_pixel_y_plano;
    unsigned char numero_de_planos;
  
    fichero = fopen(nomfic,"rb");
    //if (!fichero) NULL_Error("No encuentro el fichero \"%s\"", nomfic);

    // ******************************** CABECERA ********************************

    fread(&charaux, 1, 1, fichero);
    //if (charaux != 10)
		//NULL_Error("EL FICHERO %s NO ES DE FORMATO PCX\n", nomfic);

    fread(&charaux, 1, 1, fichero);
    fread(&charaux, 1, 1, fichero);
    comprimido = charaux;           // si vale uno --> RLE

    fread(&bits_por_pixel_y_plano, 1, 1, fichero);
    //if (bits_por_pixel_y_plano != 8)
		//NULL_Error("UNICAMENTE IMPLEMENTADO 8 BITS POR PIXEL Y PLANO.\n");

    fread(&Xmin, 2, 1, fichero);
    fread(&Ymin, 2, 1, fichero);
    fread(&Xmax, 2, 1, fichero);
    fread(&Ymax, 2, 1, fichero);

    anchopcx = Xmax - Xmin + 1;
    altopcx = Ymax - Ymin + 1;

    fread(basura, 53, 1, fichero); // no nos interesa esta parte de la cabecera

    fread(&numero_de_planos, 1, 1, fichero);
    //if ( (numero_de_planos != 1) && (numero_de_planos != 3))
		//NULL_Error("UNICAMENTE IMPLEMENTADOS 1 Y 3 PLANOS.\n");

    fread(basura, 62, 1, fichero); // no nos interesa el resto de la cabecera

    // ******************************** 8 BPP ********************************

    // ****** DATOS ******

    if (numero_de_planos == 1) // 8 bpp
    {
        unsigned char *pbuf = (unsigned char*) buf;

        if (!comprimido)
        {
            fread(buf, anchopcx * altopcx, 1, fichero);
        }
        else // RLE
        {
            do
            {
                fread(&charaux, 1, 1, fichero);
    
                if (charaux < 192)
                {
                    *pbuf++ = charaux;
                }
                else
                {
                    repeticiones = (charaux & 63);
                    fread(&charaux, 1, 1, fichero);
                    for (contador = 0; contador < repeticiones; contador++)
                    {
                        *pbuf++ = charaux;
                    }
                }
    
            } while (pbuf < (unsigned char*)buf + anchopcx * altopcx);
        }
    
        // ****** PALETA ******

        if (paleta) // != NULL
        {    
            // El caracter de la posicin (final del fichero - 769) vale 12. Hay que llegar a l.
            do
            {
                fread(&charaux, 1, 1, fichero);
            } while (charaux != 12);
        
            fread(paleta, 768, 1, fichero);
        }
    }
    else if (numero_de_planos == 3) // 24 bpp
    {
    // ******************************** 24 BPP  ********************************

        unsigned int *pbuf = (unsigned int*) buf;
        unsigned char R[2048], G[2048], B[2048];     //  no meter pcx's de ms de 2048 de ancho !! ;-P
        unsigned int ancho;
        unsigned int alto = altopcx;

        if (!comprimido)
        {
            do {
                fread(R, anchopcx, 1, fichero);
                fread(G, anchopcx, 1, fichero);
                fread(B, anchopcx, 1, fichero);

                ancho = 0;
                do {
                    *pbuf++ = (unsigned int) (R[ancho]<<16) + (unsigned int) (G[ancho]<<8) + (unsigned int) B[ancho];
                } while (ancho++ < anchopcx);
            } while (--alto);
        }
        else // RLE
        {
            unsigned char color = 2; // R=2, G=1, B=0
            unsigned int linea[2048];
            unsigned int repe=0;
            memset (linea, 0, anchopcx*sizeof(int));

            do {
                ancho = 0;
                do {
                    if (repe) for (contador = 0; contador < repe; contador++)
                    {
                        linea[ancho++] += charaux << (8*color);
                    }
                    repe = 0;

                    fread(&charaux, 1, 1, fichero);
        
                    if (charaux < 192)
                    {
                        linea[ancho++] += charaux << (8*color);
                    }
                    else
                    {
                        repeticiones = (charaux & 63);
                        fread(&charaux, 1, 1, fichero);
                        for (contador = 0; contador < repeticiones; contador++)
                        {
                            linea[ancho++] += charaux << (8*color);
                        }
                    }
                } while (ancho < anchopcx);

                if (ancho > anchopcx) repe = ancho - anchopcx;
                else repe = 0;

                if (color > 0) color--;
                else
                {
                    color = 2;
                    alto--;

                    memcpy (pbuf, linea, anchopcx*sizeof(int));
                    memset (linea, 0, anchopcx*sizeof(int));
                    pbuf += anchopcx;
                }
            } while (alto);
        }
    }

    fclose(fichero);
    return 1;
}

