#ifndef __graphics_h
#define __graphics_h

#define u8   unsigned char
#define s8   signed char

#define u16  unsigned short int
#define s16  signed short int

#define u32  unsigned int
#define s32  signed int

#define LCD_SIZE_X 320
#define LCD_SIZE_Y 240

/* composicion del color 5:5:5:1 a partir de un r,g,b de 8 bits */

#define RGB15_8(r,g,b)			((((u16)r<<(11-3))&0xf800)| \
          				 (((u16)g<<(6-3) )&0x07c0)| \
          				 (((u16)b>> 2    )&0x003e)|0)

/* composicion del color 5:5:5:1 a partir de un r,g,b, de 5 bits*/

#define RGB15_5(r,g,b)			((((u16)r<<(11))&0xf800)|   \
          				(((u16)g<<6 )   &0x07c0)|   \
          				(((u16)b<<1)    &0x003e)|0)
          						 
#define RGB15_R(rgb)			 (rgb>>11)
#define RGB15_G(rgb)			((rgb>>6)&0x1f)
#define RGB15_B(rgb)			((rgb>>1)&0x1f) 



/* macro para dibujado de un pixel en x,y de manera eficiente */
/* X*240 + y  = X*(256-16) + y = X*256 -X*16 +y               */
#define pixel_draw(surface,x,y,rgb15)  ((u16 *)surface)[(x)*240+(y)]=rgb15;
//#define pixel_draw(surface,x,y,rgb15)  ((u16 *)surface)[((x)<<8)-((x)<<4)+(y)]=rgb15;

typedef struct sprite  st_sprite;
struct sprite {
		u32 x_size;
		u32 y_size;
		u16 *bitmap;
		u8  *alpha;
};

#endif	