/***********************************************
 *         outs utilities                      *
 * Skal 96                                     *
 ***********************************************/

#ifndef _OUT_REGS_H_
#define _OUT_REGS_H_

#define MISC_OUT  0x03c2
#define SEQ_P     0x03c4
#define SEQ_DATA  0x03c5
#define CRTC_P    0x03d4
#define CRTC_DATA 0x03d5

#define _OUTW_3D4(S)         \
  asm( " movw $0x03d4,%%dx\n" " movw %0,%%ax\n" " outw %%ax,%%dx\n" \
    : : "g" ( (S) ) : "eax", "edx" )
#define _OUTB_3D4(S)         \
  asm( " movw $0x03d4,%%dx\n" " movw %0,%%ax\n" " outb %%al,%%dx\n" \
    : : "g" ( (S) ) : "eax", "edx" )

#define Remove_Write_Protect( )     \
{ outportb( CRTC_P, 0x11 ); outportb( CRTC_DATA, inportb( CRTC_DATA ) & 0x7f ); }

#define Restore_Write_Protect( )  \
{ outportb( CRTC_P, 0x11 ); outportb( CRTC_DATA, inportb( CRTC_DATA ) | 0x80 ); }

#define Disable_Chain4( )           \
   outportw( SEQ_P, 0x0604 )

#define outCR(I,V)   { outb( 0x03d4, (I) ); outb( 0x03d5, (V) ); }
/* #define inCR(I)   ( outb( 0x03d4, (I) ), inb( 0x03d5 ) ) */

extern UINT inCR( UINT Index );
extern void outw( USHORT Port, UINT Val );
extern void outb( USHORT Port, UINT Val );
extern UINT inw( USHORT Port );
extern UINT inb( USHORT Port );

extern void Out_Crts( USHORT *Tab );

#endif   /* _OUT_REGS_H_ */
