/***********************************************
 *              mem utilities                  *
 * Skal 96                                     *
 ***********************************************/

#include "mem.h"

/*******************************************************************/
/*******************************************************************/

#ifdef DEBUG_MEM

static int Allocated = 0;
static int Max_Reached = 0;
static int Last_Slot = 0;

#define MAX_SLOT     300
static struct {
   void *Ptr;
   int   Size;
} Mem_Slots[ MAX_SLOT ];

EXTERN void *My_Realloc( void *Ptr, int Size )
{
   void *New;
   New = My_Malloc( Size );
   if ( New == NULL ) return( NULL );
   if ( Ptr != NULL )
   {
      memcpy( New, Ptr, Size );
      My_Free( Ptr );
   }
   else bzero( New, Size );
   return( New );
};

EXTERN void *My_Malloc( int Size )
{
   void *Ptr;

   if ( Size == 0 ) return( NULL );
   Size = ( Size + 0x07 ) & ~0x07;    /* align to 8 */
   Ptr = (void *)malloc( Size );
   if ( Ptr != NULL ) 
   {
      Allocated += Size;
      if ( Allocated > Max_Reached ) Max_Reached = Allocated;
      Mem_Slots[ Last_Slot ].Ptr = Ptr;
      Mem_Slots[ Last_Slot ].Size = Size;
      Last_Slot++;
      if ( Last_Slot>= MAX_SLOT )
         Exit_Upon_Error( "Not enough slots in My_Malloc() !\n" );
      Out_Message( "Malloc'ed: %d bytes (0x%.8x). \t\tTotal: %d", 
         Size, Ptr, Allocated );
   }

   return( Ptr );
}

EXTERN void My_Free( void *Ptr )
{
   int i;
   for( i=Last_Slot-1; i>=0; --i )
      if ( Mem_Slots[i].Ptr == Ptr ) break;
   if ( i<0 )
   {
      Out_Message( "Ptr 0x%.8x not found in Mem_Slots[] !", Ptr );
      free( Ptr );
      return;
   }
   Allocated -= Mem_Slots[i].Size;
   Out_Message( "Free'ed: %d bytes (0x%.8x). \t\tTotal: %d",
      Mem_Slots[i].Size, Ptr, Allocated );

   Last_Slot--;
   Mem_Slots[i] = Mem_Slots[ Last_Slot ];
   free( Ptr );

}

EXTERN void Print_Mem_State( )
{
   Out_Message( "Memory state:" );
   Out_Message( " * Malloc'ed: %d bytes.", Allocated );
   Out_Message( " * Max. allocated: %d bytes.", Max_Reached );
   Out_Message( " * Current slots: %d.", Last_Slot );
}

/*******************************************************************/

#else

EXTERN void *My_Malloc( int Size )
{
   void *Ptr;
   Ptr = (void *)malloc( ( Size + 0x07 ) & ~0x07 );

   return( Ptr );
}

EXTERN void *My_Realloc( void *Ptr, int Size )
{
   return( (void *)realloc( Ptr, Size ) );
}

EXTERN void My_Free( void *Ptr )
{
   free( Ptr );
}


/*******************************************************************/

#endif /* DEBUG_MEM */

EXTERN void *My_Fatal_Malloc( int Size )
{
   void *Ptr;
   Ptr = (void *)My_Malloc( Size );
   if ( Ptr != NULL ) return( Ptr );
   Exit_Upon_Mem_Error( NULL, Size );
}
