
/*
 * C-Portable color converters
 * Slow and still-to-optimize code
 */

#include "main.h"

/**************************************************************/

EXTERN void CMap8_To_RGB32( CMAPPER *CM, PIXEL *Dst, PIXEL *Src, INT Size )
{
   UINT *Fmt_Cols;
   Fmt_Cols = (UINT *)CM->Indexer->Fmt_Cols;
   while( --Size>=0 )
      ( (UINT *)Dst)[Size] = Fmt_Cols[ Src[Size] ];
}

EXTERN void CMap8_To_RGB24( CMAPPER *CM, PIXEL *Dst, PIXEL *Src, INT Size )
{
   UINT *Fmt_Cols;
   Fmt_Cols = (UINT *)CM->Indexer->Fmt_Cols;
   while( --Size>=0 )
   {
      PIXEL *C;
      C = (PIXEL*)( Fmt_Cols + (*Src++) );
      *Dst++ = *C++;
      *Dst++ = *C++;
      *Dst++ = *C++;
   }
}

EXTERN void CMap8_To_RGB16( CMAPPER *CM, PIXEL *Dst, PIXEL *Src, INT Size )
{
   UINT *Fmt_Cols;
   Fmt_Cols = (UINT *)CM->Indexer->Fmt_Cols;
   while( --Size>=0 )
      ( (USHORT *)Dst)[Size] = (USHORT)( Fmt_Cols[ Src[Size] ] );
}

/**************************************************************/
/**************************************************************/

EXTERN void RGB8_To_RGB8( CMAPPER *CM, PIXEL *Dst, PIXEL *Src, INT Size )
{
   UINT *Mask;
   Mask = CM->Mask->Masks;
   while( --Size>=0 )
   {
      PIXEL D; PIXEL C;
      C = Src[Size];
      D  = (Mask)[ C ];
      D |= (Mask + 256)[ C ];
      D |= (Mask + 768)[ C ];
      Dst[Size] = D;
   }
}

EXTERN void RGB8_To_RGB16( CMAPPER *CM, PIXEL *Dst, PIXEL *Src, INT Size )
{
   USHORT *Dst2;
   UINT *Mask;
   Mask = CM->Mask->Masks;

   Dst2 = (USHORT *)Dst;
   while( --Size>=0 )
   {
      USHORT D; PIXEL C;
      C = Src[Size];
      D  = (Mask)[ C ];
      D |= (Mask + 256)[ C ];
      D |= (Mask + 512)[ C ];
      D |= (Mask + 768)[ C ];
      Dst2[Size] = D;
   }
}
EXTERN void RGB8_To_RGB24( CMAPPER *CM, PIXEL *Dst, PIXEL *Src, INT Size )
{
   UINT *Mask;
   Mask = CM->Mask->Masks;
   while( --Size>=0 )
   {
      UINT D;
      PIXEL C;
      C = *Src++;
      D  = (Mask)[ C ];
      D |= (Mask + 256)[ C ];
      D |= (Mask + 768)[ C ];
      *Dst++ = (D>>16)&0xFF;
      *Dst++ = (D>>8)&0xFF;
      *Dst++ = D&0xFF;
   }

}
EXTERN void RGB8_To_RGB32( CMAPPER *CM, PIXEL *Dst, PIXEL *Src, INT Size )
{
   UINT *Dst2;
   UINT *Mask;
   Mask = CM->Mask->Masks;

   Dst2 = (UINT *)Dst;
   while( --Size>=0 )
   {
      UINT D;
      PIXEL C;
      C = Src[Size];
      D  = (Mask)[ C ];
      D |= (Mask + 256)[ C ];
      D |= (Mask + 768)[ C ];
      Dst2[Size] = D;
   }
}

/**************************************************************/

EXTERN void RGB16_To_RGB8( CMAPPER *CM, PIXEL *Dst, PIXEL *Src, INT Size )
{
   USHORT *Src2;
   UINT *Mask;
   Mask = CM->Mask->Masks;

   Src2 = (USHORT *)Src;
   while( --Size>=0 )
   {
      PIXEL D; USHORT C;
      C = Src2[Size];
      D  = (Mask)[ C>>8 ];
      D |= (Mask + 256)[ C>>8 ];
      D |= (Mask + 512)[ C&0xFF ];
      D |= (Mask + 768)[ C&0xFF ];
      Dst[Size] = D;
   }
}

EXTERN void RGB16_To_RGB16( CMAPPER *CM, PIXEL *Dst, PIXEL *Src, INT Size )
{
   USHORT *Dst2, *Src2;
   UINT *Mask;
   Mask = CM->Mask->Masks;

   Src2 = (USHORT *)Src;
   Dst2 = (USHORT *)Dst;
   while( --Size>=0 )
   {
      USHORT D, C;
      C = Src2[Size];
      D  = (Mask)[ C>>8 ];
      D |= (Mask + 256)[ C>>8 ];
      D |= (Mask + 512)[ C&0xFF ];
      D |= (Mask + 768)[ C&0xFF ];
      Dst2[Size] = D;
   }
}
EXTERN void RGB16_To_RGB24( CMAPPER *CM, PIXEL *Dst, PIXEL *Src, INT Size )
{
   USHORT *Src2;
   UINT *Mask;
   Mask = CM->Mask->Masks;

   Src2 = (USHORT *)Src;
   while( --Size>=0 )
   {
      UINT D;
      USHORT C;
      C = *Src2++;
      D  = (Mask)[ C>>8 ];
      D |= (Mask + 256)[ C>>8 ];
      D |= (Mask + 512)[ C&0xFF ];
      D |= (Mask + 768)[ C&0xFF ];
      *Dst++ = (D>>16)&0xFF;
      *Dst++ = (D>>8)&0xFF;
      *Dst++ = D&0xFF;
   }

}
EXTERN void RGB16_To_RGB32( CMAPPER *CM, PIXEL *Dst, PIXEL *Src, INT Size )
{
   UINT *Dst2;
   USHORT *Src2;
   UINT *Mask;
   Mask = CM->Mask->Masks;

   Dst2 = (UINT *)Dst;
   Src2 = (USHORT *)Src;
   while( --Size>=0 )
   {
      UINT D;
      USHORT C;
      C = Src2[Size];
      D  = (Mask)[ C>>8 ];
      D |= (Mask + 256)[ C>>8 ];
      D |= (Mask + 512)[ C&0xFF ];
      D |= (Mask + 768)[ C&0xFF ];
      Dst2[Size] = D;
   }
}

/**************************************************************/

EXTERN void RGB24_To_RGB8( CMAPPER *CM, PIXEL *Dst, PIXEL *Src, INT Size )
{
   UINT *Mask;
   Mask = CM->Mask->Masks;
   while( --Size>=0 )
   {
      PIXEL D;      
      D  = (Mask + 768)[ *Src++ ];
      D |= (Mask + 256)[ *Src++ ];
      D |= Mask[ *Src++ ];
      *Dst++ = D;
   }
}

EXTERN void RGB24_To_RGB16( CMAPPER *CM, PIXEL *Dst, PIXEL *Src, INT Size )
{
   USHORT *Dst2;
   UINT *Mask;

   Dst2 = (USHORT *)Dst;
   Mask = CM->Mask->Masks;
   while( --Size>=0 )
   {
      USHORT D;
      PIXEL C;
      D  = (Mask + 768)[ *Src++ ];
      C = *Src++;
      D |= (Mask + 512)[ C ];
      D |= (Mask + 256)[ C ];
      *Dst2++ = D | Mask[ *Src++ ];
   }
}
EXTERN void RGB24_To_RGB32( CMAPPER *CM, PIXEL *Dst, PIXEL *Src, INT Size )
{
   UINT *Mask;

   Mask = CM->Mask->Masks;
   while( --Size>=0 )
   {
      *Dst++ = *Src++;
      *Dst++ = *Src++;
      *Dst++ = *Src++;
      Dst++;
   }
}

/**************************************************************/

EXTERN void RGB32_To_RGB8( CMAPPER *CM, PIXEL *Dst, PIXEL *Src, INT Size )
{
   UINT *Src2;
   UINT *Mask;
   Mask = CM->Mask->Masks;
   Src2 = (UINT *)Src;
   while( --Size>=0 )
   {
      PIXEL D;
      D  = (Mask + 768)[ *Src++ ];
      D |= (Mask + 256)[ *Src++ ];
      D |= Mask[ *Src++ ];
      *Dst++ = D;
      Src++;
   }
}
EXTERN void RGB32_To_RGB16( CMAPPER *CM, PIXEL *Dst, PIXEL *Src, INT Size )
{
   USHORT *Dst2;
   UINT *Mask;

   Mask = CM->Mask->Masks;
   Dst2 = (USHORT *)Dst;
   while( --Size>=0 )
   {
      USHORT D;
      PIXEL C;
      D  = (Mask + 768)[ *Src++ ];
      C = *Src++;
      D |= (Mask + 512)[ C ];
      D |= (Mask + 256)[ C ];
      *Dst2++ = D | Mask[ *Src++ ];
      Src++;
   }
}
EXTERN void RGB32_To_RGB24( CMAPPER *CM, PIXEL *Dst, PIXEL *Src, INT Size )
{
   UINT *Mask;

   Mask = CM->Mask->Masks;
   while( --Size>=0 )
   {
      *Dst++ = *Src++;
      *Dst++ = *Src++;
      *Dst++ = *Src++;
      Src++;
   }
}

/**************************************************************/

EXTERN void RGB8_To_CMap8( CMAPPER *CM, PIXEL *Dst, PIXEL *Src, INT Size )
{
   COLOR_ENTRY *Mask;
   COLOR_ENTRY *Match;

   Mask = CM->Ditherer->Cols;
   Match = CM->Ditherer->Match;
   while( --Size>=0 )
   {
      PIXEL D; PIXEL C;
      C = Src[Size];
      D  = Mask[ C ][0];
      D |= Mask[ C ][1];      /* no green */
      D |= Mask[ C ][3];
      Dst[Size] = Match[D][INDEX_F];
   }
}
EXTERN void RGB16_To_CMap8( CMAPPER *CM, PIXEL *Dst, PIXEL *Src, INT Size )
{
   USHORT *Src2;
   COLOR_ENTRY *Mask;
   COLOR_ENTRY *Match;

   Mask = CM->Ditherer->Cols;   
   Match = CM->Ditherer->Match;
   Src2 = (USHORT *)Src;
   while( --Size>=0 )
   {
      PIXEL D; USHORT C;
      C = Src2[Size];
      D  = Mask[ C>>8 ][0];
      D |= Mask[ C>>8 ][1];
      D |= Mask[ C&0xFF ][2];
      D |= Mask[ C&0xFF ][3];
      Dst[Size] = Match[D][INDEX_F];
   }
}
EXTERN void RGB24_To_CMap8( CMAPPER *CM, PIXEL *Dst, PIXEL *Src, INT Size )
{
   COLOR_ENTRY *Mask;
   COLOR_ENTRY *Match;

   Mask = CM->Ditherer->Cols;
   Match = CM->Ditherer->Match;
   while( --Size>=0 )
   {
      PIXEL D;
      D  = Mask[ *Src++ ][3];
      D |= Mask[ *Src++ ][1];
      D |= Mask[ *Src++ ][0];
      *Dst++ = Match[D][INDEX_F];
   }
}

EXTERN void RGB32_To_CMap8( CMAPPER *CM, PIXEL *Dst, PIXEL *Src, INT Size )
{
   UINT *Src2;
   COLOR_ENTRY *Mask;
   COLOR_ENTRY *Match;

   Mask = CM->Ditherer->Cols;
   Match = CM->Ditherer->Match;
   Src2 = (UINT *)Src;
   while( --Size>=0 )
   {
      PIXEL D;
      D  = Mask[ *Src++ ][3];
      D |= Mask[ *Src++ ][1];
      D |= Mask[ *Src++ ][0];
      *Dst++ = Match[D][INDEX_F];
      Src++;
   }
}

/**************************************************************/

