/***********************************************
 *              Main header                    *
 *                                             *
 *  Public stuff needed to call the lib.       *
 *  Actually, it's just a "best of" various .h *
 *  files in ./lib_src :)                      *
 *                                             *
 * Skal 97                                     *
 ***********************************************/ 

#include <stdarg.h>

#ifndef _SL_H_
#define _SL_H_

/********************************************************/

#ifndef FALSE
#define FALSE     0
#endif
#ifndef TRUE
#define TRUE      1
#endif
#ifndef NULL
#define NULL		0
#endif

typedef void               VOID;
typedef char               BYTE;
typedef char              *STRING;
typedef unsigned char      PIXEL;
typedef short int          SHORT;
typedef unsigned long      UINT;
typedef long               INT;
typedef unsigned short int USHORT;
typedef long long int      LINT;

typedef void *MEM_IMAGE;    /* Public structure */

typedef struct _G_DRIVER_ _G_DRIVER_;

/********************************************************/

#define BLUE_F           0
#define GREEN_F          1
#define RED_F            2
#define INDEX_F          3
#define COL_BITS_FIX     8
typedef PIXEL COLOR_ENTRY[4];

/********************************************************/

   /* Result of zone clipping */

typedef enum  {
   ZONE_NO_CLIP  = 0x00,
   ZONE_CLIP_X   = 0x01,
   ZONE_CLIP_Y   = 0x02,
   ZONE_CLIP_XY  = 0x03,
   ZONE_CLIP_OUT = 0x04
} ZONE_CLIP_TYPE;

/********************************************************/

   /* Pixel formats */

typedef enum { 
   FMT_NONE = 0x0000,
   FMT_CMAP = 0x1000,
   FMT_233  = 0x1233,
   FMT_332  = 0x1332,
   FMT_444  = 0x2444,
   FMT_555  = 0x2555,
   FMT_565  = 0x2565,
   FMT_24b  = 0x3888,
   FMT_32b  = 0x4888
} FORMAT;

#define F_POS_MASK        0xCFFF0000
#define FMT_REVERSED_BIT  0x40000000
#define FMT_SPECIAL_BIT   0x80000000
#define Format_Depth(F)    ( ((F)>>12)&0x0F )
#define Format_F_Pos(F)    ( ( (F)&F_POS_MASK )>>16 )
#define Format_Red_Bits(F)     ( ((F)>>8)&0x0F )
#define Format_Green_Bits(F)   ( ((F)>>4)&0x0F )
#define Format_Blue_Bits(F)    ( (F)&0x0F )

/********************************************************/
/********************************************************/

#define New_MEM_Zone(M,m) (M *)_New_MEM_Zone( sizeof( M ), (m) )
extern MEM_IMAGE _New_MEM_Zone( INT Size, void *Methods );

#define Extract_Zone(m,t,w,h,x,y,M) Extract_Converted_Zone(m,t,w,h,x,y,0xFFFFFFFF,M)
extern MEM_IMAGE Extract_Converted_Zone(
   MEM_IMAGE New,
   MEM_IMAGE Target, INT Width, INT Height, INT X, INT Y, FORMAT Format,
   void *Original_Methods );

extern MEM_IMAGE Extract_Virtual_Zone( 
   MEM_IMAGE New,
   MEM_IMAGE Target,
   INT Width, INT Height, INT X, INT Y );

/********************************************************/

   /* Some flags... */

#define MEM_DONT_PROPAGATE    0x01

/********************************************************/
/********************************************************/

   /* Driver keyword */

typedef enum {

   DRV_END_ARG    = 0x0100,
   DRV_DETECT     = 0x0200,
   DRV_DETECT_VBE = 0x0300,
   DRV_MODE       = 0x0401,
   DRV_CONVERT    = 0x0500,
   DRV_DISPLAY    = 0x0601,
   DRV_DONT_USE   = 0x0701,
   DRV_NAME       = 0x0801,
   DRV_PRINT_INFO = 0x0900

} VAR_ARG_TYPE;

   /* REFRESH Methods for both DOS/VBE and Linux/Unix/X11/DGA. */

typedef enum {

   _VOID_        = 0x00,

      /* DOS/VBE specific */

   _INT_10h_     = 0x01,     /* Basic int(10, ) call */
   _RM_BNK_SW_   = 0x02,     /* R-Mode call */
   _PM_BNK_SW_   = 0x04,     /* P-Mode call */
   _LFB_         = 0x08,     /* LFB */
   _VGA_MODE_    = 0x10,     /* VGA (X-)mode */

   _SPEC_LFB_    = 0x20,
   _SPEC_BNK_SW_ = 0x40,
   _BNK_SW_      = 0x47,     /* all bank switch */
   _ALL_LFB_     = 0x28,

      /* X11 specific */

   _X_WINDOWS_   = 0x0100,
   _SHM_         = 0x0200
   
} REFRESH_MTHD;

#define _ALL_DOS_METHODS_  (0x00FF)
#define _ALL_X11_METHODS_  (0x0F00)
#define _ALL_REFRESH_METHODS_  (_ALL_DOS_METHODS_|_ALL_X11_METHODS_)

/********************************************************/

   /* uniformized Events */

typedef enum {
   DRV_NULL_EVENT = 0x00,
   DRV_CLICK1     = 0x01,
   DRV_CLICK2     = 0x02,
   DRV_CLICK3     = 0x04,
   DRV_MOVE       = 0x08,
   DRV_RELEASE1   = 0x10,
   DRV_RELEASE2   = 0x20,
   DRV_RELEASE3   = 0x40,
   DRV_KEY_PRESS  = 0x80,
   DRV_CLICK      = (0x01|0x02|0x04),
   DRV_RELEASE    = (0x10|0x20|0x40)
} EVENT_TYPE;

typedef enum {
   DRV_NO_MODIFIER    = 0x00,
   DRV_ALT_MODIFIER   = 0x01, 
   DRV_CTRL_MODIFIER  = 0x02,
   DRV_SHIFT_MODIFIER = 0x04,
   DRV_UP_MODIFIER    = 0x08,
   DRV_DOWN_MODIFIER  = 0x10,
   DRV_LEFT_MODIFIER  = 0x20,
   DRV_RIGHT_MODIFIER = 0x40
} MODIFIER_TYPE;

typedef struct DRV_EVENT DRV_EVENT;
struct DRV_EVENT {

   EVENT_TYPE  Event;
   BYTE  Key;
   MODIFIER_TYPE  Modifier;
   INT   x, y;
};

/********************************************************/

#ifndef DOS

extern _G_DRIVER_ *_G_X11_DRIVER_;

#ifndef DONT_USE_DGA
extern _G_DRIVER_ *_G_DGA_DRIVER_;
#else
#define _G_DGA_DRIVER_ NULL
#endif

#ifdef USE_SVGALIB
extern _G_DRIVER_ *_G_SVGL_DRIVER_;
#else
#define _G_SVGL_DRIVER_ NULL
#endif

#else	/* DOS */
#define _G_X11_DRIVER_   NULL
#define _G_DGA_DRIVER_   NULL
#define _G_SVGL_DRIVER_  NULL
#endif



#ifdef DOS
extern _G_DRIVER_ *_G_VBE_DRIVER_;
#else
#define _G_VBE_DRIVER_ NULL
#endif


/********************************************************/ 

extern void Register_Video_Support( INT Nb, ... );

extern void Print_Driver_Error( );

extern MEM_IMAGE Driver_Call( _G_DRIVER_ *Driver, ... );

extern MEM_IMAGE Driver_Open_Mode( MEM_IMAGE M, INT Nb );
extern void Driver_Close( MEM_IMAGE  );
extern EVENT_TYPE Driver_Get_Event( MEM_IMAGE M );
extern INT Driver_Change_CMap( MEM_IMAGE M, INT Nb, COLOR_ENTRY *CMap );

extern INT Driver_Nb_Req_Modes( MEM_IMAGE M );
extern INT Driver_Cur_Req_Mode( MEM_IMAGE M );

extern INT Zone_Width( MEM_IMAGE M );
extern INT Zone_Height( MEM_IMAGE M );
extern INT Zone_BpS( MEM_IMAGE M );
extern INT Zone_Pad( MEM_IMAGE M );
extern PIXEL *Zone_Base_Ptr( MEM_IMAGE M );
extern INT Zone_Quantum( MEM_IMAGE M );
extern FORMAT Zone_Format( MEM_IMAGE M );
extern INT Zone_Size( MEM_IMAGE M );
extern MEM_IMAGE Zone_Dst( MEM_IMAGE M );

extern PIXEL *Zone_Scanline( MEM_IMAGE M, INT Y );
extern INT Zone_Propagate( MEM_IMAGE M, INT X, INT Y, INT W, INT H );
extern INT Zone_Flush( MEM_IMAGE M );
extern INT Zone_Flush_Safe( MEM_IMAGE M );
extern void Zone_Set_Position( MEM_IMAGE M, INT X, INT Y, INT Backup );
extern void Zone_Destroy( MEM_IMAGE M );

extern INT Zone_Flags( MEM_IMAGE M );
extern INT Zone_Clear_Flags( MEM_IMAGE M, INT Flag );
extern INT Zone_Set_Flags( MEM_IMAGE M, INT Flag );
extern INT Zone_Xo( MEM_IMAGE M );
extern INT Zone_Yo( MEM_IMAGE M );

/********************************************************/

   /* Misc... */

extern void *My_Malloc( int );
#define M_Free(x)   { if ((x)!=NULL) My_Free((x)); (x)=NULL; }
#define New_Object(N,type) ( (type *)My_Malloc( (N)*sizeof(type) ) )
#define Mem_Clear(P)     bzero( (void *)(P), sizeof( *(P) ) )

/********************************************************/
/********************************************************/

#endif /* _SL_H_ */
