/*
Code: Thomas Austad
Info: 3d vector class
*/

#include <math.h>
#include "vector3.h"

/*
   ============
   constructors
   ============
*/

Vector3T::Vector3T(void)
{
   Vec[0] = Vec[1] = Vec[2] = 0.;
}

Vector3T::Vector3T(const Vector3T& v)
{
   Vec[0] = v.Vec[0];
   Vec[1] = v.Vec[1];
   Vec[2] = v.Vec[2];
}

Vector3T::Vector3T(VecMat_t x,VecMat_t y,VecMat_t z)
{
   Vec[0] = x;
   Vec[1] = y;
   Vec[2] = z;
}

/*
   ===============================
   overloaded assignment operators
   ===============================
*/

void Vector3T::operator = (const Vector3T& v)
{
   Vec[0] = v.Vec[0];
   Vec[1] = v.Vec[1];
   Vec[2] = v.Vec[2];
}

void Vector3T::operator += (const Vector3T& v)
{
   Vec[0] += v.Vec[0];
   Vec[1] += v.Vec[1];
   Vec[2] += v.Vec[2];   
}

void Vector3T::operator -= (const Vector3T& v)
{
   Vec[0] -= v.Vec[0];
   Vec[1] -= v.Vec[1];
   Vec[2] -= v.Vec[2];
}

void Vector3T::operator *= (const Vector3T& v)
{
   Vec[0] *= v.Vec[0];
   Vec[1] *= v.Vec[1];
   Vec[2] *= v.Vec[2];
}

void Vector3T::operator *= (VecMat_t k)
{
   Vec[0] *= k;
   Vec[1] *= k;
   Vec[2] *= k;
}

/*
   ===============================================
   overloaded operators which returns a new vector
   ===============================================
*/
#ifdef __GNUG__
Vector3T Vector3T::operator + (const Vector3T& v) return r;
#else
Vector3T Vector3T::operator + (const Vector3T& v)
#endif
{
#ifndef __GNUG__
   Vector3T r;
#endif
   r.Vec[0] = Vec[0] + v.Vec[0];
   r.Vec[1] = Vec[1] + v.Vec[1];
   r.Vec[2] = Vec[2] + v.Vec[2];
   return r;
}


#ifdef __GNUG__
Vector3T Vector3T::operator - (const Vector3T& v) return r;
#else
Vector3T Vector3T::operator - (const Vector3T& v)
#endif
{
#ifndef __GNUG__
   Vector3T r;
#endif
   r.Vec[0] = Vec[0] - v.Vec[0];
   r.Vec[1] = Vec[1] - v.Vec[1];
   r.Vec[2] = Vec[2] - v.Vec[2];
   return r;
}


#ifdef __GNUG__
Vector3T Vector3T::operator * (const Vector3T& v) return r;
#else
Vector3T Vector3T::operator * (const Vector3T& v)
#endif
{
#ifndef __GNUG__
   Vector3T r;
#endif
   r.Vec[0] = Vec[0] * v.Vec[0];
   r.Vec[1] = Vec[1] * v.Vec[1];
   r.Vec[2] = Vec[2] * v.Vec[2];
   return r;
}


#ifdef __GNUG__
Vector3T Vector3T::operator * (VecMat_t k) return r;
#else
Vector3T Vector3T::operator * (VecMat_t k)
#endif
{
#ifndef __GNUG__
   Vector3T r;
#endif
   r.Vec[0] = Vec[0] * k;
   r.Vec[1] = Vec[1] * k;
   r.Vec[2] = Vec[2] * k;
   return r;
}

/*
   ================
   public operators
   ================
*/

VecMat_t Vector3T::Length(void)
{
#define SQR(a)  ((a)*(a))
   return sqrt(SQR(Vec[0])+SQR(Vec[1])+SQR(Vec[2]));
#undef SQR
}

VecMat_t Vector3T::Distance(const Vector3T& v)
{
#define SQR(a)  ((a)*(a))
   return sqrt(SQR(v.Vec[0]-Vec[0])+SQR(v.Vec[1]-Vec[1])+SQR(v.Vec[2]-Vec[2]));
#undef SQR
}

VecMat_t Vector3T::Dot(const Vector3T& v)
{
   return (Vec[0]*v.Vec[0]+Vec[1]*v.Vec[1]+Vec[2]*v.Vec[2]);
}

VecMat_t Vector3T::CrossZ(const Vector3T& v)
{
   return (Vec[0]*v.Vec[1] - Vec[1]*v.Vec[0]);
}


#ifdef __GNUG__
Vector3T Vector3T::Cross(const Vector3T& v) return r;
#else
Vector3T Vector3T::Cross(const Vector3T& v)
#endif
{
#ifndef __GNUG__
   Vector3T r;
#endif
   r.Vec[0] = Vec[1]*v.Vec[2] - Vec[2]*v.Vec[1];
   r.Vec[1] = Vec[2]*v.Vec[0] - Vec[0]*v.Vec[2];
   r.Vec[2] = Vec[0]*v.Vec[1] - Vec[1]*v.Vec[0];
   return r;
}

void Vector3T::Unit(void)
{
   VecMat_t l = Length();
   if(l!=0.||l!=1.) {
      Vec[0] /= l;
      Vec[1] /= l;
      Vec[2] /= l;
   }
}
