/////////////////////////////////////////////////////////////////////////////
// StarzView.h : interface of the CStarzView class

#if !defined(STARZVIEW_H)
#define STARZVIEW_H
#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

class CStar;
class CStarzDoc;

class CStarzView : public CView
{
protected: // create from serialization only
	CStarzView();
	DECLARE_DYNCREATE(CStarzView)

// Attributes
public:
	CStarzDoc* GetDocument();

	unsigned int getDensity(void) const;
	unsigned int getVelocity(void) const;

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CStarzView)
	public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	virtual void OnInitialUpdate();
	protected:
	virtual void OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CStarzView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
protected:
	//{{AFX_MSG(CStarzView)
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnStarsReverse();
	afx_msg void OnUpdateStarsReverse(CCmdUI* pCmdUI);
	afx_msg void OnStarsColorNone();
	afx_msg void OnUpdateStarsColorNone(CCmdUI* pCmdUI);
	afx_msg void OnStarsColorRed();
	afx_msg void OnUpdateStarsColorRed(CCmdUI* pCmdUI);
	afx_msg void OnStarsColorGreen();
	afx_msg void OnUpdateStarsColorGreen(CCmdUI* pCmdUI);
	afx_msg void OnStarsColorBlue();
	afx_msg void OnUpdateStarsColorBlue(CCmdUI* pCmdUI);
	afx_msg void OnStarsDensity();
	afx_msg void OnStarsPause();
	afx_msg void OnUpdateStarsPause(CCmdUI* pCmdUI);
	afx_msg void OnStarsVelocity();
	afx_msg void OnStarsSmooth();
	afx_msg void OnUpdateStarsSmooth(CCmdUI* pCmdUI);
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnRButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnStarsVertical();
	afx_msg void OnUpdateStarsVertical(CCmdUI* pCmdUI);
	afx_msg void OnStarsRestartHorizontal();
	afx_msg void OnStarsRestartVertical();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

private:
	CStar* stars;
	unsigned int density;
	unsigned int velocity;
	bool pause;
};

#ifndef _DEBUG  // debug version in StarzView.cpp
inline CStarzDoc* CStarzView::GetDocument()
   { return (CStarzDoc*)m_pDocument; }
#endif

inline unsigned int CStarzView::getDensity(void) const
{
	return this->density;
}

inline unsigned int CStarzView::getVelocity(void) const
{
	return this->velocity;
}

/////////////////////////////////////////////////////////////////////////////

#endif // !defined(STARZVIEW_H)
