// Star.cpp
//
// Copyright (C) 1998 by David A Henry (VuLgAr UnIcOrN)
// dhenry@bigfoot.com

#include "StdAfx.h"
#include "Starz.h"
#include "Star.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

// init statics
bool CStar::reverse = false;
bool CStar::vertical = false;
bool CStar::red = false;
bool CStar::green = false;
bool CStar::blue = true;
bool CStar::smooth = true;

CStar::CStar(void) : x(0), y(0), lightSpeedSize(0), first(true)
{
	// random initial brightness / speed / size
	this->lightSpeedSize = this->getRandomNumber(255) + 1;
}

CStar::~CStar(void)
{
}

void CStar::restartHorizontal(void)
{
	// if we are vertical then zero y otherwize zero x
	if (this->vertical) this->y = 1;
	else this->x = 1;
}

void CStar::restartVertical(void)
{
	// if we are vertical then zero x otherwize zero y
	if (this->vertical) this->x = 1;
	else this->y = 1;
}

void CStar::update(CDC* pDC, const CRect& rect)
{
	// if this is the stars first update
	// perform some initilization stuff
	if (this->first)
	{
		// make sure we can do this here
		if (!(pDC->GetDeviceCaps(RASTERCAPS) & RC_BITBLT)) return;
		// initial random starting position
		this->x = this->getRandomNumber(rect.Width());
		this->y = this->getRandomNumber(rect.Height());
		// reset for next time
		this->first = false;
	}
	else
	{
		// this will erase the old one
		this->draw(pDC, 0, 0, 0, false);
	}

	if (this->vertical)
	{
		// if backwards
		if (this->reverse)
		{
			// if wrap
			int newY = this->y - (!this->smooth ? lightSpeedSize : ((this->getRandomNumber(255) <= lightSpeedSize) ? 1 : 0));
			if (newY <= 0)
			{
				// reset y and randomize x
				this->y = rect.Height() - newY;
				this->x = this->getRandomNumber(rect.Width());
				this->lightSpeedSize = this->getRandomNumber(255) + 1;
			}
			else
			{
				// dec y
				this->y = newY;
			}
		}
		// if forward
		else
		{
			// if wrap
			int newY = this->y + (!this->smooth ? lightSpeedSize : ((this->getRandomNumber(255) <= lightSpeedSize) ? 1 : 0));
			if (newY >= rect.Height())
			{
				// reset y and randomize x
				this->y = newY - rect.Height();
				this->x = this->getRandomNumber(rect.Width());
				this->lightSpeedSize = this->getRandomNumber(255) + 1;
			}
			else
			{
				// inc y
				this->y = newY;
			}
		}
	}
	else
	{
		// if backwards
		if (this->reverse)
		{
			// if wrap
			int newX = this->x - (!this->smooth ? lightSpeedSize : ((this->getRandomNumber(255) <= lightSpeedSize) ? 1 : 0));
			if (newX <= 0)
			{
				// reset x and randomize y
				this->x = rect.Width() - newX;
				this->y = this->getRandomNumber(rect.Height());
				this->lightSpeedSize = this->getRandomNumber(255) + 1;
			}
			else
			{
				// dec x
				this->x = newX;
			}
		}
		// if forward
		else
		{
			// if wrap
			int newX = this->x + (!this->smooth ? lightSpeedSize : ((this->getRandomNumber(255) <= lightSpeedSize) ? 1 : 0));
			if (newX >= rect.Width())
			{
				// reset x and randomize y
				this->x = newX - rect.Width();
				this->y = this->getRandomNumber(rect.Height());
				this->lightSpeedSize = this->getRandomNumber(255) + 1;
			}
			else
			{
				// inc x
				this->x = newX;
			}
		}
	}

	// draw the actual star using lightSpeedSize for the color
	// the draw method takes care of tinting r g or b
	this->draw(pDC, this->lightSpeedSize, this->lightSpeedSize, this->lightSpeedSize, true);
}

void CStar::draw(CDC* pDC, unsigned int r, unsigned int g, unsigned int b, bool change /*=true*/)
{
	COLORREF cr;

	// if change is false we do not change the colors from the ones passed in
	// this is so that we can pass in all black with change = false to undraw the star
	if (change) cr = RGB((this->red ? 255 : r), (this->green ? 255 : g), (this->blue ? 255 : b));
	else cr = RGB(r, g, b);

	// draw the initial pixel
	pDC->SetPixelV(this->x, this->y, cr);

	// all the rest is for bigger stars
	// the faster they are the brighter and bigger they are
	// so i just change the color and draw some pixels arounf the initial one
	if (this->lightSpeedSize > 25)
	{
		if (change) cr = RGB((this->red ? 255 : r-10), (this->green ? 255 : g-10), (this->blue ? 255 : b-10));
		pDC->SetPixelV(this->x-1, this->y-1, cr);
		pDC->SetPixelV(this->x-1, this->y+1, cr);
		pDC->SetPixelV(this->x+1, this->y-1, cr);
		pDC->SetPixelV(this->x+1, this->y+1, cr);
		if (this->lightSpeedSize > 50)
		{
			if (change) cr = RGB((this->red ? 255 : r-20), (this->green ? 255 : g-20), (this->blue ? 255 : b-20));
			pDC->SetPixelV(this->x+1, this->y, cr);
			pDC->SetPixelV(this->x-1, this->y, cr);
			pDC->SetPixelV(this->x, this->y+1, cr);
			pDC->SetPixelV(this->x, this->y-1, cr);
			if (this->lightSpeedSize > 75)
			{
				if (change) cr = RGB((this->red ? 255 : r-30), (this->green ? 255 : g-30), (this->blue ? 255 : b-30));
				pDC->SetPixelV(this->x-2, this->y-2, cr);
				pDC->SetPixelV(this->x-2, this->y+2, cr);
				pDC->SetPixelV(this->x+2, this->y-2, cr);
				pDC->SetPixelV(this->x+2, this->y+2, cr);
				if (this->lightSpeedSize > 100)
				{
					if (change) cr = RGB((this->red ? 255 : r-40), (this->green ? 255 : g-40), (this->blue ? 255 : b-40));
					pDC->SetPixelV(this->x+2, this->y, cr);
					pDC->SetPixelV(this->x-2, this->y, cr);
					pDC->SetPixelV(this->x, this->y+2, cr);
					pDC->SetPixelV(this->x, this->y-2, cr);
					if (this->lightSpeedSize > 125)
					{
						if (change) cr = RGB((this->red ? 255 : r-50), (this->green ? 255 : g-50), (this->blue ? 255 : b-50));
						pDC->SetPixelV(this->x-3, this->y-3, cr);
						pDC->SetPixelV(this->x-3, this->y+3, cr);
						pDC->SetPixelV(this->x+3, this->y-3, cr);
						pDC->SetPixelV(this->x+3, this->y+3, cr);
						if (this->lightSpeedSize > 150)
						{
							if (change) cr = RGB((this->red ? 255 : r-60), (this->green ? 255 : g-60), (this->blue ? 255 : b-60));
							pDC->SetPixelV(this->x+3, this->y, cr);
							pDC->SetPixelV(this->x-3, this->y, cr);
							pDC->SetPixelV(this->x, this->y+3, cr);
							pDC->SetPixelV(this->x, this->y-3, cr);
							if (this->lightSpeedSize > 175)
							{
								if (change) cr = RGB((this->red ? 255 : r-70), (this->green ? 255 : g-70), (this->blue ? 255 : b-70));
								pDC->SetPixelV(this->x-4, this->y-4, cr);
								pDC->SetPixelV(this->x-4, this->y+4, cr);
								pDC->SetPixelV(this->x+4, this->y-4, cr);
								pDC->SetPixelV(this->x+4, this->y+4, cr);
								if (this->lightSpeedSize > 200)
								{
									if (change) cr = RGB((this->red ? 255 : r-80), (this->green ? 255 : g-80), (this->blue ? 255 : b-80));
									pDC->SetPixelV(this->x+4, this->y, cr);
									pDC->SetPixelV(this->x-4, this->y, cr);
									pDC->SetPixelV(this->x, this->y+4, cr);
									pDC->SetPixelV(this->x, this->y-4, cr);
									if (this->lightSpeedSize > 225)
									{
										if (change) cr = RGB((this->red ? 255 : r-90), (this->green ? 255 : g-90), (this->blue ? 255 : b-90));
										pDC->SetPixelV(this->x-5, this->y-5, cr);
										pDC->SetPixelV(this->x-5, this->y+5, cr);
										pDC->SetPixelV(this->x+5, this->y-5, cr);
										pDC->SetPixelV(this->x+5, this->y+5, cr);
									}
								}
							}
						}
					}
				}
			}
		}
	}
}
