#if !defined( __LAND_H )
#ifdef __cplusplus
extern "C" {
#endif
#define __LAND_H

#include <types.h>

#define VERSIONH    0
#define VERSIONL    00

#define CLIP_PLANES 4

#include "matrix.h"

#pragma pack(1)

typedef struct {
    float a,b,c,d;
}MAT_PLANO;

#pragma pack()

#define OUT_CACHED    0x80000000
#define TIMECOUNT     0x3fffffff
#define ACLIP_CACHED  0x1
#define BCLIP_CACHED  0x2
#define CACHED_EDGES  5000

// Si el bit ms alto de cacheoffset est activado el resto del DWORD indica
//  el frame en el cual se cacheo una arista totalmente fuera de pantalla

typedef struct {
    WORD a,b;
    DWORD cacheoffset;
}EDGE;

typedef struct {
    float x1,y1;
    float x2,y2;
    float nzi;
    FIXED16 slope;
    DWORD flags;
}STACK_EDGE;

typedef struct {
    float x,y;
}PIXEL;

#pragma pack(1)
typedef struct {            // Debe coincidir con types.inc
        float x,y;
        FIXED16 slope;
}VERTEX;
#pragma pack()

typedef struct CACHE_BLOCK_S{
    DWORD size;
    BYTE *data;
    struct CACHE_BLOCK_S **owner;
    struct CACHE_BLOCK_S *next;
}CACHE_BLOCK;

typedef struct {
    MAT_PLANO eq;

    BYTE texture;
    VECTOR p,m,n;
    SDWORD minu,minv;
    float width,height;
    float mipadjust;

    CACHE_BLOCK *scache[4];      // Poner en Macro el nmero de Mipmappings

    DWORD start_edge;
    BYTE no_edges;
    BYTE reserved[3];
}NGON;

typedef struct BSP_TREE_S {
    NGON root;
    float limit[6];             // (xmin,ymin,zmin) - (xmax,ymax,zmax)
    struct BSP_TREE_S *left,*right;
}BSP_TREE;

typedef struct {
    BYTE alpha,red,green,blue;
}ORGB;

typedef struct {
    BYTE name[20];
    float width,height;
    ORGB pal[4][256];
    DWORD offset[4];
}TEXTURE;

typedef struct {
    BYTE min[3];            // Indices al campo limit de cada nodo
    BYTE max[3];
    VECTOR normal;
}CLIP_PLANE;

typedef struct {
    float fov;
    float xscale,yscale;
    float centerx,centery;
    CLIP_PLANE view_frustum[CLIP_PLANES];
    MATRIZ w_cam;
}CAMERA;

typedef struct {
    VECTOR pos;
    VECTOR target;
    float roll;
}CAMERA_FRAME;

typedef struct {

    DWORD no_vertex;
    DWORD no_edges;
    DWORD no_polys;
    DWORD used_edges;
    DWORD no_maps;

    BYTE *base;
    VECTOR *pts;
    EDGE *edges;
    BSP_TREE *bsp;
    SWORD *edge_list;
    TEXTURE *maps;
    BYTE *bitmap;

    CAMERA camera;
    MAT_PLANO world_frustum[CLIP_PLANES];


}WORLD;

void initworld(BYTE *, BYTE *, DWORD);
void initworld2(void);
void frame_world(DWORD);

void init_world(void);
void get_world_position(MATRIZ, VECTOR *);
void transform_frustum(CLIP_PLANE *, MAT_PLANO *, VECTOR *, MATRIZ cam);

void show_nfo(void);

void shut_down_world(void);

void fatal_error(const BYTE *, ...);

extern DWORD n_cached_edges;
extern DWORD n_reused_edges;
extern CACHE_BLOCK *surf_base;
extern CAMERA_FRAME *track_camera;
extern BOOLEAN icg_boss;

#ifdef __cplusplus
};
#endif
#endif
