// Control de la cmara. De momento se permite control del usuario o bien
//   leer una ruta precalculada.

// Mejoras: -Sincronizar la lectura de la ruta precalculada
//          -Leer el FOV en cada frame?

#include "camera.h"

CAMERA_FRAME *track_camera;
DWORD camera_frames;
BOOLEAN camera_loaded,loop=TRUE;

float vel=0.0;
float rotx=0.0;
float roty=0.0;
float rotz=0.0;

void update_camera(DWORD counter) {

    VECTOR pos,dst;

    float alpha,beta;

    // Movimiento manual

    if(icg_boss) {

        if(K_UP) {
            vel+=VEL_ACEL;
            camera_loaded=FALSE;
        }
        if(K_DOWN) {
            vel-=VEL_ACEL;
            camera_loaded=FALSE;
        }
        if(K_PGUP) {
            rotx+=ROT_ACEL;
            camera_loaded=FALSE;
        }
        if(K_PGDN) {
            rotx-=ROT_ACEL;
            camera_loaded=FALSE;
        }
        if(K_LEFT) {
            roty+=ROT_ACEL;
            camera_loaded=FALSE;
        }
        if(K_RIGHT) {
            roty-=ROT_ACEL;
            camera_loaded=FALSE;
        }
        if(K_Z) {
            rotz+=ROT_ACEL;
            camera_loaded=FALSE;
        }
    }

    if(vel>EPSILON) vel-=VEL_DECEL;
    else if(vel<-EPSILON) vel+=VEL_DECEL;

    if(rotx>EPSILON) rotx-=ROT_DECEL;
    else if(rotx<-EPSILON) rotx+=ROT_DECEL;

    if(roty>EPSILON) roty-=ROT_DECEL;
    else if(roty<-EPSILON) roty+=ROT_DECEL;

    if(rotz>EPSILON) rotz-=ROT_DECEL;
    else if(rotz<-EPSILON) rotz+=ROT_DECEL;

    if(vel>VEL_MAX) vel=VEL_MAX;
    else if (vel<-VEL_MAX) vel=-VEL_MAX;

    if(rotx>ROT_MAX) rotx=ROT_MAX;
    else if(rotx<-ROT_MAX) rotx=-ROT_MAX;

    if(roty>ROT_MAX) roty=ROT_MAX;
    else if(roty<-ROT_MAX) roty=-ROT_MAX;

    if(rotz>ROT_MAX) rotz=ROT_MAX;
    else if(rotz<-ROT_MAX) rotz=-ROT_MAX;

    translation(world_mesh.camera.w_cam,0,0,-vel);
    rotation_x(world_mesh.camera.w_cam,-rotx);
    rotation_y(world_mesh.camera.w_cam,-roty);
    rotation_z(world_mesh.camera.w_cam,-rotz);

    // Movimiento por splines precalculadas

    if(counter<camera_frames && camera_loaded) {

        pos=(track_camera+counter)->pos;
        dst=(track_camera+counter)->target;

        dst.x-=pos.x;
        dst.y-=pos.y;
        dst.z-=pos.z;

        init_matriz(world_mesh.camera.w_cam);

        world_mesh.camera.w_cam[3][0]=-pos.x;
        world_mesh.camera.w_cam[3][1]=pos.y;
        world_mesh.camera.w_cam[3][2]=-pos.z;

        if(!zero(dst.x) || !zero(dst.z)) {

            alpha=acos(dst.z/(sqrt(dst.x*dst.x+dst.z*dst.z)));
            if(dst.x<0) alpha=-alpha;

            rotation_y(world_mesh.camera.w_cam,alpha);

        }


        if(!zero(world_mesh.camera.w_cam[2][0]))
            dst.z=-dst.x/world_mesh.camera.w_cam[2][0];
        else
            dst.z=dst.z/world_mesh.camera.w_cam[2][2];

        if(!zero(dst.z) || !zero(dst.y)) {

            beta=acos(dst.z/(sqrt(dst.z*dst.z+dst.y*dst.y)));
            if(dst.y<0) beta=-beta;

            rotation_x(world_mesh.camera.w_cam,-beta);

        }

        rotation_z(world_mesh.camera.w_cam,-(track_camera+counter)->roll);

    }

}
