#include <stdio.h>
#include <stdarg.h>
#include "audio.h"
#include "music.h"
#include "graphs.h"
#include "arg.h"

LPAUDIOMODULE lpModule;
BOOLEAN music_installed=FALSE;
BOOLEAN module_loaded=FALSE;

const void fatal_error(BYTE *, ...);

void show_devices(void) {

    UINT nDevId;
    AUDIOCAPS caps;

    AInitialize();

    for (nDevId = 0; nDevId < AGetAudioNumDevs(); nDevId++) {
        AGetAudioDevCaps(nDevId, &caps);
        printf("\t%2d. %s\n", nDevId, caps.szProductName);
    }
    printf("\n");

}

BYTE *init_music(SBYTE device, WORD bits, WORD stereo, WORD filter, DWORD srate) {

    AUDIOINFO info;
    UINT rc;
    CHAR szText[80];
    static AUDIOCAPS caps;

    if(!music_installed) {

        if(AInitialize()) fatal_error("Error (init_music): AInitialize()");

        if(device==AUDIO_AUTODETECT)
            info.nDeviceId=AUDIO_DEVICE_MAPPER;
        else info.nDeviceId=device;

        info.wFormat=bits|stereo|filter;
        info.nSampleRate=srate;

        if ((rc = AOpenAudio(&info)) != AUDIO_ERROR_NONE) {
            AGetErrorText(rc, szText, sizeof(szText) - 1);
            fatal_error("Error (init_music): %s",szText);
        }

        AGetAudioDevCaps(info.nDeviceId, &caps);

        music_installed=TRUE;

        return caps.szProductName;
    }

    return NULL;
}

static void update(void) {

    AUpdateAudio();

}

void load_song(BYTE *name,DWORD off) {

    if(!module_loaded) {

        if(ALoadModuleFile(name, &lpModule, off))
            fatal_error("Error (ALoadModuleFile): %s",name);

        AOpenVoices(lpModule->nTracks);

        lib_music_handler(update);
        module_loaded=TRUE;
    }

}

void play_music() {

    APlayModule(lpModule);

}

void stop_music() {

    AStopModule();

}

void unload_song(void) {

    if(module_loaded) {

        ACloseVoices();
        AFreeModuleFile(lpModule);

        module_loaded=FALSE;

    }

}

void end_music(void) {

    if(music_installed) {
        ACloseAudio();
        music_installed=FALSE;
    }

}

DWORD get_song_pos(void) {

    SWORD row,pattern;

    AGetModulePosition((LPUINT)&pattern,(LPUINT)&row);

    return (pattern<<16)+row;


}

void set_song_pos(DWORD pos) {

    UINT pattern,row;

    pattern=pos>>16;
    row=pos&0xffff;

    ASetModulePosition(pattern, row);


}
