#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <conio.h>
#include <string.h>
#include <types.h>
#include <timer.h>
#include <graphs.h>
#include <font.h>
#include <keyb_hnd.h>
#include <icp.h>
#include <log.h>

#include "..\seal\music.h"

#define DEBUG    FALSE
#define TIME      1875              // Duracin de la animacin (en frames)
#define UMBRAL     100
#define SIZEX       10              // Tamao de la malla
#define SIZEY       17
#define SIZEZ       22
#define NO_METAS     3
#define GRID 32

#pragma pack(1)

typedef struct {
        SDWORD x,y;
        SDWORD u,v;
        DWORD color;
}VERTEX;

typedef struct {
    SBYTE x,y,z;
}VECTOR;

typedef struct {
    VECTOR a0,a1;
    VECTOR b0,b1;
    VECTOR c0,c1;
}TRIANGLE;

typedef struct {
    BYTE no_triangles;
    TRIANGLE triangle[4];
}PATTERN;

typedef struct {
    float x,y,z;
}POINT;

#pragma pack()

typedef struct {
    float a;
    float b;
    float x,y,z;
    POINT *pos;
}META;

typedef struct {
    BYTE u,v;
}TEXEL;

typedef struct {
    POINT a,b,c;
    TEXEL na,nb,nc;
}ITRIANGLE;

void fatal_error(const BYTE *, ...);
void render(float (*)[SIZEZ][SIZEY][SIZEX], PATTERN *);
void build_polys(SDWORD, SDWORD, SDWORD, float (*)[SIZEZ][SIZEY][SIZEX], PATTERN *);
void calc_field(float (*)[SIZEZ][SIZEY][SIZEX], META (*)[NO_METAS]);
void interpolate(SDWORD, SDWORD, SDWORD, SDWORD, SDWORD, SDWORD,
                float (*)[SIZEZ][SIZEY][SIZEX], TEXEL *, POINT *);
void paint(BYTE *);
void inc_time(void);
void read_path(META *, BYTE *);

void draw_clip_line(DWORD, DWORD, DWORD, DWORD, BYTE);
#pragma aux draw_clip_line parm [ecx][eax][esi][ebx][edx];
void draw_texture_poly(VERTEX *, BYTE *);
#pragma aux draw_texture_poly parm [esi][eax];

void blur15(BYTE *, BYTE *, BYTE *, DWORD);
#pragma aux blur15 parm [edi][esi][edx][ecx];

void blur16(BYTE *, BYTE *, BYTE *, DWORD);
#pragma aux blur16 parm [edi][esi][edx][ecx];

BYTE read_tga_map(BYTE *,BYTE *,BYTE *);
BYTE read_tga_picture(BYTE *, BYTE *, DWORD, DWORD);
void convert_pal(BYTE *pal);
void convert_pal_8(BYTE *palin, BYTE *palout);
BYTE precalc_gouraud(BYTE *, BYTE *, BYTE *, float, float, float, float);

#define MAGIC ((((65536.0*65536.0*16)+(65536.0*0.5))*65536))

DWORD real2int(float val) {

    double temp=MAGIC+val;
    return ((*(DWORD *)&temp)-0x80000000);
}

extern BYTE *virtual;
extern BOOLEAN icg_boss;
static DWORD cur_tri;

ITRIANGLE *tri;

static float pfrm;
static DWORD cur_frm;
static META meta[NO_METAS];
static PATTERN *iso_srf;
static float (*campo)[SIZEZ][SIZEY][SIZEX];
static BYTE *textura;
static BYTE *blur;
static BYTE *old_virtual;
static BYTE *background;
static BYTE fps_info[15];
static DWORD last_frame,temp_frame;
static float last_time,temp_time,fps;

void init_meta(BYTE *pic) {

    pfrm=lib_get_time();
    cur_frm=0;
    last_time=lib_get_time();
    fps=0;

    if((textura=malloc(256*256*sizeof(BYTE)+256*4))==NULL)
        fatal_error("Not enough memory");

    if((tri=malloc(2000*sizeof(ITRIANGLE)))==NULL)
        fatal_error("Not enough memory");

    if((campo=malloc(2*SIZEX*SIZEY*SIZEZ*sizeof(float)))==NULL)
        fatal_error("Not enough memory");

    if((iso_srf=lib_fopen("iso.dat"))==NULL)
        fatal_error("Can't open iso.dat");

    lib_log(2,"read_path 0");
    read_path(&meta[0],"ruta0.dat");
    lib_log(2,"read_path 1");
    read_path(&meta[1],"ruta1.dat");
    lib_log(2,"read_path 2");
    read_path(&meta[2],"ruta2.dat");


    lib_log(2,"read_tga_map('metal7.tga')");
    if(read_tga_map("metal7.tga",textura,textura+256*256))
        fatal_error("Can't load texture");


    meta[0].a=1.1;
    meta[0].b=5;
    meta[0].x=meta[0].pos->x;
    meta[0].y=meta[0].pos->y;
    meta[0].z=meta[0].pos->z;

    meta[1].a=1.1;
    meta[1].b=5;
    meta[1].x=meta[1].pos->x;
    meta[1].y=meta[1].pos->y;
    meta[1].z=meta[1].pos->z;

    meta[2].a=1.2;
    meta[2].b=5;
    meta[2].x=meta[2].pos->x;
    meta[2].y=meta[2].pos->y;
    meta[2].z=meta[2].pos->z;

    old_virtual=virtual;

    if((blur=malloc(graphics_system.image_size))==NULL)
        fatal_error("Not enough memory");

    if((background=malloc(graphics_system.image_size))==NULL)
        fatal_error("Not enough memory");

    lib_log(2,"convert_pal");
    convert_pal(textura+256*256);

    background=pic;

}

void frame_meta(void) {

    memcpy(blur,background,graphics_system.image_size);
    calc_field(campo,meta);
    render(campo,iso_srf);
    old_virtual=virtual;
    virtual=blur;
    paint(textura);
    virtual=old_virtual;

    cur_frm=(DWORD)((lib_get_time()-pfrm)*50.0);

    if(cur_frm<TIME) {

        meta[0].x=(meta[0].pos+cur_frm)->x;
        meta[0].y=(meta[0].pos+cur_frm)->y;
        meta[0].z=(meta[0].pos+cur_frm)->z;
        meta[1].x=(meta[1].pos+cur_frm)->x;
        meta[1].y=(meta[1].pos+cur_frm)->y;
        meta[1].z=(meta[1].pos+cur_frm)->z;
        meta[2].x=(meta[2].pos+cur_frm)->x;
        meta[2].y=(meta[2].pos+cur_frm)->y;
        meta[2].z=(meta[2].pos+cur_frm)->z;

    }

    if(graphics_system.bbp==15)
        blur15(virtual,blur,last_virtual_frame_buffer,graphics_system.image_size);
    else
        blur16(virtual,blur,last_virtual_frame_buffer,graphics_system.image_size);

    temp_frame=frames_dr;
    temp_time=lib_get_time();
    if (temp_time-last_time>0.25) {
        fps=(float)(temp_frame-last_frame)/(temp_time-last_time);
        last_time=temp_time;
        last_frame=temp_frame;
    }

    if(K_F && icg_boss) {
        sprintf(fps_info,"Fps: %4.3f",fps);
        lib_write_string(fps_info,0,0,31,virtual);
    }


}

void end_meta(void) {

    free(textura);
    free(tri);
    free(iso_srf);
    free(campo);
    free(meta[0].pos);
    free(meta[1].pos);
    free(meta[2].pos);
    free(blur);
    free(background);

}

void read_path(META *meta,BYTE filename[20]) {

    if((meta->pos=lib_fopen(filename))==NULL)
        fatal_error("Can't open %s",filename);

}

void calc_field(float (*campo)[SIZEZ][SIZEY][SIZEX], META (*balls)[NO_METAS]) {

    SDWORD ix,iy,iz,k;
    float dst[3],dx,dy,dz,x,y,z,kt;

    for(ix=0,x=-SIZEZ*GRID/2;x<SIZEZ*GRID/2;x+=GRID,ix++)
        for(iy=0,y=-SIZEY*GRID/2;y<SIZEY*GRID/2;y+=GRID,iy++)
            for(iz=0,z=-SIZEX*GRID/2;z<SIZEX*GRID/2;z+=GRID,iz++) {
                for(k=0;k<NO_METAS;k++) {

                    dx=x-(*balls)[k].x;
                    dy=y-(*balls)[k].y;
                    dz=z-(*balls)[k].z;

                    dst[k]=dx*dx+dy*dy+dz*dz;
                }

//     (*campo)[ix][iy][iz]+=(*balls)[k].a*exp(-(*balls)[k].b*dst/10000);

            kt=dst[0]*dst[1];
            (*campo)[ix][iy][iz]=(1000000*(kt+(dst[0]+dst[1])*dst[2]))
                                    /(kt*dst[2]);
        }
}

void render(float (*campo)[SIZEZ][SIZEY][SIZEX], PATTERN *iso_srf) {

    SDWORD x,y,z;
    cur_tri=0;

    // La triangularizacin debe hacerse desde atrs hacia adelante.
    for(x=SIZEX-3;x>=0;x--) for(y=0;y<SIZEY-3;y++) for(z=SIZEZ-3;z>=0;z--) {
        build_polys(x,y,z,campo,iso_srf);

#if DEBUG == TRUE
        if(cur_tri>=1900) {
            lib_end_gfx_engine();
            printf("\nPAAaaAAnic! Mucho tringulos!");
            exit(0);
        }
#endif
    }
}

void paint(BYTE *tmap) {

    VERTEX points[3];
    SDWORD p0x,p0y,p1x,p1y,p2x,p2y,i;
    float inv,x,y,z;

    for(i=0;i<cur_tri;i++) {
        x=tri[i].a.x;
        y=tri[i].a.y;
        z=tri[i].a.z;
        inv=1/(z+480);
        p0x=graphics_system.centerx+real2int(x*graphics_system.xratio*inv);
        p0y=graphics_system.centery+real2int(y*graphics_system.yratio*inv);

        x=tri[i].b.x;
        y=tri[i].b.y;
        z=tri[i].b.z;
        inv=1/(z+480);
        p1x=graphics_system.centerx+real2int(x*graphics_system.xratio*inv);
        p1y=graphics_system.centery+real2int(y*graphics_system.yratio*inv);

        x=tri[i].c.x;
        y=tri[i].c.y;
        z=tri[i].c.z;
        inv=1/(z+480);
        p2x=graphics_system.centerx+real2int(x*graphics_system.xratio*inv);
        p2y=graphics_system.centery+real2int(y*graphics_system.yratio*inv);

        points[0].x=p0x;
        points[1].x=p1x;
        points[2].x=p2x;
        points[0].y=p0y;
        points[1].y=p1y;
        points[2].y=p2y;
        points[0].u=tri[i].na.u;
        points[1].u=tri[i].nb.u;
        points[2].u=tri[i].nc.u;
        points[0].v=tri[i].na.v;
        points[1].v=tri[i].nb.v;
        points[2].v=tri[i].nc.v;

        if(get_song_pos()<0xe0000 || get_song_pos()>0x110030 ||
           (K_L && icg_boss)) {
            draw_clip_line(p0x,p0y,p1x,p1y,0xffff);
            draw_clip_line(p1x,p1y,p2x,p2y,0xffff);
            draw_clip_line(p2x,p2y,p0x,p0y,0xffff);
        }
        else draw_texture_poly(points,tmap);
    }

}

void build_polys(SDWORD xv,SDWORD yv,SDWORD zv,float (*campo)[SIZEZ][SIZEY][SIZEX],
                 PATTERN *iso_srf)
{

    DWORD x,y,z,i,index=0;
    SDWORD ax,ay,az;
    SDWORD bx,by,bz;

    for(z=i=0;z<2;z++) for(y=0;y<2;y++) for(x=0;x<2;x++,i++)
        if((*campo)[z+zv][y+yv][x+xv]>UMBRAL) index|=(1<<i);

    for(i=0;i<iso_srf[index].no_triangles;i++) {

        ax=xv+iso_srf[index].triangle[i].a0.z;
        ay=yv+iso_srf[index].triangle[i].a0.y;
        az=zv+iso_srf[index].triangle[i].a0.x;

        bx=xv+iso_srf[index].triangle[i].a1.z;
        by=yv+iso_srf[index].triangle[i].a1.y;
        bz=zv+iso_srf[index].triangle[i].a1.x;

        interpolate(az,ay,ax,bz,by,bx,campo,&tri[cur_tri+i].na,&tri[cur_tri+i].a);

        ax=xv+iso_srf[index].triangle[i].b0.z;
        ay=yv+iso_srf[index].triangle[i].b0.y;
        az=zv+iso_srf[index].triangle[i].b0.x;

        bx=xv+iso_srf[index].triangle[i].b1.z;
        by=yv+iso_srf[index].triangle[i].b1.y;
        bz=zv+iso_srf[index].triangle[i].b1.x;

        interpolate(az,ay,ax,bz,by,bx,campo,&tri[cur_tri+i].nb,&tri[cur_tri+i].b);

        ax=xv+iso_srf[index].triangle[i].c0.z;
        ay=yv+iso_srf[index].triangle[i].c0.y;
        az=zv+iso_srf[index].triangle[i].c0.x;

        bx=xv+iso_srf[index].triangle[i].c1.z;
        by=yv+iso_srf[index].triangle[i].c1.y;
        bz=zv+iso_srf[index].triangle[i].c1.x;

        interpolate(az,ay,ax,bz,by,bx,campo,&tri[cur_tri+i].nc,&tri[cur_tri+i].c);
    }

    cur_tri+=iso_srf[index].no_triangles;
}

static void interpolate(SDWORD x1, SDWORD y1, SDWORD z1, SDWORD x2, SDWORD y2,
                SDWORD z2,float (*campo)[SIZEZ][SIZEY][SIZEX], TEXEL *tx,
                POINT *pt) {

    float nx1,ny1,nz1,nx2,ny2,nz2,c1,c2,pc,int_x,int_y,int_z,inv_modulo;

    c1=(*campo)[x1][y1][z1];
    c2=(*campo)[x2][y2][z2];

#if DEBUG == TRUE
    if((c1>UMBRAL && c2>UMBRAL) || (c1<UMBRAL && c2<UMBRAL)) {
            lib_end_gfx_engine();
            printf("\nPanic %f - %f",c1,c2);
            exit(0);
    }
#endif

    pc=(UMBRAL-c1)/(c2-c1);

    pt->x=(float)((x1+(x2-x1)*pc)-SIZEZ/2)*GRID;
    pt->y=(float)((y1+(y2-y1)*pc)-SIZEY/2)*GRID;
    pt->z=(float)((z1+(z2-z1)*pc)-SIZEX/2)*GRID;

    nx1=((*campo)[x1+1][y1][z1]-(*campo)[x1-0][y1][z1]);
    ny1=((*campo)[x1][y1+1][z1]-(*campo)[x1][y1-0][z1]);
    nz1=((*campo)[x1][y1][z1+1]-(*campo)[x1][y1][z1-0]);

    nx2=((*campo)[x2+1][y2][z2]-(*campo)[x2-0][y2][z2]);
    ny2=((*campo)[x2][y2+1][z2]-(*campo)[x2][y2-0][z2]);
    nz2=((*campo)[x2][y2][z2+1]-(*campo)[x2][y2][z2-0]);

    int_x=nx1+(nx2-nx1)*pc;
    int_y=ny1+(ny2-ny1)*pc;
    int_z=nz1+(nz2-nz1)*pc;

    inv_modulo=1/sqrt(int_x*int_x+int_y*int_y+int_z*int_z);
    tx->u=128+real2int(127*int_x*inv_modulo);
    tx->v=128+real2int(127*int_y*inv_modulo);

}
