#include <stdio.h>
#include <types.h>
#include <math.h>
#include "matrix.h"

MATRIZ tmp = {{1,0,0,0},
              {0,1,0,0},
              {0,0,1,0},
              {0,0,0,1}};

void show_matriz(MATRIZ m) {

    DWORD i;
    for(i=0;i<4;i++) printf("\n% 8.2f % 8.2f % 8.2f % 8.2f   ",
                                m[i][0],m[i][1],m[i][2],m[i][3]);

}

void init_matriz(MATRIZ m) {

    m[0][1]=m[0][2]=m[0][3]=m[1][0]=m[1][2]=m[1][3]=m[2][0]=m[2][1]=m[2][3]= \
    m[3][0]=m[3][1]=m[3][2]=0;

    m[0][0]=m[1][1]=m[2][2]=m[3][3]=1;
}

void translation(MATRIZ md, float dx, float dy, float dz) {

    md[3][0]+=dx;
    md[3][1]-=dy;
    md[3][2]+=dz;

}

void pre_translation(MATRIZ md, float dx, float dy, float dz) {

    md[3][0]+=dx*md[0][0]-dy*md[1][0]+dz*md[2][0];
    md[3][1]+=dx*md[0][1]-dy*md[1][1]+dz*md[2][1];
    md[3][2]+=dx*md[0][2]-dy*md[1][2]+dz*md[2][2];

}

void pre_rotation_x(MATRIZ md, float angulo) {

    float oldc[3];
    float cs=cos(angulo),sn=sin(angulo);

    oldc[0]=md[1][0];
    oldc[1]=md[1][1];
    oldc[2]=md[1][2];

    md[1][0] = md[1][0]*cs + md[2][0]*sn;
    md[1][1] = md[1][1]*cs + md[2][1]*sn;
    md[1][2] = md[1][2]*cs + md[2][2]*sn;

    md[2][0] = -oldc[0]*sn + md[2][0]*cs;
    md[2][1] = -oldc[1]*sn + md[2][1]*cs;
    md[2][2] = -oldc[2]*sn + md[2][2]*cs;

}

void pre_rotation_y(MATRIZ md, float angulo) {

    float oldc[3];
    float cs=cos(angulo),sn=sin(angulo);

    oldc[0]=md[0][0];
    oldc[1]=md[0][1];
    oldc[2]=md[0][2];

    md[0][0] = md[0][0]*cs + md[2][0]*sn;
    md[0][1] = md[0][1]*cs + md[2][1]*sn;
    md[0][2] = md[0][2]*cs + md[2][2]*sn;

    md[2][0] = -oldc[0]*sn + md[2][0]*cs;
    md[2][1] = -oldc[1]*sn + md[2][1]*cs;
    md[2][2] = -oldc[2]*sn + md[2][2]*cs;

}

void pre_rotation_z(MATRIZ md, float angulo) {

    float oldc[3];
    float cs=cos(angulo),sn=sin(angulo);

    oldc[0]=md[0][0];
    oldc[1]=md[0][1];
    oldc[2]=md[0][2];

    md[0][0] = md[0][0]*cs + md[1][0]*sn;
    md[0][1] = md[0][1]*cs + md[1][1]*sn;
    md[0][2] = md[0][2]*cs + md[1][2]*sn;

    md[1][0] = -oldc[0]*sn + md[1][0]*cs;
    md[1][1] = -oldc[1]*sn + md[1][1]*cs;
    md[1][2] = -oldc[2]*sn + md[1][2]*cs;

}

void rotation_x(MATRIZ md, float angulo) {

    float oldc;
    float cs=cos(angulo),sn=sin(angulo);

    oldc=md[0][1];
    md[0][1] = md[0][1]*cs - md[0][2]*sn;
    md[0][2] = md[0][2]*cs + oldc*sn;

    oldc=md[1][1];
    md[1][1] = md[1][1]*cs - md[1][2]*sn;
    md[1][2] = md[1][2]*cs + oldc*sn;

    oldc=md[2][1];
    md[2][1] = md[2][1]*cs - md[2][2]*sn;
    md[2][2] = md[2][2]*cs + oldc*sn;

    oldc=md[3][1];
    md[3][1] = md[3][1]*cs - md[3][2]*sn;
    md[3][2] = md[3][2]*cs + oldc*sn;

}

void rotation_y(MATRIZ md, float angulo) {

    float oldc;
    float cs=cos(angulo),sn=sin(angulo);

    oldc=md[0][0];
    md[0][0] = md[0][0]*cs - md[0][2]*sn;
    md[0][2] = md[0][2]*cs + oldc*sn;

    oldc=md[1][0];
    md[1][0] = md[1][0]*cs - md[1][2]*sn;
    md[1][2] = md[1][2]*cs + oldc*sn;

    oldc=md[2][0];
    md[2][0] = md[2][0]*cs - md[2][2]*sn;
    md[2][2] = md[2][2]*cs + oldc*sn;

    oldc=md[3][0];
    md[3][0] = md[3][0]*cs - md[3][2]*sn;
    md[3][2] = md[3][2]*cs + oldc*sn;

}

void rotation_z(MATRIZ md, float angulo) {

    float oldc;
    float cs=cos(angulo),sn=sin(angulo);

    oldc=md[0][0];
    md[0][0] = md[0][0]*cs - md[0][1]*sn;
    md[0][1] = md[0][1]*cs + oldc*sn;

    oldc=md[1][0];
    md[1][0] = md[1][0]*cs - md[1][1]*sn;
    md[1][1] = md[1][1]*cs + oldc*sn;

    oldc=md[2][0];
    md[2][0] = md[2][0]*cs - md[2][1]*sn;
    md[2][1] = md[2][1]*cs + oldc*sn;

    oldc=md[3][0];
    md[3][0] = md[3][0]*cs - md[3][1]*sn;
    md[3][1] = md[3][1]*cs + oldc*sn;

}

void copy_matriz(MATRIZ md, MATRIZ ms) {

    DWORD i;

    for(i=0;i<4;i++) {
        md[i][0]=ms[i][0];
        md[i][1]=ms[i][1];
        md[i][2]=ms[i][2];
    }
}

#define cross_dot(m,n) md[m][0]*ms[0][n]+md[m][1]*ms[1][n]+md[m][2]*ms[2][n];

void mul_matriz(MATRIZ sr, MATRIZ md, MATRIZ ms) {

    DWORD i;

    for(i=0;i<3;i++) {
        sr[i][0]=cross_dot(i,0);
        sr[i][1]=cross_dot(i,1);
        sr[i][2]=cross_dot(i,2);
    }
    for(i=0;i<3;i++)
        sr[3][i]= md[3][0]*ms[0][i]+md[3][1]*ms[1][i]  \
                  +md[3][2]*ms[2][i]+ms[3][i];

}

void post_mul_matriz(MATRIZ md, MATRIZ ms) {

    DWORD i;

    for(i=0;i<3;i++) {
        tmp[i][0]=cross_dot(i,0);
        tmp[i][1]=cross_dot(i,1);
        tmp[i][2]=cross_dot(i,2);
    }
    for(i=0;i<3;i++)
        tmp[3][i]= md[3][0]*ms[0][i]+md[3][1]*ms[1][i]  \
                  +md[3][2]*ms[2][i]+ms[3][i];

    copy_matriz(md,tmp);
}

void pre_mul_matriz(MATRIZ md, MATRIZ ms) {

    DWORD i;

    for(i=0;i<3;i++) {
        tmp[i][0]=cross_dot(i,0);
        tmp[i][1]=cross_dot(i,1);
        tmp[i][2]=cross_dot(i,2);
    }
    for(i=0;i<3;i++)
        tmp[3][i]= md[3][0]*ms[0][i]+md[3][1]*ms[1][i]  \
                  +md[3][2]*ms[2][i]+ms[3][i];

    copy_matriz(ms,tmp);
}

BOOLEAN zero(float a) {

    if(a<EPSILON && a>-EPSILON) return TRUE;
    else return FALSE;

}

void inv_transform(VECTOR *dst,VECTOR *v, MATRIZ m) {

    v->x-=m[3][0];
    v->y-=m[3][1];
    v->z-=m[3][2];
    dst->x=v->x*m[0][0]+v->y*m[0][1]+v->z*m[0][2];
    dst->y=v->x*m[1][0]+v->y*m[1][1]+v->z*m[1][2];
    dst->z=v->x*m[2][0]+v->y*m[2][1]+v->z*m[2][2];

}

void vr_inv_transform(VECTOR *dst,VECTOR *v, MATRIZ m) {

    dst->x=v->x*m[0][0]+v->y*m[0][1]+v->z*m[0][2];
    dst->y=v->x*m[1][0]+v->y*m[1][1]+v->z*m[1][2];
    dst->z=v->x*m[2][0]+v->y*m[2][1]+v->z*m[2][2];

}

void transform(VECTOR *v, MATRIZ m, VECTOR *dst) {

    dst->x=v->x*m[0][0]+v->y*m[1][0]+v->z*m[2][0]+m[3][0];
    dst->y=v->x*m[0][1]+v->y*m[1][1]+v->z*m[2][1]+m[3][1];
    dst->z=v->x*m[0][2]+v->y*m[1][2]+v->z*m[2][2]+m[3][2];

}

void vr_transform(VECTOR *v, MATRIZ m, VECTOR *dst) {

    dst->x=v->x*m[0][0]+v->y*m[1][0]+v->z*m[2][0];
    dst->y=v->x*m[0][1]+v->y*m[1][1]+v->z*m[2][1];
    dst->z=v->x*m[0][2]+v->y*m[1][2]+v->z*m[2][2];

}

