/*************************************************************************************/
/* MAIN                                                                              */
/*                                                                                   */
/* This is the main program used for the DirectX application. This file was          */
/* generated by the DirectX Application Wizard.                                      */
/*                                                                                   */
/* (C)1997 by Franz Polzer & Peter Koen                                                           */
/*************************************************************************************/

#define NAME "DX_2D_Bump_Mapping"				// Type in your application's name here
#define TITLE "DX_2D_Bump_Mapping"

#include "dxstart.h"											// Attention: NAME, BACKBUFFER and TITLE must be defined before this
#include "dxutil.h"					
#include <math.h>							
#include <stdio.h>

#define TIMER_RATE      20								// Select the timer rate for your application

#define X_RES			640								// The X-Resolution of the DirectDraw window
#define Y_RES			480								// The Y-Resolution of the DirectDraw window
#define NUM_BITS		8									// The number of bits per bitplane
#define	MAX_WINKEL		256
#define	F_RED			128
#define F_GREEN			64
#define F_BLUE			12
#define LIGHT			10
#define	REFLECT			60
#define	AMBIENT			10
#define BUMPX			400
#define BUMPY			300
#define BUMPOFFSET		BUMPY*BUMPX
#define	PI				3.141592654
#define BUMPDATA		"BUMPMAP.PCX"

unsigned char			textur[X_RES*Y_RES],vscreen[X_RES*Y_RES],bumpmap[4*X_RES*Y_RES],pal[768],smallbump[BUMPX*BUMPY];
int						costab[MAX_WINKEL],sintab[MAX_WINKEL];
static int				lightx,lighty,directionx,directiony,xpos,ypos;
LPDIRECTDRAWPALETTE     lpDDPal;
LPDIRECTDRAWSURFACE     pdds;


void MakePal(void)
{
	int				i,temp;
	float			intensity;
	LPPALETTEENTRY  ppe;
	HRESULT         ddrval;

    ppe = (LPPALETTEENTRY) LocalAlloc( LPTR, sizeof( PALETTEENTRY ) * 256 );
    if( ppe == NULL ) return;
    if( lpDDPal != NULL )
        {
            ddrval = lpDDPal->Release();
            lpDDPal = NULL;
        }
   
	for( i=0;i<256;i++ )
        {
			intensity=(float)cos((256-i)*PI/512);
			temp=(int)(F_RED*AMBIENT/64+F_RED*intensity+pow(intensity,REFLECT)*LIGHT);
			ppe[i].peRed   =temp;
			temp=(int)(F_GREEN*AMBIENT/64+F_GREEN*intensity+pow(intensity,REFLECT)*LIGHT);
			ppe[i].peGreen =temp;
			temp=(int)(F_BLUE*AMBIENT/64+F_BLUE*intensity+pow(intensity,REFLECT)*LIGHT);
			ppe[i].peBlue  =temp;
        }
	ddrval = lpDD->CreatePalette( DDPCAPS_8BIT, ppe, &lpDDPal, NULL );
	if (lpDDPal) lpDDSView->SetPalette(lpDDPal);
}

void PK_PCXLoad(char* fn, void far* m, void far* p, long si)
{
  FILE* f;
  long i=0;
  unsigned char c,d;
  char b[1024];

	f=fopen(fn,"rb");
	fseek(f,-768L,SEEK_END);
	fread(b,1,768,f);
	for (int j=0;j<768;j++) *((char far*)p+j)=b[j];
	fseek(f,128L,SEEK_SET);
	do
	{
		fread(&c,1,1,f);
		if (c>=0xC0)
		{
			d=c&0x3F; fread(&c,1,1,f);
			while (d--) *((char far*)m+i++)=c;
		}
		else *((char far*)m+i++)=c;
	} while (i<si);
	fclose(f);
}


void InitBump()
{
	int count;

	for (count=0;count<MAX_WINKEL; count++)
	{
		sintab[count]=(int)sin((float)count*PI/180)*256;
		costab[count]=(int)cos((float)count*PI/180)*256;
	}
	for(count=0;count<X_RES*Y_RES;count++) vscreen[count]=0;
	for(count=0;count<2*X_RES*Y_RES;count++) bumpmap[count]=0;
	for(count=0;count<BUMPX*BUMPY;count++) smallbump[count]=0;
	PK_PCXLoad("bump.pcx", textur, pal, X_RES*Y_RES);
	PK_PCXLoad(BUMPDATA, smallbump, pal, BUMPX*BUMPY);
	lightx=X_RES/2;
	lighty=Y_RES/2;
	xpos=0;
	ypos=0;
	directionx=1;
	directiony=1;
	MakePal();
}


void MainBump()
{
	unsigned int xdelta,ydelta,xtemp,ytemp,i,j,lx,ly,u,v;
    ly=-lighty;
	for(i=1;i<Y_RES-1;i++)
	{
		lx=-lightx;
		for(j=0;j<X_RES;j++)
		{
			xdelta=((textur[i*X_RES+j-1]-textur[i*X_RES+j+1])>>1)+X_RES/2;
			ydelta=((textur[(i-1)*X_RES+j-1]-textur[(i-1)*X_RES+j-1])>>1)+Y_RES/2;
            lx++;
            xtemp=xdelta+lx;
            ytemp=ydelta+ly;
            //if((xtemp&0xFF00)||(ytemp&0xFF00)) 
			if(bumpmap[BUMPOFFSET+ytemp*X_RES+xtemp]&0xFF00)
			{
	            vscreen[i*X_RES+j]=0;
            } 
			else 
			{
                 u=xtemp;
                 v=ytemp;
				 vscreen[i*X_RES+j]=bumpmap[BUMPOFFSET+v*X_RES+u];
            }
        }
        ly++;
    }
}


void MoveAndCopy()
{
	int	hx,hy,count;

	xpos+=10*directionx;
	ypos+=5*directiony;
	if(xpos>X_RES-BUMPX/2)
	{
		directionx*=-1;
		xpos=X_RES-BUMPX/2+1;
	}
	if(xpos<-BUMPX/2) 
	{
		directionx*=-1;
		xpos=-BUMPX/2;
	}
	if(ypos>Y_RES-BUMPY/2)
	{
		directiony*=-1;
		ypos=Y_RES-BUMPY/2+1;
	}
	if(ypos<-BUMPY/2) 
	{
		directiony*=-1;
		ypos=-BUMPY/2;
	}
	for(count=0;count<X_RES*Y_RES;count++) bumpmap[BUMPOFFSET+count]=0;
	for(hy=0;hy<BUMPY;hy++)
		for(hx=0;hx<BUMPX;hx++) 
		{
			if ((!((hx+xpos)>X_RES))&&(!((hx+xpos)<1))&&((hy+ypos)<Y_RES)&&((hy+ypos)>1)) bumpmap[BUMPOFFSET+(ypos+hy)*X_RES+hx+xpos]=smallbump[hy*BUMPX+hx];
		}
}



/*************************************************************************************/
/* DDDrawFrame(HWND)                                                                 */
/*                                                                                   */
/* You should use this routine to draw the next frame onto the specified window.     */
/* Do not alter the name of this function because it's called automatically by       */
/* interrupt routine!                                                                */
/*************************************************************************************/

void DDDrawFrame(HWND hWnd)
{
	DDSURFACEDESC	ddsd;
	HRESULT			ddrval;
	LPSTR			lpVScreen;

	ddsd.dwSize = sizeof(ddsd);
	while(1)
	{
		ddrval = lpDDSBack->Lock(NULL,&ddsd, 0, NULL);	// Lock the backbuffer surface
		if(ddrval == DD_OK)
			break;
		if (ddrval != DDERR_WASSTILLDRAWING)
			return;
	}
	lpVScreen = (LPSTR)ddsd.lpSurface;								// Get pointer to video memory
	MoveAndCopy();
	MainBump();
	memcpy(lpVScreen,vscreen,X_RES*Y_RES );
	lpDDSBack->Unlock(NULL);													// Free the surface	
	DDSwitchFrame();																	// Switches between backbuffer and primary page
}



/*************************************************************************************/
/* WinMain(...)                                                                      */
/*                                                                                   */
/* This is the main program called when this application is started.                 */
/* Do not alter the name of this function because windows uses this as startpoint.   */
/*************************************************************************************/

int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
	MSG msg;

	if(!DDInitAll(hInstance, nCmdShow, TIMER_RATE, X_RES, Y_RES, NUM_BITS)) return FALSE;

	DDSetCursor(NULL);				// Set the shape of your application's cursor
														// or NULL if no cursor is needed.

	InitBump();
	
	while (GetMessage(&msg, NULL, 0, 0))
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}

	return msg.wParam;
}
