/* Coded by Sol/Trauma (aka Jari Komppa), public domain.
 *
 * Done just to prove my point that fliflc is output device independent :)
 *
 * (and since the palette setting is separate from the fli/flc engine,
 *  it can be remapped to ANY mode, 15bpp, truecolor, anything).
 */
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <string.h>
#include <i86.h>
#include "fliflc.h"

void vrc(void) {
  while ((inp(0x3da)&8)==0) {}
  while ((inp(0x3da)&8)!=0) {}
}

void waitframes(int numframes) {
  for (;numframes;numframes--)
    vrc();
}

void setpal(char * pal) {
int a;
  outp(0x3c8,0);
  for (a=0;a<768;a++)
    outp(0x3c9,*(pal+a));
}

void vga_setmode(unsigned short int vmode) {
union REGS regs;
  regs.w.ax=vmode;
  int386(0x10,&regs,&regs);
}

void fli_frame2mcga(FLIDATA *flidata) {
int xmax,ymax,y;
  xmax=(flidata->x_size<320)?flidata->x_size:320;
  ymax=(flidata->y_size<200)?flidata->y_size:200;
  for (y=0;y<ymax;y++)
    memcpy((char*)0xa0000+y*320,flidata->framebuffer+y*flidata->x_size,xmax);
}

void main(int argc,char **argv) {
FLIDATA * flic;
int speed;
  if (argc<2) {
    cprintf("------------------------------------------------------------------------------\r\n"
            "MCGAFLI - 320x200 Fli/Flc player by Sol_HSA aka Sol/Trauma. Version 1.2\r\n"
            "<mailto:solar@compart.fi>\r\n"
            "Usage: MCGAFLI <.fli/flc file of any size> <speed>\r\n"
            "(speed = retraces to wait before next frame. Default = 2)\r\n"
            "------------------------------------------------------------------------------\r\n");
    return;
  }
  flic=fli_open(argv[1],0);
  speed=2;
  if (argc>2)
    speed=strtol(argv[2],0,10);
  vga_setmode(0x13);
  while (!kbhit()) {
    fli_renderframe(flic);
    if (!flic->looped)
      if (flic->palette_change) {
      setpal(flic->palette);
      flic->palette_change=0;
    }
    fli_frame2mcga(flic);
    waitframes(speed);
  }
  fli_zap(flic);
  vga_setmode(3);
  cprintf("Remember: EVERYTHING looks good while viewed from 20 meters in free fall.\r\n");
}
