#include <i86.h>
#include <math.h>
#include <stdio.h>

typedef int            int32;
typedef unsigned int   uint32;
typedef short          int16;
typedef unsigned short uint16;
typedef unsigned char  uchar;

#define TUNNEL_R 50
#define PI       3.141592653789

extern void SetVideoMode(uint16 mode);
#pragma aux SetVideoMode = \
  " int 10h " \
  parm [ax] \
  modify [eax];

char pal[768], tex[65536], buf[64000];
int table[64000];
int f = 0, d = 0, spd = 1, v = -1;
char *screen = (char*)0xA0000L;

void WaitRetrace() {
  while ((inp(0x3DA) & 0x08) == 0);
  while ((inp(0x3DA) & 0x08) != 0);
}

void CreateTable() {
  int i, j, p, u, v;
  double a, r;

  p = 0;
  for (j = 0; j < 200; j++) {
    for (i = 0; i < 320; i++) {
      r = sqrt((i - 160) * (i - 160) + (100 - j) * (100 - j));
      u = 0;
      v = 0;
      if (r > 0.5) {
        a = atan2(100 - j, i - 160) + PI;
        v = (int)((320 * TUNNEL_R) / r);
        u = (int)((a * 256) / PI);
        while (v >= 256) v -= 256;
        while (u >= 256) u -= 256;
      }
      table[p++] = (v << 8) + u;
    }
    if (j % 10 == 0) {
      printf(".");
      fflush(stdout);
    }
  }
}

void RenderTunnel() {
  int i = 0;
  char *dest = (char*)&buf;

  d += (spd << 8);
  while (i < 64000) *dest++ = tex[(table[i++] + d) & 0xFFFF];
  if (v) WaitRetrace();
  memcpy(screen, (char*)&buf, 64000);
  f++;
}

void main() {
  int i, t;
  char c, buf[512];

  // make palette
  for (i = 0; i < 768; i++) pal[i] = (i / 3) >> 2;

  // make texture
  for (i = 0; i < 128; i++) buf[i] = (127 - i) << 1;
  for (i = 0; i < 128; i++) buf[i + 128] = i << 1;
  memcpy(&buf[256], &buf, 256);
  for (i = 0; i < 256; i++) memcpy(&tex[i << 8], &buf[i], 256);

  printf("\nUse '+' and '-' to change speed, 'v' to toggle refresh sync, " \
         "Esc for exit.\n");
  printf("\nInitializing [                    ]\rInitializing [");
  fflush(stdout);
  CreateTable();
  printf("\nPress any key to continue...\n");
  getch();

  SetVideoMode(0x13);
  outp(0x3C8, 0x00);
  for (i = 0; i < 0x300; i++) outp(0x3C9, pal[i]);
  t = clock();
  do {
    RenderTunnel();
    c = 0;
    if (kbhit()) c = getch();
    switch(c) {
      case '+':
      case '=': spd++; break;
      case '-':
      case '_': if (spd != 0) spd--; break;
      case 'v':
      case 'V': v = !v; break;
      default : break;
    }
  } while (c != 0x1B);
  t = clock() - t;
  SetVideoMode(0x03);
  printf("\n- simple tunnel - coded by shodan@chat.ru -\n" \
         "%d frames   %d.%02d seconds   %d.%02d fps\n", f, t/100, t%100,
         100*f/t, 10000*f/t - 100*(100*f/t));
}