//////////////////////////////
// uminimod
//
// to do:
// - throw out crap mixer
// - real volume ramping
// - slight chorus/reverb for richer sound?
// - scripting engine for sample synthesis?


#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <math.h>
#include "uminimod.h"
#include "waveout.h"

#define MAX_CH 8

#define PSEUDO_RAMP 8

float *freq_table;
float *vol_table;

i32     bpm;
i32     spd;
i32     delay;
i32     active;
i32     paused;

i32     left;

i32     ch_keyon[MAX_CH];
i32     ch_smp[MAX_CH];
i32     ch_active[MAX_CH];
i32     ch_vol[MAX_CH], ch_vol_env[MAX_CH];
i32     ch_vol_pos[MAX_CH];
float   ch_freq[MAX_CH];
double  ch_pos[MAX_CH];

i32     tick, pat_cur, pat_next, row_cur, row_next;

void
update()
{
	register i32 ch;
	i32 pat_break, pat_jump, cell_note, cell_vol, cell_smp, param;
	u16 *row;

	if (pat_cur >= order_length)
	{
		active = 0;
		return;
	}

	row_next = row_cur + 1;

	row = pat_data[order[pat_cur]] + row_cur * ch_num;

	for(ch = 0; ch < ch_num; ch++)
	{
		cell_note = CELL2NOTE(row[ch]);
		cell_smp  = CELL2SMP(row[ch]);
		cell_vol  = CELL2VOL(row[ch]);

		if (cell_note <= NO_NOTE)
		{

			if (cell_note < KEY_OFF)
			{
				if (cell_smp)
				{
					ch_smp[ch]     = cell_smp - 1;
					ch_vol[ch]     = 256;
					ch_pos[ch]     = 0;
					ch_vol_pos[ch] = 0;
					ch_active[ch] = 1;
				}

				ch_freq[ch]  = freq_table[cell_note + smp_rel_note[ch_smp[ch]]] *
							   smp_freq[ch_smp[ch]] / DEV_FREQ;
				ch_keyon[ch]  = 1;
			}

			if (cell_vol)
			{
				ch_vol[ch] = cell_vol;
	
			}

			if (cell_note == KEY_OFF)
			{
				ch_keyon[ch] = 0;
			}
		}
		else
		{
			param = row[ch] & 0xff;

			switch(cell_note)
			{
			case EFF_BPM:
				bpm = param;
				break;
			case EFF_SPD:
				spd = param;
				break;
			case EFF_BREAK:
				pat_break = 1;
				row_next = param;
				break;
			case EFF_JUMP:
				pat_jump = 1;
				pat_next = param;
				break;
			case EFF_DELAY:
				delay = param;
			}
		}
	}

	if (pat_break && !pat_jump)
	{
		pat_next++;
	}

	if (!pat_break && pat_jump)
	{
		row_next=0;
	}

	if (row_next >= pat_length[order[pat_cur]])
	{
		row_next = 0;
		pat_next++;
	}
}

void
update_envelope()
{
	register i32 ch;
	i32 pnt, smp, cur, next, cur_vol, next_vol, cur_tick, next_tick, diff;

	for(ch = 0; ch < ch_num; ch++)
	{
		pnt = 0;
		smp = ch_smp[ch];

		if ((smp_env_pnt[smp][smp_env_num[smp]-1] & 0xff00) == (ch_vol_pos[ch] << 8) / PSEUDO_RAMP)
		{
			pnt = smp_env_num[smp] - 1;
			ch_vol_env[ch] = smp_env_pnt[ch_smp[ch]][pnt] & 0x7f;
		}
		else
		{
			while((smp_env_pnt[smp][pnt + 1] & 0xff00) < (ch_vol_pos[ch] << 8) / PSEUDO_RAMP)
			{
				pnt++;
			}

			cur       = smp_env_pnt[ch_smp[ch]][pnt];
			next      = smp_env_pnt[ch_smp[ch]][pnt + 1];
			cur_vol   = cur & 0xff;
			next_vol  = next & 0xff;
			cur_tick  = (cur & 0xff00) >> 8;
			next_tick = (next & 0xff00) >> 8;

			diff = (i32)((next_vol - cur_vol) *
						((float)ch_vol_pos[ch] / PSEUDO_RAMP - cur_tick) /
						(next_tick - cur_tick));

			ch_vol_env[ch] = cur_vol + diff;

			if (!(pnt == smp_env_sus[ch_smp[ch]] && ch_keyon[ch] && pnt == smp_env_num[smp] - 1))
			{
				ch_vol_pos[ch]++;
			}
		}
	}
}

void
run_tick()
{
	tick++;

	if (tick >= spd * PSEUDO_RAMP)
	{
		tick = 0;
		if (!delay)
		{
			pat_cur = pat_next;
			row_cur	= row_next;
			update();
		}
		else
		{
			delay--;
		}
	}

	update_envelope();
}

void mix_ch(float *buf, i32 length, i32 ch)
{
	i32 smp;
	register float fraction, fratio;
	float *buf_end;
	i32 active;
	register float vol_left, vol_right;
	register float *in;
	float *in_end;

	smp          = ch_smp[ch];
	in           = smp_data[smp] + ((i32)ch_pos[ch]) * 2;
	fraction     = (float)(ch_pos[ch] - (i32)ch_pos[ch]);
	in_end       = smp_data[smp] + smp_length[ch] * 2;
	buf_end      = buf + 2 * length;
	vol_left     = vol_table[vol*ch_vol[ch]*ch_vol_env[ch]*smp_vol[ch]>>24];
	vol_right    = - vol_left;
	fratio       = ch_freq[ch] / DEV_FREQ;
	active       = ch_active[ch];

	if (!active)
	{
		goto non_active;
	}

	while(buf < buf_end)
	{
		if (in >= in_end)
		{
			if (smp_loop_beg[smp] >= 0)
			{
					in = smp_data[smp] + (i32)smp_loop_beg[smp] * 2;
					fraction = (float)(smp_loop_beg[smp] - (i32)smp_loop_beg[smp]);
					fraction = 0;
			}
			else
			{
				active = 0;
				break;
			}
		}

		*(buf++) += ((1-fraction)*(*in)+fraction*(*(in+2)))*vol_left;
		*(buf++) += ((1-fraction)*(*(in+1))+fraction*(*(in+3)))*vol_right;

        fraction += fratio;
		while(fraction >= 1)
		{
			fraction -= 1;
			in += 2;
		}
	}

non_active:

	ch_active[ch] = active;
	ch_pos[ch]    = ((int)in - (int)smp_data[smp]) * 0.125 + fraction;
}

void mix(float *buf, i32 length)
{
	int ch;

	for(ch = 0; ch < ch_num; ch++)
	{
		if (!ch_active[ch])
		{
			continue;
		}

		if (!smp_data[ch_smp[ch]])
		{
			continue;
		}

		mix_ch(buf, length, ch);
	}
}

#define minnnnn(a, b) ((a) < (b) ? (a) : (b))

void
play(float *buf, i32 length)
{
	i32 left2, pos;

	for(pos = 0; pos < (length << 1); pos++)
	{
		buf[pos] = 0;
	}

	pos = 0;

	if (!active || paused)
	{
		return;
	}

	while(pos < length)
	{
		if (!left)
		{
			run_tick();
			left = (int)(DEV_FREQ / (bpm * 0.4f * PSEUDO_RAMP));
		}

		left2 = minnnnn(left, length - pos);
		mix(buf, left2);
		buf += left2 << 1;
		pos += left2;
		left -= left2;
	}
}

#undef minnnnn

i32
get_pos()
{
	return pat_cur * 256 + row_cur;
}

void
reset()
{
	i32 ch;

	for(ch = 0; ch < ch_num; ch++)
	{
		ch_active[ch] = 0;
	}

	bpm = bpm_def;
	spd = spd_def;

	delay = 0;
	active = 1;
	paused = 0;
	left = 0;
	tick = spd;
	pat_next = 0;
	row_next = 0;
}

void
init()
{
	int i;

	song_init();

	reset();

	vol_table = (float*)malloc(sizeof(float)*513);

	for(i = 513; i--;)
	{
		vol_table[i] = i / 256.0f;
	}

	freq_table = (float*)malloc(sizeof(float)*97);

	for(i = 97; i--;)
	{
		freq_table[i] = (float)(14317056 / (pow(2.0f, (float)(132 - i) / 12.0f) * 0.25f * 13.375f));
	}
}

void
convert(float *buf1, short *buf2, float vol, int num)
{
	float out;

	while(num)
	{
		out = buf1[num] * vol * 32768.0f;
		if (out > 32767) out = 32767;
		if (out < -32768) out = -32768;
		buf2[num] = (short) out;
		num--;
	}
}



void
main()
{
//	FILE *file;
	short *buffer1;
	float *buffer2;

	AUDIO_Init();
	if (!AUDIO_Open(44100, 16, 2, 1024*1024))
	{
		printf("error while initializing waveout\n");
		return;
	}

	buffer1 = (short*) malloc(4*AUDIO_GetWriteLength());
	buffer2 = (float*) malloc(8*AUDIO_GetWriteLength());

	init();

	while(!kbhit())
	{
		if (AUDIO_Ready())
		{
			play(buffer2, AUDIO_GetWriteLength());
			convert(buffer2, buffer1, 0.5f, AUDIO_GetWriteLength()*2);
			AUDIO_Write(buffer1);
		}
		Sleep(2);
	}

	AUDIO_Kill();

	printf("done\n");

/*	file = fopen("c:\\out.raw", "wb+");
	fwrite(buffer1, AUDIO_GetWriteLength(), 4, file);
	fclose(file);*/
}
