#include "allegro.h"   

using namespace std;

// data structures for snow flaxes = very simple
const int total_flakes=900;
const int total_layers=3;
struct particle
{
    int x,y;
    int layer;
};

// global data - okay for a simple example like this
particle flakes[total_flakes]; 

// This function initalizes the particle flakes
void initalize_particle_flakes(void)
{
    int i;
    for (i=0;i<total_flakes;i++)
    {
        flakes[i].x=rand()%320; // 0-319 [x]
        flakes[i].y=rand()%200; // 0-199 [y]
        flakes[i].layer=rand()%total_layers;// [0-2] [layer]
    }
}

// This function draws all the particle flakes
void draw_particle_flakes(void)
{
    int i;
    for (i=0;i<total_flakes;i++)
    {
        // note - we are drawing according to the color scale
  	    _putpixel(screen, flakes[i].x, flakes[i].y, flakes[i].layer*5+20);
    }
}

// This updates the particle flakes
void update_particle_flakes(void)
{
    int i;
    for (i=0;i<total_flakes;i++)
    {
        // drop the particel down - depending on layer
        // [plus one - since layer zero would result in no motion otherwize]
        flakes[i].y+=flakes[i].layer+1;

        // check for wrap around
        if (flakes[i].y>199)
        {
                flakes[i].x=rand()%320;
                flakes[i].y=0;
                flakes[i].layer=rand()%total_layers;
        }

        // new x position        
        flakes[i].x=(flakes[i].x+(2-rand()%5)) % 320;   
    }
}

// main program
int main(int argc, char *argv[]) {         
	int i;
	
	allegro_init();        // init Allegro 
	install_keyboard();    // setup allegro keyboard
	
	set_color_depth(8) ;   // 8 bit colour
	if (set_gfx_mode(GFX_AUTODETECT_FULLSCREEN, 320, 200, 0, 0)<0)
	{
	    set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);  
	    allegro_message("Failure to init video mode!\n%s\n", allegro_error);
	}
 	initalize_particle_flakes();    	
 	
	while ((!key[KEY_ESC])&&(!key[KEY_SPACE])) {
	      update_particle_flakes();
          vsync(); // you might want to add another vsynch; depnding how fast
                   //things are moving on your box
          vsync();                    
          clear_bitmap(screen);	
          draw_particle_flakes();
    };

	return 0;     
}     
END_OF_MAIN();
