; Author: lego
; Compile: nasm -O9 -f bin -o entry.com entry.asm
; Assume:
; di = 0xfffe
; dx = cs = ds = es = ss

org 0x100  
section .text
;
; -- program starts here
;
main
    mov   cl, 9*(9+8+2)
    add   dx, cx        ; move the es and ds segments so that the puzzle 
    mov   es, dx        ; starts at offset 0 relative to these segments
    mov   ds, dx        ; 

    scasw               ; di = 0
    mov   ah, 8
   .loop
        int   0x21
        stosb
        loop .loop
    mov   byte[di], '$'
    mov   bx, di

;
; -- solve the puzzle
;
; bx = index into puzzle array
solve
    pusha            ; store everything

   .findEmpty
        cmp  byte[bx], '.'          ; if an empty cell
        je  .solve                  ; then try solving it
        dec  bx                     ; otherwise select another cell.
        jns .findEmpty              ; if bx < 0 then print solution

    mov  ah, 9 
    cwd         ; dx = 0
    int  0x21
    int  0x20

   .solve
    mov dx, 0x3931      ; dh = 57('9'), dl = '1'
   .loopDL
        ; SI - index to top-left corner of 3x3 cell
        ; DI - index to beginning of row
        ; BP - index to beginning of column
        mov   ax, bx
        div   dh
        mul   dh 
        xchg  si, ax    ; si = (bx/57)*57
        mov   cl, 19
        mov   ax, bx
        div   cl
        movzx bp, ah    ; bp = bx%19
        mul   cl
        xchg  di, ax    ; di = (bx/19)*19
        mov   ax, bp
        mov   cl, 6
        div   cl
        mul   cl
        add   si, ax    ; si = (bx/57)*57 + ((bx%19)/6)*6

        ; ax = 0..18
        ; test if dl is usable digit at index bl
        mov   cl, 9
       .loopCX
            cmp  byte[si], dl 
            je  .digitNotSuitable
            cmp  byte[di], dl 
            je  .digitNotSuitable
            cmp  byte[ds:bp], dl
            je  .digitNotSuitable

            add  al, 86           ; set CF=1 every third time
            jnc .dontIncrement
                 add  si, byte 13 ; move to beginning of next row in 3x3 piece
                .dontIncrement

            add  bp, byte 19      ; next in column
            cmpsw                 ; add di, 2 - next in row
            loop .loopCX          ; add si, 2 - next in 3x3 square

        xchg byte[bx], dl       ; store '.' in dh, and digit in puzzle
        call solve              ; 
        xchg byte[bx], dl       ; restore old state

       .digitNotSuitable
        inc  dx
        cmp  dl, dh     ; dl == '9'?
        jbe .loopDL
    
    popa        ; restore everything
    ret         ; 
