;-----------------------------------------------------------------------;
;                                                                       ;
; Entry for HUGI size coding competition #25: Sudoku                    ;
; To compile with MASM: ml entry.asm                                    ;
;                                                                       ;
; By Jeff (USA)                                                         ;
;                                                                       ;
;-----------------------------------------------------------------------;
                .model  tiny
		.code
		.386
		.startup

		mov	ah, 3fh		; read from stdin as bx=0
Done:		mov	dx, bp		; buffer is away from program (bp = 09xx)
		mov	cl, 171		; read/write 171 bytes
Exit:		int	21h

		inc	di		; first time through, di<0
		jns	Exit
		inc	bx		; handle 1 (stdout)

		mov	ax, 402eh	; ah = write command, al='.'

Solve:		pusha			; save all registers
		inc	di
		cmp	[di+bp], al	; find first non-'.' char
		loopne	Solve+1
		jne	Done		; if none, print solution
		mov     dx, 3931h	; dh = 19*3, dl = '1'

Check:
		pusha
		mov	ax, di
		mov	bl, 19
		div	bl
		mul	bl
		xchg	si, ax
		sub	di, si
		mov 	cl, 9

ColCheck:
		cmp	[di+bp], dl		; check column
		je	BadCheck
		cmp	[si+bp], dl		; check row
		je	BadCheck
		lodsw				; add si, 2
		add	di, bx
		loop	ColCheck

		xchg	ax, si
		div	dh
		mul	dh

		xchg	ax, di
		sub	al, 171
		mov	cl, 6
		div	cl
		mul	cl

		add	di, ax
		add	di, bp
		xchg	ax, dx
		pusha
		repne	scasb			; check the 3x3 subsquare, first row
		popa
		je	BadCheck
		add	di, bx
		repne	scasb			; check second row of subsquare

BadCheck:					; always jumps here on "je"
		popa

		mov	[di+bp], dl
		jne	Solve		; recursion
PrevCell:       inc     dx
		cmp	dl, dh		; loop through 1-9 chars
		jbe	Check
		mov	[di+bp], al	; restore '.'
		popa
		jmp	PrevCell



                END
