; Sudoku Solver
; Hugi Compo 25 (hugi.scene.org/compo/)
; Author: Cort (cort@cortstratton.org)
; nasmw -fbin -o entry.com entry.asm
	org	100h		; This is a COM program so skip its PSP
section	.text

start:
	;Load Puzzle from stdin
	mov	cl, 171		; There are (9+8+2)*9=171 bytes in the puzzle.
	mov	bp, puzzle
	mov	di, bp
input_loop:
	mov	ah, 0x08	; Read the next character into al
	int	0x21
	stosb
	loop	input_loop, cx
	mov	al, '$'		; Terminate buffer with a '$'
	stosb

	xor	si, si		; start search at si = 0
	call	solve		; Search for a solution recursively.
exit:
	; Print the solved puzzle and exit
	mov	dx, bx		; bx happens to point at puzzle at the moment
	mov	ah, 0x09	; print $-terminated string
	int	0x21
	cbw			; Sign-extend al into ah.  At this point, al is
				; <= 127, so the effect is "mov ah, 0". And
				; interrupt 0x2100 happens to be "exit program"
	int	0x21
	;ret			; Not clear if this should work or not...
solve:
	pusha			; Really only interested in dx and si
	cmp	si, 171
	je	short exit

	; Compare the current entry to zero, meaning "unfilled".
	cmp	byte [bp+si], '.'	; Is this cell empty?
	jne	solve_nextcell	; If not, try the next cell

	mov	dl, '1'		; Starting with 1, try digits up to 9
solve_test:
	; Calculate starting index for each of the three checks we run.
	mov	cl, 19		; 19 entries per row
	mov	ax, si		; Copy index into ax
	div	cl		; al = ax/cl (row), ah = ax % cl (column)
	mov	bx, ax		; bl = row, bh = column
	mul	cl		; ax = row*19
	push	ax		; push index for row check
	mov	cl, 57		; 19*3 = 57 entries per group of 3 rows
	div	cl		; al = row*19/57 = row/3, ah = row % 3
	mul	cl		; al = floor(row/3) * 57, ah = 0
	xchg	al, bh		; bh = floor(row/3) * 57, ax = column
	push	ax		; push index for column check
	mov	cl, 6		; 6 entries per group of 3 cells that matter.
	div	cl		; al = column/6, ah = column % 6
	mul	cl		; al = floor(column/6)*6, ah = 0
	add	al, bh		; al = index of box check start, ah = 0
	push	ax		; push index for box check

	mov	bx, offsets	; Initialize the offsets array. the order is box check, column check, row check
	mov	di, bx		; di = start of offsets
	mov	cl, 27		; Fill 27 bytes
	mov	al, 2		; with the value 2
	rep	stosb
	sub	di, 18		; di = start of second set of offsets
	mov	cl, 9		; Fill 9 bytes
	mov	al, 19		; with the value 19
	rep	stosb

	mov	byte [bx+2], 15		; Modify two offsets for the box check
	mov	byte [bx+5], 15

	xor	dh, dh			; Clear results register
	mov	cl, 3			; Three checks to run
test_loop:
	pop	di			; Pop the next start index
	push	cx			; store outer loop count
	mov	cl, 9			; 9 digits to test per check
	
test_loop2:
	cmp	[bp+di], dl		; Check the current cell for this digit
	lahf				; Load the flags into ah (we want ZF)
	or	dh, ah			; accumulate flags into dh
	mov	al, [bx]		
	cbw				; ah = 0, so long as 0 <= al <= 127
	inc	bx			; Advance to the next offset
	add	di, ax			; Apply the offset to the test index
	loop	test_loop2, cx
	
	pop	cx			; Retrieve outer loop count
	loop	test_loop, cx
	
	mov	ah, dh			; Store the accumulated results
	sahf				; back in the flags register.
	
	; If the current solution is invalid, the zero flag will be set
	jz	solve_nextdigit	; try the next digit
	mov	byte [bp+si], dl; write the current digit
	inc	si		; advance to the next cell
	call	solve		; solve recursively
	; if we get here, the solution has failed; back out our changes.
	dec	si
	mov	byte [bp+si], '.'	; restore cell to "empty" state
solve_nextdigit:
	inc	dx		; Increment the test digit
	cmp	dl, '9'		; If there are more digits to try,
	jle	short solve_test	; try them.
	jmp	short solve_return	; Otherwise, return.
solve_nextcell:
	inc	si		; Advance to the next cell
	call	solve		; and call recursively
solve_return:
	popa			; really only interested in dx and si
	ret

section .bss
offsets	resb	27	; 3 groups of 9 offsets, one for each type of check
puzzle	resb	172	; The puzzle state, stored in ASCII.
			; Each row contains 19 characters (9 numbers, 8 spaces,
			; and 2 linefeed characters). There are 9 rows.  There
			; is also a trailing '$' at the end of the string.
			; 9*19+1 = 172
