program CCCC_02; {move:9 zero:5 frame1:6+ frame2:10+ frame3:13+}

const   version         : string[12] = 'ALGO-02 v1.0';
        progname        : string[ 5] =        '4C-02';
        inlimit         : word       =         32450 ; {target memory fgg}
        outlimit        : word       =          4150 ; {min.header+loadmax.}
        EXTRABIT        : boolean    =         FALSE ; {SHR-es bitloadernl}
        FIXERMODE       : boolean    =          TRUE ; {E8 cm forgatsa   }

        headersizeA     : word =  80;  { without fixer }
        decoderA        : array [0..79] of byte =
      ( $56, $60, $56, $95, $91, $33, $3F, $F3, $A5, $BB, $7D, $DF,
        $BA, $72, $DF, $5F, $E9, $3B, $DE, $B1, $05, $FF, $D2, $74,
        $30, $96, $AA, $33, $F6, $FF, $D3, $73, $F2, $FF, $D2, $74,
        $F4, $FF, $D3, $72, $09, $FF, $D2, $FF, $D3, $72, $02, $FF,
        $D2, $41, $FF, $D3, $72, $FB, $41, $F7, $DE, $03, $F7, $F3,
        $A4, $EB, $DC, $83, $D1, $03, $FF, $D3, $13, $F6, $E2, $FA,
        $C3, $61, $0F, $A3, $6F, $06, $45, $C3                     );

        headersizeB     : word =  95;  { with fixer    }
        headerBcklpos   : word =  76;
        decoderB        : array [0..94] of byte =
      ( $56, $60, $56, $56, $95, $91, $33, $3F, $F3, $A5, $BB, $8C,
        $DF, $BA, $73, $DF, $5F, $E9, $3B, $DE, $B1, $05, $FF, $D2,
        $74, $30, $96, $AA, $33, $F6, $FF, $D3, $73, $F2, $FF, $D2,
        $74, $F4, $FF, $D3, $72, $09, $FF, $D2, $FF, $D3, $72, $02,
        $FF, $D2, $41, $FF, $D3, $72, $FB, $41, $F7, $DE, $03, $F7,
        $F3, $A4, $EB, $DC, $83, $D1, $03, $FF, $D3, $13, $F6, $E2,
        $FA, $C3, $5F, $B9, $00, $00, $F2, $AE, $C1, $05, $08, $29,
        $3D, $AF, $E2, $F6, $61, $0F, $A3, $6F, $06, $45, $C3      );

        errors          : array [1..3] of string[20] =
      ( 'Invalid filename...',
        'Too big...',
        'Too small...' );

var     origfile,outfile: file;
        infname         : string[80];
        outfname        : string[80];
        fixpoint        : array [0..65535] of byte;
        orig            : array [0..65535] of byte;
        outp,save       : array [0..79999] of byte;
        stable          : array [0..7,0..65535] of word; {source in bytes}
        dtable          : array [0..7,0..65535] of word; {dest. in bits}
        ptable          : array [0..7,0..65535] of word; {pozci tbla}
        origsize        : longint;
        fullsize        : longint;
        matchlen        : word;
        wa,wb,wc        : word;
        matchpos        : word;
        inptr,outptr    : word;
        E8cklnum        : word;
        checkpos        : word;
        outbitpos       : byte; {bitmutat outptr-hez -> pushbit}
        preopt          : boolean;

procedure CursorOFF;
begin
     asm
        mov     ah,0Fh
        int     10h
        mov     ah,03h
        int     10h
        or      ch,20h
        mov     ah,01h
        int     10h
     end;
end;

procedure CursorON;
begin
     asm
        mov     ah,0Fh
        int     10h
        mov     ah,03h
        int     10h
        and     ch,0DFh
        mov     ah,01h
        int     10h
     end;
end;

procedure BAR(barst:string;cur,max:word;cr:char);
var cc:longint;
    ca:byte;
begin
     write(chr(13),barst);
     if cur>max then cc:=max else cc:=cur;
     cc:=cc*50;
     cc:=cc div max;
     for ca:=1 to cc do write(cr);
end;

procedure DualBAR(barst:string;min,cur,max:word;cr1,cr2:char);
var sw1,sw2:word;
    cc1,cc2:longint;
    ca:byte;
begin
     write(chr(13),barst);
     sw1:=min;
     if min>cur then sw1:=cur;
     if sw1>max then sw1:=max;
     sw2:=cur;
     if cur>max then sw2:=max;
     cc1:=(sw1*50) div max;
     cc2:=(sw2*50) div max;
     for ca:=1 to cc1 do write(cr1);
     for ca:=1 to cc2-cc1 do write(cr2);
end;

procedure ErrorExit(error:word);
begin
     writeln;
     writeln('ERROR: ',errors[error]);
     CursorON;
     halt(error);
end;

procedure ByteCheck(d,pxt:byte;pxa:word);
begin
     if d<>orig[checkpos] then
     begin
          writeln;
          writeln('CONSISTENCE ERROR!');
          writeln;
          writeln('Token:   ',pxt:5);
          writeln('Address: ',pxa:5);
          CursorON;
          halt(99);
     end;
     inc(checkpos);
end;

procedure Push(bbit:word);
var pp:byte;
begin
     if (bbit>0) then pp:=255
                 else pp:=0;
     outp[outptr]:=outp[outptr] or (pp and outbitpos);
     outbitpos:=outbitpos+outbitpos;
     if outbitpos=0 then
     begin
          inc(outbitpos);
          inc(outptr);
     end;
     if EXTRABIT then
      if outptr=0 then
       if outbitpos=$80 then Push(1);
end;

procedure FastSearch(Spos,Xpos,Wsize:word);  {Csak a leghosszabb egyezs mrett }
var  sa,sFROM,sTO : word;               {adja vissza az ablakon bell!!!    }
     tmatchlen    : word;               {a pozcit NEM !                   }
     first        : byte;
     psrc,pdst    : word;
begin
     matchlen:=0;
     matchpos:=0;
     if Wsize>Spos then sFROM:=0 else sFROM:=Spos-Wsize; {cm alulcsorduls}
     sTO:=Spos-Xpos;
     first:=orig[Spos];

     if Xpos<=Spos then
     begin
     for sa:=sFROM to sTO do
     begin
      if orig[sa]=first then    {Ha vizsglt byte egyezik az elsovel}
      begin
           tmatchlen:=0;        {tmeneti hossz trl -> sszehasonltshoz}
           psrc:=Spos;
           pdst:=sa;
           repeat
                 if orig[psrc]=orig[pdst] then inc(tmatchlen);
                 inc(psrc); inc(pdst);
           until ((orig[psrc]<>orig[pdst]) or
                  ((psrc)>=origsize));
           if tmatchlen>matchlen then
           begin
                matchlen:=tmatchlen;
                matchpos:=sa;
           end;
      end;
     end;
     end;
end;

procedure PreOptimize;
var  E8table : array [0..65535] of word;
     c0,c1,c2: word;
     ta,tc   : word;    {temp address, counter}
     ba,bc   : word;    {best address, counter}
     ts,bs   : integer; {temp score, best score}
begin
     E8cklnum:=0;
     for c0:=0 to 65535 do E8table[c0]:=0;
     c0:=0; tc:=0; bs:=0;
     BAR(' Phase 1/3 : ',origsize,origsize,'');
     repeat
           if (orig[c0]=$E8) then
           begin
                inc(tc); ta:=c0;
                c1:=orig[c0+1]+256*orig[c0+2]+c0;
                inc(E8table[c1]);

                {Aktulis tblzat pont kalkulci}

                ts:=0;
                for c2:=0 to 65535 do
                begin
                     if E8table[c2]=1 then ts:=ts-2;
                     if E8table[c2]=2 then dec(ts);
                     if E8table[c2]>2 then ts:=ts+E8table[c2]-2;
                end;

                c0:=c0+2;       {relatv cm bjtok tugrsa}

                if ts>bs then
                begin
                     ba:=ta;    {utols kdoland E8 cm}
                     bc:=tc;    {E8 kd szmll}
                     bs:=ts;    {pont}
                end;
           end;
           inc(c0);
           if (c0 and $F)=0 then BAR(' Phase 1/3 : ',c0,origsize,'');
     until c0>=origsize;
     BAR(' Phase 1/3 : ',origsize,origsize,'');

     {rtkels, automatikus cmig val kdols, jelzk lltsa}

     E8cklnum:=ba+3;
     if bs>20 then
     begin
          c0:=0;                {E8 szmll}
          c1:=0;                {mdostsi cm}
          repeat

                while (orig[c1]<>$E8) do
                begin
                     inc(c1);
                end;
                dec(E8cklnum);
                c2:=orig[c1+1]+256*orig[c1+2];  {eredeti near call offset}
                ta:=c1+257;                     {mdost rtk}
                c2:=c2+ta;                      {mdostott}
                if FIXERMODE then
                begin
                     orig[c1+1]:=hi(c2);
                     orig[c1+2]:=lo(c2);        {forgatott}
                end
                else
                begin
                     orig[c1+1]:=lo(c2);
                     orig[c1+2]:=hi(c2);        {egyenes}
                end;
                c1:=c1+3;
                inc(c0);

          until c0>=bc;          {Ennyiszer kellett talaktani}
          preopt:=TRUE;
     end
     else preopt:=FALSE;         {nem rdemes talaktani}
end;

procedure Saving;
begin
     assign(outfile,outfname);
     rewrite(outfile,1);
     blockwrite(outfile,save,fullsize);

     BAR('                    ',1,1,' '); write(chr(13));

     writeln(' Size .... : ',fullsize:5,'/',origsize);
     writeln(' Ratio ... : ',100*fullsize/origsize:5:1,'%');
     CursorON;
end;

procedure SaveByte(sbb:byte);
begin
     save[fullsize]:=sbb;
     inc(fullsize);
end;

procedure AddDecompressor;
var adp,cntr:longint;
begin
     fullsize:=0;

     if preopt then
     begin   {max. 4kB, fixerrel}
         for adp:=0 to headersizeB-1 do SaveByte(decoderB[adp]);
         for cntr:=0 to outptr-1 do SaveByte(outp[cntr]);
         save[headerBcklpos]:=lo(E8cklnum);
         save[headerBcklpos+1]:=hi(E8cklnum);
     end
     else
     begin   {max. 4kB, fixer nlkli}
         for adp:=0 to headersizeA-1 do SaveByte(decoderA[adp]);
         for cntr:=0 to outptr-1 do SaveByte(outp[cntr]);
     end;

     if (fullsize>=origsize) or (fullsize>outlimit) then
     begin
          fullsize:=origsize;
          for adp:=0 to origsize-1 do save[adp]:=orig[adp];
     end;
end;

{!!! --- ALGORITMUSVALTOZTATAS ESETEN MODOSITANDO --- !!!}

function TokenSize(Slen,Ftype:word) : word;    {Slen <- matchlen   }
begin                                          {Ftype- frame tpusa}
     case Ftype of
      0: TokenSize:=9;           {move}
      1: TokenSize:=5;           {zero}
      2: TokenSize:=6+Slen;      {0ffff0S1+/7    1->1 bit, 2->2 bit, ...}
      3: TokenSize:=10+Slen-1;   {2+/112  2->1 bit, 3->2 bit, ...}
      4: TokenSize:=13+Slen-1;   {2+/1792 2->1 bit, 3->2 bit, ...}
     end;
end;

procedure BuildTables;
begin
     BAR(' Phase 2/3 : ',origsize,origsize,'');

     {Tblzatok feltltse alaprtkekkel - trls}

     for wa:=0 to 65535 do
     begin
          stable[0,wa]:=1;                      {source  - bytes}
          dtable[0,wa]:=Tokensize(1,0);         {dest.   - bits}
          ptable[0,wa]:=wa;                     {pozci - word}

          stable[1,wa]:=0;
          dtable[1,wa]:=65535;
          ptable[1,wa]:=wa;

          stable[2,wa]:=0;
          dtable[2,wa]:=65535;
          ptable[2,wa]:=wa;

          stable[3,wa]:=0;
          dtable[3,wa]:=65535;
          ptable[3,wa]:=wa;

          stable[4,wa]:=0;
          dtable[4,wa]:=65535;
          ptable[4,wa]:=wa;
                                                { 0   - nem fixpont }
          fixpoint[wa]:=255;                    { 1   - fix pont    }
                                                { 255 - nincs adat  }
     end;

     {Tblzatok feltltse}

     for wa:=0 to origsize-1 do
     begin

          {ZERO}

          if orig[wa]=0 then
          begin
               stable[1,wa]:=1;                      {1 bjtot jelent}
               dtable[1,wa]:=Tokensize(1,1);         {4 bit ZERO-hoz}
          end;

          {1/7}

          FastSearch(wa,1,15);            {matchlen=0, ha nincs egyezs}
          if matchlen>0 then
          begin
               BAR(' Phase 2/3 : ',wa,origsize,'');
               stable[2,wa]:=matchlen;
               dtable[2,wa]:=Tokensize(matchlen,2);  {5 biten}
               ptable[2,wa]:=matchpos;               {abszolut pozci}
          end;

          {2+/63}

          FastSearch(wa,16,127);          {matchlen=0, ha nincs egyezs}
          if matchlen>1 then
          begin
               stable[3,wa]:=matchlen;
               dtable[3,wa]:=TokenSize(matchlen,3);
               ptable[3,wa]:=matchpos;             {abszolut pozci}
          end;

          {2+/511}

          FastSearch(wa,128,1023);
          if matchlen>1 then
          begin
               stable[4,wa]:=matchlen;
               dtable[4,wa]:=TokenSize(matchlen,4);
               ptable[4,wa]:=matchpos;
          end;

     end;

     BAR(' Phase 2/3 : ',origsize,origsize,'');

     {Fix pont tbla feltltse}

     wa:=0; {mutat az aktulis bjt fixpoint tbla helyre}
     repeat
          if (stable[3,wa]>1) or (stable[4,wa]>1) or
             (stable[2,wa]>0) then
          begin
               BAR(' Phase 2/3 : ',wa,origsize,'');
               if (stable[2,wa]>=stable[3,wa]) and
                  (stable[2,wa]>=stable[4,wa]) then wb:=stable[2,wa];
               if (stable[3,wa]> stable[2,wa]) and
                  (stable[3,wa]>=stable[4,wa]) then wb:=stable[3,wa];
               if (stable[4,wa]> stable[2,wa]) and
                  (stable[4,wa]> stable[3,wa]) then wb:=stable[4,wa];
               for wc:=1 to wb do
               begin                  {wb hosszu string - biztosan}
                    fixpoint[wa]:=0;  {nem fix pontok :-)         }
                    inc(wa);
               end;
          end
          else
          begin
               fixpoint[wa]:=1;       {fix pont}
               inc(wa);
          end;
     until wa>=origsize;

     BAR(' Phase 2/3 : ',origsize,origsize,'');
end;

procedure SizeBitsOutf1(ssize:word);    {0/1, 10/2, 110/3, 1110/4, ...}
var scntr:word;
begin
     for scntr:=2 to ssize do Push(1);
     Push(0);
end;

procedure SizeBitsOutf2(ssize:word);    {0/2, 10/3, 110/4, 1110/5, ...}
var scntr:word;
begin
     for scntr:=3 to ssize do Push(1);
     Push(0);
end;

procedure Token0(T0adrs:word);
var T0dat:word;
begin
     {MOVE - 9 bit}
     T0dat:=orig[T0adrs];
     Push(0);                        {0dddddddd}
     Push(T0dat and $80);
     Push(T0dat and $40);
     Push(T0dat and $20);
     Push(T0dat and $10);
     Push(T0dat and $08);
     Push(T0dat and $04);
     Push(T0dat and $02);
     Push(T0dat and $01);
     ByteCheck(T0dat,0,T0adrs);
end;

Procedure Token1(chkpos:word);
begin
     {ZERO - 5 bit}
     Push(1);                        {10000}
     Push(0);
     Push(0);
     Push(0);
     Push(0);
     ByteCheck(0,1,chkpos);
end;

procedure Token2(T2adrs:word);
var cadrs:word;
 l:word;
begin
      { 1+/15 }
      cadrs:=T2adrs-ptable[2,T2adrs];
      Push(1);
      Push(cadrs and $08);
      Push(cadrs and $04);
      Push(cadrs and $02);
      Push(cadrs and $01);
      Push(1);
      SizeBitsOutf1(stable[2,T2adrs]);
      for l:=1 to stable[2,T2adrs] do
       ByteCheck(orig[ptable[2,T2adrs]-1+l],2,T2adrs);
end;

procedure Token3(T3adrs:word);
var cadrs:word;
 l:word;
begin
      { 2+/127 }
      cadrs:=T3adrs-ptable[3,T3adrs];
      Push(1);
      Push(cadrs and $40);
      Push(cadrs and $20);
      Push(cadrs and $10);
      Push(cadrs and $08);
      Push(0);
      Push(cadrs and $04);
      Push(cadrs and $02);
      Push(cadrs and $01);
      Push(1);
      SizeBitsOutf2(stable[3,T3adrs]);
      for l:=1 to stable[3,T3adrs] do
       ByteCheck(orig[ptable[3,T3adrs]-1+l],3,T3adrs);
end;

procedure Token4(T4adrs:word);
var cadrs:word;
 l:word;
begin
      { 2+/1023 }
      cadrs:=T4adrs-ptable[4,T4adrs];
      Push(1);
      Push(cadrs and $200);
      Push(cadrs and $100);
      Push(cadrs and $080);
      Push(cadrs and $040);
      Push(0);
      Push(cadrs and $020);
      Push(cadrs and $010);
      Push(cadrs and $008);
      Push(0);
      Push(cadrs and $004);
      Push(cadrs and $002);
      Push(cadrs and $001);
      SizeBitsOutf2(stable[4,T4adrs]);
      for l:=1 to stable[4,T4adrs] do
       ByteCheck(orig[ptable[4,T4adrs]-1+l],4,T4adrs);
end;

procedure FixPointOut(fpos:word);
begin
     {Bitenknt kikldeni, move,zero,szerint...}
     if stable[1,fpos]>0 then Token1(fpos)                    {ZERO}
     else
     Token0(fpos);                                            {MOVE}
end;

procedure MainCompressor;
var posA,posZ,posC,posO,posM:word;
    optt:array[0..3124] of longint;             {5 level, 5 variations}
    l0,l1,l2,l3,l4:word;                        {levels}
    s0,s1,s2,s3,s4:word;                        {source with validity}
    d0,d1,d2,d3,d4:word;                        {destination with validity}
    ssum,dsum,max:longint;                      {source and dest sizes (5)}
    cntr,tokentype:word;
begin
     posA:=inptr;                               {nyny els cm}
     posZ:=inptr;
     while fixpoint[posZ]=0 do inc(posZ);
     dec(posZ);                                 {nyny utols cm}

     {move:9 zero:5 frame1:6+ frame2:10+ frame3:13+}

     { felhasznlhat tblzatok :
        stable          : array [0..4,0..65535] of word;  - source in bytes
        dtable          : array [0..4,0..65535] of word;  - dest. in bits
        ptable          : array [0..4,0..65535] of word;  - pozci tbla }

     posC:=posA;        {current position}

     repeat

     posO:=0;           {Optimalizcis rtk cme a tblzatban}
     l0:=0; l1:=0; l2:=0; l3:=0; l4:=0;
     repeat
              s0:=stable[l0,posC]; d0:=dtable[l0,posC];
              s1:=stable[l1,posC+1]; d1:=dtable[l1,posC+1];
              s2:=stable[l2,posC+2]; d2:=dtable[l2,posC+2];
              s3:=stable[l3,posC+3]; d3:=dtable[l3,posC+3];
              s4:=stable[l4,posC+4]; d4:=dtable[l4,posC+4];

              if s0>1 then begin s1:=0; d1:=0; end;
              if s0>2 then begin s2:=0; d2:=0; end;
              if s0>3 then begin s3:=0; d3:=0; end;
              if s0>4 then begin s4:=0; d4:=0; end;

              if s1>1 then begin s2:=0; d2:=0; end;
              if s1>2 then begin s3:=0; d3:=0; end;
              if s1>3 then begin s4:=0; d4:=0; end;

              if s2>1 then begin s3:=0; d3:=0; end;
              if s2>2 then begin s4:=0; d4:=0; end;

              if s3>1 then begin s4:=0; d4:=0; end;

              ssum:=65536*(s0+s1+s2+s3+s4);
              dsum:=d0+d1+d2+d3+d4;

              optt[posO]:=ssum div dsum;
              inc(posO);

              inc(l4);
              if l4=5 then begin l4:=0; inc(l3); end;
              if l3=5 then begin l3:=0; inc(l2); end;
              if l2=5 then begin l2:=0; inc(l1); end;
              if l1=5 then begin l1:=0; inc(l0); end;
     until l0=5;

     posM:=0;
     max:=0;
     for cntr:=0 to 3124 do
      if optt[cntr]>=max then
      begin
           max:=optt[cntr];
           posM:=cntr;
      end;

     tokentype:=0;
     if (posM>= 625) and (posM<1250) then tokentype:=1;
     if (posM>=1250) and (posM<1875) then tokentype:=2;
     if (posM>=1875) and (posM<2500) then tokentype:=3;
     if (posM>=2500) and (posM<3125) then tokentype:=4;

     case tokentype of
      0:   begin
                Token0(posC);
                inc(posC);
           end;
      1:   begin
                Token1(posC);
                inc(posC);
           end;
      2:   begin
                Token2(posC);
                posC:=posC+stable[2,posC];
           end;
      3:   begin
                Token3(posC);
                posC:=posC+stable[3,posC];
           end;
      4:   begin
                Token4(posC);
                posC:=posC+stable[4,posC];
           end;
      end;

     until posC>posZ;
     inptr:=posC;
end;

procedure Compress;
begin
     checkpos:=0;
     BAR(' Phase 3/3 : ',origsize,origsize,'');
     inptr:=0; outptr:=0; outbitpos:=1;
     repeat
           if fixpoint[inptr]=1 then
           begin
                FixPointOut(inptr);
                inc(inptr);
           end
           else MainCompressor; {vagy fjl vgig, ha nincs tbb fp.   }

           DualBAR(' Phase 3/3 : ',outptr+100,inptr,origsize,'','');

     until inptr>=origsize;

     { move E8 kikldse, ha kell nc fixer }
     if preopt then {Token0 -> CONSISTENCE ERROR}
     begin
      Push(0);
      Push(1); Push(1); Push(1); Push(0); Push(1); Push(0); Push(0); Push(0);
     end;

     { End of Datas kikldse }
     Push(0); {Token0 -> CONSISTENCE ERROR}
     Push(0); Push(0); Push(0); Push(0); Push(0); Push(0); Push(0); Push(0);

     { Flush }
     Push(0); Push(0); Push(0); Push(0); Push(0); Push(0); Push(0);
end;

procedure Initialize;
begin
     writeln;
     writeln('  * 4C by Chut *');
     writeln('   ',Version);
     writeln;

     if length(paramstr(1))>0 then infname:=paramstr(1)
                              else infname:='';
     if length(paramstr(2))>0 then outfname:=paramstr(2)
                              else outfname:='OUT.COM';

     if length(infname)=0 then
     begin
          writeln(' Syntax  :  ',progname,' <input file> [output file]');
          writeln(' Example :  ',progname,' unpacked.com packed.com');
          writeln;
          writeln(' Input size limit  : ',inlimit:5,' bytes');
          writeln(' Output size limit : ',outlimit:5,' bytes');
          writeln;
          writeln(' Default output filename :  OUT.COM');
          writeln;
          halt(0);
     end;

     CursorOFF;

     assign(origfile,infname); {$I-}
     reset(origfile,1);        {$I+}
     if IOresult<>0 then ErrorExit(1);

     origsize:=filesize(origfile);
     if origsize>inlimit then ErrorExit(2);
     if origsize<100 then ErrorExit(3);

     blockread(origfile,orig,origsize);
     close(origfile);
end;

BEGIN   { *** F program *** }

  {fejlc kiraksa, fjl s paramter ellenrzs, betlts}

        Initialize;

  {E8 eloptimalizls}

        PreOptimize;

  {Tblzatok feltltse}

        BuildTables;

  {Compression ... tables+orig-->out}

        Compress;

  {decompressor illeszt - ments, befejezs}

        AddDecompressor;

  {fjl mentse, report}

        Saving;
end.