.model tiny	;Falling Tetrominos / 22nd Hugi Compo
.code		;
.486		;Akos Fekete / HUNGARY
.startup

s		equ	short
o		equ	offset
b		equ	byte ptr
w		equ	word ptr
salc		equ	db 0d6h

HC22:		mov	bp,o TileX0

		mov	al,13h
		int	10h

NewGame:	mov	ch,2		;Clear data memory
		xor	ax,ax
		mov	di,o Score
		rep	stosb

BuildTube:	mov	di,o PreTube
		mov	bx,1000000000010000b
		mov	cx,24*16+1
DrawBorder:	mov	al,10+1		;+1 because of empty
		rol	bx,1		;blocks
		jc	s Border
		salc
Border:		stosb
		loop	DrawBorder
		mov	cl,11		;bottom of tube
		rep	stosb
		
NextPiece:	mov	ax,9421
		cwd
Seed:		imul	ax,ax,12345
		inc	ax
		mov	w [o Seed+2],ax
		mov	bx,7
		div	bx
		xchg	ax,dx
		inc	ax		;Tile codes: 1-7 !!!

		mov	di,o CurrTile
		stosw
		add	ax,ax
		add	ax,o Tetros-2	;Because of empty block
		xchg	ax,si
		lodsw

GetCoord:	push	ax
		sar	ax,14
		stosb
		pop	ax
		shl	ax,2
		jnz	s GetCoord
		jc	s GetCoord

		mov	al,6		;start pos.: 6,0
		stosw

CalcSpeed:	mov	al,b [bp-13]	;MSB of Score
		neg	ax
		add	al,10
		mov	di,o Speed
		stosb
		stosb
		mov	ah,al
		xchg	ax,dx		;DL=DH=speed

		call	AbsAndCheck	;c=1 if collision
		jc	s TubeFull
		
MoveAgain:	mov	ah,1
		int	16h
		jz	s CheckDown
		call	SaveDatas
CheckKey:	call	GetKey		;AL=ASCII code
		mov	ah,2
		and	al,7
		mov	bx,o KeyTable
		xlatb
		call	ax
		call	AbsAndCheck
CheckDown:	call	WaitForOneTick
		sub	dl,1
		jg	s MoveAgain
		jnz	s Dropped
		mov	dl,dh
Dropped:	call	SaveDatas
		inc	b [bp-1]	;TileY
		call	AbsAndCheck
		jc	s No_More_Down
		or	dl,dl
		jns	s NotDropped
		inc	w [bp-14]	;Score
NotDropped:	call	ShowScreen
		jmp	s MoveAgain

No_More_Down:	mov	si,bp		;@TileX0
		mov	cl,4
PutIntoTube:	lodsw
		call	GetTubePos	;AX=Y,X->Tube pos.
		xchg	ax,di
		mov	ax,[bp-12]	;CurrTile
		stosb
		loop	PutIntoTube

CrunchRow:	mov	dx,20		;Score Counter
CheckTube:	mov	di,o Tube+1
CheckNextLine:	mov	cl,10
		xor	ax,ax
		push	di
		repnz	scasb
		pop	di
		jz	s NotFull
CopyLine:	lea	si,[di-16]
		mov	cl,10
		rep	movsb
		sub	di,26
		cmp	di,o Tube
		ja	s CopyLine
		add	w [bp-14],dx	;Score
		add	dx,dx
		stc			;C=1, don't show moved
		call	ShowScreen	;tiles
		mov	cl,[bp+9]	;SpeedOriginal
CrunchPause:	call	WaitForOneTick
		loop	CrunchPause
		jmp	s CheckTube

TubeFull:	push	o NewGame
GetKey:		xor	ax,ax
		int	16h
		cmp	al,27
		jne	s Key_Away
		mov	ax,3
		int	10h
		int	20h

NotFull:	add	di,16
		cmp	b [di],11	;Bottom of Tube
		jb	s CheckNextLine
		jmp	NextPiece

;-------------------------------------------------

GetTubePos:	shl	al,4		;AH=Y, AL=X
		shr	ax,4
		add	ax,o Tube	;DS:[AX]-Tube pos
Key_Away:	ret

;-------------------------------------------------

ShowScreen:	pusha
		pushf

		mov	cl,4
		mov	di,[bp-14]	;Score
Digits:		mov	ah,2
		mov	bx,10
		mov	dx,17
		add	dx,cx
		int	10h
		xchg	ax,di
		cwd
		div	bx
		xchg	ax,di
		xchg	ax,dx
		add	al,'0'
		int	29h
		loop	Digits

		mov	si,o Tube
		mov	di,112+8*320
		mov	cl,24		;tube depth
TubeY:		push	cx
		mov	cl,16		;tube width
TubeX:		lodsb
		call	DrawTile
		add	di,8
		loop	TubeX
		add	di,320*8-16*8
		pop	cx
		loop	TubeY	

		popf
		jc	s DontShowTiles

		mov	cl,4
		mov	si,bp		;TileX0
MovingTiles:	lodsw
		mov	bl,ah		;Y
		cbw			;X
		imul	di,bx,320	;Y*320
		add	ax,334
		add	di,ax
		shl	di,3		;(Y*320+X)*8+2672
		mov	al,b [bp-12]	;CurrTile
		call	DrawTile
		loop	MovingTiles

DontShowTiles:	popa
		ret

;-------------------------------------------------

Square:		push	es
		push	0A000h
		pop	es
		pusha
		
		mov	cx,bx
SquareLine:	pusha
		rep	stosb
		popa
		add	di,320
		dec	bx
		jnz	s SquareLine

		popa
		pop	es
		dec	bx
		ret

;-------------------------------------------------

WaitForOneTick:	pusha
		mov	ah,0
		int	1Ah
		mov	bl,dl
NoTick:		int	1Ah
		cmp	bl,dl
		je	s NoTick
		popa
		ret

;-------------------------------------------------

AbsAndCheck:	pusha
		mov	si,o TileX0r
		mov	di,bp		;@TileX0
		mov	cl,4
MakeAbsNext:	lodsw
		add	al,[bp-2]	;TileX
		add	ah,[bp-1]	;TileY
		stosw
		call	GetTubePos
		xchg	ax,bx
		salc
		or	al,[bx]
		jnz	s Collision
		loop	MakeAbsNext
		call	ShowScreen
		popa
		ret

SaveDatas:	pusha
		stc		
Collision:	cmc
		mov	si,cs
		mov	di,o TileX0r
		jc	s CopyDatas
		xchg	si,di
CopyDatas:	mov	cl,18
		rep	movsb
		popa
		ret

;-------------------------------------------------

DrawTile:	pusha
		mov	bl,8
		add	al,al
		jz	s Empty
		add	al,104-2	;Beacuse of Empty blocks
		call	Square
		sub	al,24
		call	Square
		sub	al,48
		add	di,321
Empty:		call	Square
		popa

Drop_Key:	mov	dl,-1
Unused_Key:	ret

Left_Key:	dec	b [bp-2]	;TileX
		ret

Right_Key:	inc	b [bp-2]	;TileX
		ret

Rotate_Key:	mov	si,o CurrTile
		lodsw			;AX=CurrTile
		dec	ax
		jng	s DontRotate	;blue square
		mov	di,si
		mov	cl,4
		cmp	b [si+9],ch	;top of stack
		je	s DontRotate
Rot_Key_Cycle:	lodsw
		neg	al
		xchg	al,ah
		stosw
		loop	Rot_Key_Cycle
DontRotate:	ret

;-------------------------------------------------

KeyTable	DB	low (o Drop_Key)	;space
		DB	low (o Unused_Key)
		DB	low (o Left_Key)	;j/J
		DB	low (o Rotate_Key)	;k/K
		DB	low (o Right_Key)	;l/L
		DB	low (o Unused_Key)
		DB	low (o Unused_Key)	;'.'
		;DB	low (o Unused_Key)

;-------------------------------------------------

Tetros		DW	0000110100011100b ;x0,y0,x1,y1,x2,...
		DW	0000110100010100b
		DW	0000010001011100b
		DW	0000000101011100b
		DW	0000110010000100b
		DW	0000010011011100b
		DW	0000010000011100b

;-------------------------------------------------

Score		DW	?

CurrTile	DW	?

TileX0r		DB	?
TileY0r		DB	?
TileX1r		DB	?
TileY1r		DB	?
TileX2r		DB	?
TileY2r		DB	?
TileX3r		DB	?
TileY3r		DB	?

TileX		DB	?
TileY		DB	?

TileX0		DB	?
TileY0		DB	?
TileX1		DB	?
TileY1		DB	?
TileX2		DB	?
TileY2		DB	?
TileX3		DB	?
TileY3		DB	?

Speed		DB	?
SpeedOriginal	DB	?

PreTube		DB	16 dup(?)

Tube		DB	384 dup(?)

		end	HC22