.model tiny	;Tic-Tac-Toe game for 21st Hugi-compo
.code		;written by Akos, Fekete (Chut)
.486
	Org	256

w	Equ	word ptr
b	Equ	byte ptr
s	Equ	short
o	Equ	offset

Hugi21:	mov	si,2499h		;reset movebits words
	xchg	ax,bx			;
	mov	di,si			;
	stosw				;
	stosw				;

	inc	ax			;40x25
	int	10h			;

	mov	ah,01h			;cursor off
	mov	ch,20h			;
	int	10h			;

	mov	al,0C4h			;
	mov	bp,o IT1029		;print out address

	mov	cx,11			;draw horizontal lines
	mov	dl,0Fh			;
hline:	mov	dh,0Bh			;
	call	bp			;
	mov	dh,0Dh			;
	call	bp			;
	inc	dx			;
	loop	hline			;

	mov	cl,5			;draw vertical lines
	mov	dh,0Ah			;
	inc	ax			;
vline:	xor	al,76h			;
	mov	dl,12h			;
	call	bp			;
	mov	dl,16h			;
	call	bp			;
	inc	dh			;
	loop	vline			;

human:	call	getkey			;

	sub	al,30h			;
	jz	s AI			;
	dec	ax			;0..8 bit addressing
	cmp	al,08h			;
	ja	s human			;

	bts	w ds:[si],ax		;common position table
	jc	s human			;

	mov	dl,'X'			;
	call	print			;

AI:	xor	bp,bp			;MATRIX pointer
	push	bp			;save best position
	
	mov	ax,4			;The MATRIX has you...
	cmp	w ds:[si+2],bp		;but not exactly  :-)
	ja	s solver		;
	bt	w ds:[si],ax		;some help for the matrix
	jnc	s moving		;to working well...
	jmp	s blcorn		;

solver:	push	bp			;save best value
	mov	w ds:[di],si		;
	
	mov	cl,9			;positions	
newpos:	cwd				;DX=current accumulator
nwline:	mov	bx,o weights		;BX->weight table pointer

gtspos:	mov	al,10h			;Get and Test position to AX (AL)
getbit:	bt	w ds:[o matrix],bp	;
	inc	bp			;
	rcl	al,1			;
	jnc	s getbit		;
	bt	w ds:[si],ax		;
	adc	bl,ah			;
	bt	w ds:[si+2],ax		;
	jnc	s nox			;generate pointer for weight table
	inc	bx			;
	inc	bx			;
nox:	neg	cx			;
	js	s gtspos		;

	add	dl,[bx]			;DX=weight accumulator
	rol	w ds:[di],1		;
	jnc	s nwline		;
	pop	ax			;best value
	cmp	al,dl			;check
	jae	s worse			;
	dec	cx			;
	bt	w ds:[si],cx		;is this position free?
	jc	s worse0		;
	pop	ax			;
	xchg	ax,dx			;new best value
	push	cx			;new best position
worse0:	inc	cx			;
worse:	push	ax			;
	loop	newpos			;
	pop	bp			;
blcorn:	pop	ax			;put 'O' to bottom-left corner

moving:	bts	w ds:[si],ax		;positions
	bts	w ds:[si+2],ax		;positions of AI
	shr	bp,5			;check for O-O-O
	jz	s nowin			;
	not	w ds:[si]		;O wins!
nowin:	mov	dl,'O'			;
	push	o human			;return address

print:	aam	3			;transforming
	shl	al,1			;0..8 -> video position
	shl	ax,1			;
	xor	ax,0E10h		;
	xchg	ax,dx			;
IT1029:	mov	ah,02h			;set cursorpos
	xor	bx,bx			;
	int	10h			;
	int	29h			;

eval:	cmp	w ds:[si],01FFh		;check end of game
	jb	s back			;

wrtmsg:	mov	dx,1411h		;write message
	int	10h			;
	mov	dx,o adraw		;
	je	s wrttxt		;
	mov	dl,low(o owins)		;
wrttxt:	mov	ah,09h			;printing...
	int	21h			;
	push	o Hugi21		;
	xchg	ax,cx			;

getkey:	int	16h			;
	cbw				;
	cmp	al,1Bh			;ESC ?
	jne	s back			;

exit:	mov	al,3			;reset video mode
	int	10h			;

weights	DB	1,3,7,4,1;0,32		;--,-o,oo,-x,ox,??,xx

	DB	0CDh			;int 20h

matrix	DB	00100000b,10100100b,11100110b	;(9) complete graf for AI
	DB	00101000b,00101000b,00010110b	;(8)
	DB	11000000b,00100100b,00011110b	;(7)
	DB	00101100b,00101100b,00010100b	;(6)
back:	DB	0C3h				;(5) replaced by a RET
	DB	10100010b,10100010b,01100000b	;(4)
	DB	10000000b,01100010b,00011010b	;(3)
	DB	01000000b,11100010b,11100010b	;(2)
	DB	01001000b,01101100b,00010010b	;(1) packed line positions 

adraw	DB	'A draw!$'			;
owins	DB	'O wins!$'			;

	End	Hugi21

;386 - first working code
;382 - h.lines				// INT29      <- AH=02/INT10
;371 - movebits table			// STOSW      <- MOV [xxxx],0000
;370 - overlap weights/matrix		//
;362 - change mode of player ident.	// MOV DL,'?' <- MOV [xxxx],'?'
;355 - common GET KEY			//
;349 - eliminating player moves table	// [xmoves] are the past...
;345 - removed some doubled instructions// XOR BX,BX; MOV AH,02
;335 - new display position routine     // XLATB, decompress... no more
;333 - put best position into stack	// try to free a register
;334 - put best value to stack		// SI is free
;333 - CX=9 -> CL=9 for loop		//
;321 - SI used for base for amoves      // [SI] <- [offset amoves]
;317 - SI used for base+index		// [SI+xxxx]  / omoves,matrix
;316 - SI filled up with internal value //
;314 - removed a XOR BX,BX		//
;313 - XOR AX,AX changed to XCHG AX,CX	// (getkey)
;312 - exchanged function of AX-DX	// get/test position
;311 - the messages has the same high b.// MOV DL,xx  <- MOV DX,02xx
;310 - fill up code is moved to 0100h	// INC AX <- MOV AX,0001
;303 - line drawer uses ITs from print	// CALL DI <- INT 10h, INT 29h
;299 - detect EOL on diffrent way	// MOV [si+4],2499h
;300 - fix a bug (INT10 changed AL)	// MOV AH,1;MOV AL,C4 <- MOV AX,1C4
;299 - movebit address -> 2499		// MOV [SI+4],SI <- MOV [SI+4],2499
;297 - rotator address -> 2499+@weights // [SI+BX] <- [SI+4]  x2
;295 - brrr... brainstorming		// try to free a register in AI part
;293 - inner loop, but jmp addres > 128 // NEG CX, JS <- double CALL
;291 - AH=00 in the inner loop (AI)  OK	// MOV AL,10h <- MOV AX,1000h
;289 - DI used for base address of rot	// MOV [SI+DI] <- [SI+4]
;285 - remove stack regeneration	// (pop xx, call xxxx)
;283 - hidden INT 20h between DB-s	//
;282 - weight addressing directly by BX	// ADD DL,[BX] <- ADD DL,[BX+xxxx]