;----------------------------------------------------------------------------;
;									     ;
;		entry for hugi compo #21 - 214 bytes total		     ;
;		 by boiled brain (pogonyshev@gmx.net, belarus)		     ;
;									     ;
;      compile: tasm /m2 entry.asm					     ;
;     and link: tlink /t entry.obj					     ;
;----------------------------------------------------------------------------;

;		some comments
;
;  the most vague trick used here is the value used for screen buffer
;  addressing. it is 0B800h - (10000h - (20*40*2 + 24*2)) / 16 = 0A867h.
;  the goal was to use jnz instead of loop in message printing, thus
;  saving two bytes on cl initialization. luckily, the grid/message
;  alignment provided in the rules allowed this.

		ideal
		p386				; for bts and bsf
		model	tiny
		codeseg
		org	100h

;----------------------------------------------------------------------------;
;		main procedure (program entry point) - 122 bytes	     ;
;  assumptions: ax = 0000h, bh = 00h, ch = 00h, df = 0			     ;
;----------------------------------------------------------------------------;
		proc	main

		;; initializing - 12 bytes ;;
		push	0B800h - (10000h - (20*40*2 + 24*2)) / 16
		pop	es			; es = 0B800h -> screen buffer
		mov	bl, 8			; used several times
next_game:
		int	10h			; ax = 0000h here
		xchg	bp, ax			; bp = 0000h - nothing in the
						;  field
		mov	dx, 111111111b		; no noughts in the field
						;  (zero bits stand for them)

		;; drawing horizontal lines - 16 bytes ;;
		mov	al, ''
		mov	di, 11*40*2 + 15*2 + (10000h - (20*40*2 + 24*2))
		mov	cl, 11			; ch is always zero here
horizontal_lines:
		mov	[es: di + 2*40*2], al	; draw the lower line
		stosb				; draw the upper line
		inc	di			; skip color attribute byte
		loop	horizontal_lines

		;; drawing vertical lines - 19 bytes ;;
		mov	ax, 1*100h + ''	; 1 for int 10h later
		mov	di, 10*40*2 + 18*2 + (10000h - (20*40*2 + 24*2))
		mov	cl, 5
vertical_lines:
		mov	[es: di + bx], al	; draw the line to the right
						;  (bx = 8 = 4*2)
		stosb				; draw the line to the left
		add	di, 1 + 39*2		; and go down
		xor	al, '' xor '' 	; and flip between '' and ''
		loop	vertical_lines

		;; killing the cursor - 3 bytes ;;
		dec	cx			; set cx = 0FFFFh
		int	10h			; kill the blinker (ah = 1)

		;; reading keys - 17 bytes ;;
read_key:
		mov	ah, 0
		int	16h			; read a key
		cbw				; sets ah to zero for all the
						;  keys we are interested in
						;  ([esc] and [0] - [9])
		cmp	al, 1Bh 		; [esc] ?
		je	quit			; the most sensible two bytes
						;  in the whole program
		sub	al, '0' 		; normalize the key
		je	generate_move		; the user is bored to death -
						;  she can't play anymore
		cmp	al, 9			; don't let the things get
		ja	read_key		;  hairy on funny keys

		;; analyzing and playing the move - 10 bytes ;;
		dec	ax			; normalize again
		bts	bp, ax			; check if there is something
						;  in the position already
						;  and set the bit (if none)
		jc	read_key		; no cheating!
		call	play_move		; get screen offset in di
		stosb				; draw the move on the screen
			; we don't check for a draw now, since
			; analyze_position is capable of doing
			; that

		;; generating and playing O moves - 17 bytes ;;
generate_move:
		call	analyze_position	; generate a move
		jnz	draw
			; analyze_position has a funny habit of
			; clearing zf if the board is full alredy.
			; note that find_winning_patterns has set
			; si to point to the "A draw!" string.
		bts	bp, ax			; set the bit. we know it is
						;  zero now and just ignore cf
		xor	dx, bp			; analyze_position converted
						;  dx to have zeros only where
						;  Xs lurk - nonsense, huh?
		call	play_move		; get screen offset in di
						;  and check for a win
		mov	si, offset nought_sign	; si pointers to 'O'
		movsb				; draw our brilliant move.
						;  si now points to the
						;  "O wins!" string

		;; checking for game over - 10 bytes ;;
		jz	o_wins			; now, that's strange, but we
						;  have won!
		sub	si, bx			; si now points to the
						;  "A draw!" string (bx = 8)
		cmp	bp, 111111111b		; check for a boring draw
		jne	read_key		; or so we have to continue
						;  this brain-twisting game

		;; displaying messages - 7 bytes ;;
draw:
o_wins:
		mov	di, 20*40*2 + 17*2 + (10000h - (20*40*2 + 24*2))
print_character:
		movsb				; put those seven characters
						; in right place
		inc	di			; and skip the nasty color
						;  attribute (wasted 3 bytes
						;  on the damned thing ):
		jnz	print_character

		;; reading a key and continuing if told to - 7 bytes ;;
		int	16h			; ah = 0 from play_move
		cmp	al, 1Bh
		xchg	ax, di			; zero ax
		jne	next_game		; a reasonable man will never
						;  try to investigate the
						;  function of this jump

		;; finalizing - 4 bytes ;;
quit:
		mov	al, 3
		int	10h			; erase all traces of this
						;  misery
			; i'm eager to place ret here and now,
			; but it is a size-optimization compo,
			; so we have to clench our teeth and
			; wait patiently till it falls through
			; the two procedures below
		endp	main

;----------------------------------------------------------------------------;
;		play_move procedure - 12 bytes				     ;
;	 input: al = move_to_play (0 - 8)				     ;
;	output: di = screen offset where to place a sign, ah = 0, al = 'O'   ;
;----------------------------------------------------------------------------;
		proc	play_move
		aam	3			; get row and column
		aad	-2*40 / 4		; rows stand 2 screen lines
						;  from each other (scaled
						;  down by 4 for now)
		sub	al, ((20 - 14)*40*2 + (24 - 16)*2) / (4*2)
						; unfortunately, the grid is
						;  not in the ul corner
		imul	bl			; scale up (bl = 8, 2 more for the
						;  the nasty color attribute)
		xchg	di, ax			; and place the offset where
						;  it works best
		mov	ax, 0*100h + 'X'	; ah = 0 is needed both times
						;  we call this procedure and
						;  we set al too to save a
						;  byte on opcode
			; fall through find_winning_patterns
			; below. when we play our own (O) moves,
			; it is useful to check for a win at the
			; same time. besides, it doesn't spoil
			; neither ax, nor di.
		endp	play_move

;----------------------------------------------------------------------------;
;		find_winning_patterns procedure - 13 bytes		     ;
;	 input: dx = mask with 0's in places where the signs of interest are ;
;	output: zf = 1 if the corresponding player has won, 0 otherwise      ;
;----------------------------------------------------------------------------;
		proc	find_winning_patterns
		mov	si, offset winning_patterns
		mov	cx, bx			; bx = 8, number of patterns
check_3_in_row:
		test	dx, [si]		; maybe this pattern works?
		jz	pattern_found		; return immediately then
		inc	si
		loop	check_3_in_row
pattern_found:
		ret
		endp	find_winning_patterns

;----------------------------------------------------------------------------;
;		analyze_position procedure - 44 bytes			     ;
;	 input: dx and bp as described in the beginning of the program	     ;
;		(but dx's role is reversed each on recursion, of course)     ;
;	output: al - recommended move. zf is set if board is full already    ;
;		cx > 0, cx < 0 and cx = 0 mean: we've lost, won, it is draw  ;
;----------------------------------------------------------------------------;
		proc	analyze_position
		xor	dx, bp			; we need to swap colors each
						;  turn
		call	find_winning_patterns	; maybe our opponent has won
						;  already?
		jz	position_analyzed	; then nothing to analyze
		cmp	bp, 111111110b		; funny comparison to avoid
						;  ending up with zf = 1
		ja	position_analyzed	; draw means less work too
		mov	cl, (offset winning_patterns + 8) - 100000000b
						; set cx to "very bad result"
						;  and prepare to save one
						;  byte on the next step
		sub	si, cx			; set si = 100000000b
try_next_move:
		test	bp, si			; can we play here?
		jnz	next_move		; no - try something else
		pusha				; we use quite a few registers
		xor	bp, si			; play the move internally
		call	analyze_position	; go recursive
		pop	ax			; store the result on stack
		push	cx			;  (will be popped to di)
		popa				; pop our property
		add	di, cx
			; this is a hidden comparison: we
			; need to check if -di <= cx (that is,
			; reversed result is not worse than
			; what we have had so far). it is
			; obviously the same as di + cx >= 0.
		js	next_move		; nothing good about this move
		sub	cx, di
			; best_result -= (-this_result + best_result)
			; the same as best_result = this_result
		bsf	ax, si			; store the current move
next_move:
		shr	si, 1			; next move
		jnz	try_next_move
position_analyzed:
		ret
		endp	analyze_position

		;; other stuff - 23 bytes ;;
		label	winning_patterns
			; table of winning patterns. the
			; highest bit of each pattern
			; overlaps with the next pattern.
			; 'A' kindly has its lowest bit
			; set. thank you, 'A'.
		db	01001001b
		db	10010010b
		db	00100100b
		db	00000111b
		db	00111000b
		db	01010100b
		db	11000000b
		db	00010001b

draw_string	db	"A draw!"
nought_sign	db	'O'
owins_string	db	"O wins!"
;xwins_string	 db	 "X wins!"		; note: uncommenting this
						;  won't let you win anyway.
						;  sorry
		end	main
