/*
  File: matrix.c
  Version: SAGA 4.0
  Written by: Fredrik Kling, 1997-05-03
  Description: This file contains all mathematical stuff for matrices

  -- Date -- | --- Name ---- |-- Did what....
  1997-05-03 | Fredrik Kling | Implementation

*/

#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "vmath/vmath.h"
#include "vmath/matrix.h"
#include "vmath/vector.h"


extern float *sintable;

void matmul (MATRIX *a,MATRIX *b, MATRIX *d)
{
  d->el[0][0] = a->el[0][0] * b->el[0][0] + a->el[0][1] * b->el[1][0] + a->el[0][2] * b->el[2][0];
  d->el[0][1] = a->el[0][0] * b->el[0][1] + a->el[0][1] * b->el[1][1] + a->el[0][2] * b->el[2][1];
  d->el[0][2] = a->el[0][0] * b->el[0][2] + a->el[0][1] * b->el[1][2] + a->el[0][2] * b->el[2][2];

  d->el[1][0] = a->el[1][0] * b->el[0][0] + a->el[1][1] * b->el[1][0] + a->el[1][2] * b->el[2][0];
  d->el[1][1] = a->el[1][0] * b->el[0][1] + a->el[1][1] * b->el[1][1] + a->el[1][2] * b->el[2][1];
  d->el[1][2] = a->el[1][0] * b->el[0][2] + a->el[1][1] * b->el[1][2] + a->el[1][2] * b->el[2][2];

  d->el[2][0] = a->el[2][0] * b->el[0][0] + a->el[2][1] * b->el[1][0] + a->el[2][2] * b->el[2][0];
  d->el[2][1] = a->el[2][0] * b->el[0][1] + a->el[2][1] * b->el[1][1] + a->el[2][2] * b->el[2][1];
  d->el[2][2] = a->el[2][0] * b->el[0][2] + a->el[2][1] * b->el[1][2] + a->el[2][2] * b->el[2][2];
}

static void rotateZ (int v, MATRIX *m)
{
  m->el[0][0]=COS(v);
  m->el[0][1]=SIN(v);
  m->el[1][0]=-SIN(v);
  m->el[1][1]=COS(v);

  m->el[1][2]=m->el[0][2]=m->el[2][0]=m->el[2][1]=0;
  m->el[2][2]=1;
}
static void rotateX (int v, MATRIX *m)
{
  /*  x'=x
   *  y'=y * cos (v) + z * sin (v)
   *  z'=z * cos (v) - y * sin (v)
   */
  m->el[1][1]=COS(v);
  m->el[1][2]=SIN(v);

  m->el[2][1]=-SIN(v);
  m->el[2][2]=COS(v);

  m->el[1][0]=m->el[2][0]=m->el[0][1]=m->el[0][2]=0;
  m->el[0][0]=1;

}
static void rotateY (int v, MATRIX *m)
{
  m->el[0][0]=COS(v);
  m->el[0][2]=SIN(v);
  m->el[2][0]=-SIN(v);
  m->el[2][2]=COS(v);

  m->el[2][1]=m->el[0][1]=m->el[1][0]=m->el[1][2]=0;
  m->el[1][1]=1;
}
/*
	Build rotation matrix.
	Written by: Fredrik Kling, 1996-10-xx
	Name: buildrotationmatrix
	In: x,y,z - angles, Matrix.
  Out: Not.

	function: Creates a rotation matrix with the angles.
*/
void buildrotationmatrix (int xv, int yv, int zv,MATRIX *m)
{
  MATRIX xm,ym,zm,tmp;

  rotateX (xv,&xm);
  rotateY (yv,&ym);
  rotateZ (zv,&zm);
  matmul (&xm,&ym,&tmp);    // matmul (&zm,&ym,&tmp);
  matmul (&tmp,&zm,m);      // matmul (&tmp,&xm,m);
}
// Totally ripped off from igge...
void matrixfromvectors (VECTOR *v, VECTOR *u, MATRIX *m)
{
	VECTOR w;
	float lambda;

	vector_normalize (v);

  /**** Nu blir u och v ortogonala! ****/

  lambda=dotproduct(u,v);

  u->x-=lambda*v->x;
  u->y-=lambda*v->y;
  u->z-=lambda*v->z;

	vector_normalize(u);

  vector_crossprod(v,u,&w);

  m->el[0][0] = w.x;
  m->el[0][1] = w.y;
  m->el[0][2] = w.z;

  m->el[1][0] = -u->x;
  m->el[1][1] = -u->y;
  m->el[1][2] = -u->z;

  m->el[2][0] = v->x;
  m->el[2][1] = v->y;
  m->el[2][2] = v->z;
}
/****************************************************************************
	Vektor Matris multiplikation.
	Written by: Fredrik Kling, 1996-10-xx
	Name: vecmul
	In: Matris, vector, vector.
	Ut: inget.

	funktion: Multiplicerar en vektor med en matris och lgger resultatet i en annan vektor. :)

********************************************************************************/
#ifndef __WATCOMC__
void vecmul (MATRIX *m, VECTOR *v, VECTOR *dv)
{
  dv -> x = m->el[0][0]*v->x + m->el[0][1]*v->y + m->el[0][2]*v->z;
  dv -> y = m->el[1][0]*v->x + m->el[1][1]*v->y + m->el[1][2]*v->z;
  dv -> z = m->el[2][0]*v->x + m->el[2][1]*v->y + m->el[2][2]*v->z;
}
#endif


