/*****************************************************************************
 *
 * File: vguiwin.c, Fredrik Kling 1997
 * Desc: This file holds all window handling functions...
 *
 * Updates:
 * -- Date -- | ----- Name ----- |-- Did what....
 * 1997-08-03 | Fredrik Kling    | Implementation
 * 1997-08-11 | Fredrik Kling    | Fixed menubars to handle separatorer...
 *
 ****************************************************************************/

#include <stdarg.h>
#include "vgui/vguiwin.h"
#include "vgui/vguimbar.h"
#include "vgui/vguigad.h"
#include "vgui/vgui.h"

#include "system/xstddef.h"
#include "system/xstdlib.h"
#include "system/xstdio.h"
#include "system/xstring.h"

#include "drivers/drv8.h"


extern DRV *drv;

/************************************************************************
 * Func: vguiwin_3dbar
 * Auth: Fredrik Kling
 * Date: 1997-08-04 - Implementation
 *
 * Desc: ritar en 3dbar
 *
 ************************************************************************/
void vguiwin_bar (int x1, int y1, int x2, int y2,int c)
{
	XYZ p1,p2;
	int i;

	p1.x = x1, p1.y = y1;
	p2.x = x2, p2.y = y2;


	p2.y = p1.y;

	for (i=p1.y;i<y2;i++)
	{
		drv->line (p1,p2,c);
		p1.y++,p2.y++;
	}
}
/************************************************************************
 * Func: vguiwin_inUA
 * Auth: Fredrik Kling
 * Date: 1997-08-04 - Implementation
 *
 * Desc: Kollar om en punkt ligger i UserArean...
 *
 ************************************************************************/
int vguiwin_inUA (int x, int y)
{
	VGUIWIN *win = vgui_activewin ();
	int maxx,minx,maxy,miny;

	minx = win->x1+3,miny = win->y1+3;
	maxx = win->x2-2,maxy = win->y2-2;

	if (win->caption)
	{
		miny+=16;
	}

	if ((x>minx) && (x<maxx))
	 if ((y>miny) && (y<maxy)) return TRUE;

	return FALSE;
}

/************************************************************************
 * Func: vguiwin_clearUA
 * Auth: Fredrik Kling
 * Date: 1997-08-04 - Implementation
 *
 * Desc: Rensar "User Area" av fnstret...
 *
 ************************************************************************/
void vguiwin_clearUA (void)
{
	VGUIWIN *win = vgui_activewin ();
	XYZ p1,p2;
	int i;

	p1.x = win->x1+4, p1.y = win->y1+4;
	p2.x = win->x2-3, p2.y = win->y1+4;

	if (win->caption) p1.y+=16;
	if (win->mbar) p1.y+=12;

	p2.y = p1.y;

	for (i=p1.y;i<win->y2-3;i++)
	{
		drv->line (p1,p2,VG_CMEDIUM);
		p1.y++,p2.y++;
	}

	vgui_postmessage (VGS_UPDATE,0,0,0);
}
/************************************************************************
 * Func: vgui_outstrxy
 * Auth: Fredrik Kling
 * Date: 1997-08-04 - Implementation
 *
 * Desc: Skriver ut en oformaterad strng..  internally use only!
 *
 ************************************************************************/
void vguiwin_outstrxy (int x, int y,int c,char *s)
{
//	VGUIWIN *win=vgui_activewin ();
	int i,xp;

	xp=0;
	for (i=0;i<strlen(s);i++)
	{
		if ((int)s[i]>=32)
		{
			if (vguiwin_inUA (x+xp,y))	xp+=vgui_putchxy (x+xp,y,c,s[i]);
				else xp+=vgui_charwidth (s[i]);
		} else
				switch (s[i])
				{
					case '\n' : 	// Newline
							y+=10,xp=0;
							break;
				}
	}
}

/************************************************************************
 * Func: vguiwin_printfxy
 * Auth: Fredrik Kling
 * Date: 1997-08-04 - Implementation
 *
 * Desc: Skriver ut en formaterad strng i ett fnster...
 *
 ************************************************************************/
void vguiwin_printfxy (int x, int y, char *str, ...)
{
	VGUIWIN *win;
	va_list values;
	char newstr[1024];

	va_start( values, str );
	vsprintf( newstr, str, values);
	va_end( values);

	win = vgui_activewin ();

	x+=win->x1+4;
	y+=win->y1+4;

	if (win->caption)	y+=16;
	if (win->mbar) y+=12;

	if ((x<win->x2) && (x>win->x1))
		if ((y<win->y2) && (y>win->y1))
		{
			vguiwin_outstrxy (x,y,255,newstr);
			vgui_postmessage (VGS_UPDATE,0,0,0);
		}
}
/************************************************************************
 * Func: vguiwin_printfxyc
 * Auth: Fredrik Kling
 * Date: 1997-08-04 - Implementation
 *
 * Desc: Skriver ut en formaterad strng i ett fnster med en frg..
 *
 ************************************************************************/
void vguiwin_printfxyc (int x, int y,int c,char *str, ...)
{
	VGUIWIN *win;
	va_list values;
	char newstr[1024];

	va_start( values, str );
	vsprintf( newstr, str, values);
	va_end( values);


	win = vgui_activewin ();

	x+=win->x1+4;
	y+=win->y1+4;

	if (win->caption)	y+=16;
	if (win->mbar) y+=12;

	if ((x<win->x2) && (x>win->x1))
		if ((y<win->y2) && (y>win->y1))
		{
			vguiwin_outstrxy (x,y,c,newstr);
			vgui_postmessage (VGS_UPDATE,0,0,0);
		}
}
/************************************************************************
 *
 * Some window drawing functions
 *
 ************************************************************************/

static void fixcoords (int x1, int y1, int x2, int y2, XYZ *p1, XYZ *p2, XYZ *p3, XYZ *p4)
{
	p1->l = p2->l = p3->l = p4->l = 0;

	p1->x = x1, p1->y = y1;
	p2->x = x1 + x2-x1, p2->y = y1;
	p3->x = p2->x, p3->y = y2;
	p4->x = p1->x, p4->y = p3->y;

}
void  vguiwin_inactivate (VGUIWIN *win)
{
	int i;
	XYZ p1,p2;

	p1.x = win->x1+2, p1.y = win->y1+2;
	p2.x = win->x2-1, p2.y = win->y1+2;

	for (i=0;i<12;i++)
	{
		drv->line (p1,p2,VG_COLINACTIVE);
		p1.y++;
		p2.y++;
	}
	if (win->mbar)
	{
		p1.y+=12;
		p2.y+=12;
	}
	drv->line (p1,p2,VG_CDARK);
	p1.y++;
	p2.y++;
	drv->line (p1,p2,VG_CLIGHT);
	p1.y++;
	p2.y++;

	for (i=p1.y;i<win->y2;i++)
	{
		drv->line (p1,p2,VG_CMEDIUM);
		p1.y++,p2.y++;
	}
  vgui_printfxyc (win->x1+4,win->y1+4,VG_CBLACK,win->caption);

}
static void drawcaption (VGUIWIN *win)
{
	int i;
	XYZ p1,p2;

	p1.x = win->x1+2, p1.y = win->y1+2;
	p2.x = win->x2-1, p2.y = win->y1+2;

	for (i=0;i<12;i++)
	{
		drv->line (p1,p2,VG_COLACTIVE);
		p1.y++;
		p2.y++;
	}
	if (win->mbar)
	{
		p1.y+=12;
		p2.y+=12;
	}
	drv->line (p1,p2,VG_CDARK);
	p1.y++;
	p2.y++;
	drv->line (p1,p2,VG_CLIGHT);
	p1.y++;
	p2.y++;

	for (i=p1.y;i<win->y2;i++)
	{
		drv->line (p1,p2,VG_CMEDIUM);
		p1.y++,p2.y++;
	}

  vgui_printfxyc (win->x1+4,win->y1+4,VG_CWHITE,win->caption);

}
static void drawmbar (VGUIWIN *win)
{
	XYZ p1,p2;
	int i,tx,ty;

	p1.x = win->x1+2, p1.y = win->y1+2;
	p2.x = win->x2-1, p2.y = win->y1+1;


	if (win->caption)	p1.y+=12;
	p2.y = ty = p1.y;

	for (i=0;i<12;i++)
	{
		drv->line (p1,p2,VG_CMEDIUM);
		p1.y++;
		p2.y++;
	}

	tx = win->x1+4;
	ty+=2;
	for (i=0;i<win->mbar->numitem;i++)
	{
		tx+=vgui_printfxyc (tx,ty,VG_CBLACK,"%s",win->mbar->list[i].caption);
		tx+=8;
	}
}
static int win_draw (VGUIWIN *win)
{
	XYZ p1,p2,p3,p4;
	VGUIGADGET *gad;
	int i;

	fixcoords (win->x1, win->y1, win->x2, win->y2, &p1,&p2,&p3,&p4);
	drv->line (p1,p2,VG_CLIGHT);
	drv->line (p2,p3,VG_CDARK);
	drv->line (p3,p4,VG_CDARK);
	drv->line (p4,p1,VG_CLIGHT);

	fixcoords (win->x1+1, win->y1+1, win->x2-1, win->y2-1, &p1,&p2,&p3,&p4);
	drv->line (p1,p2,VG_CMEDIUM);
	drv->line (p2,p3,VG_CMEDIUM);
	drv->line (p3,p4,VG_CMEDIUM);
	drv->line (p4,p1,VG_CMEDIUM);

	if (win->caption) drawcaption(win);
	if (win->mbar) drawmbar(win);

	if (win->gadgetlist)
	{
		for (gad = win->gadgetlist;gad!=NULL;gad=gad->next)
			vguigad_draw (gad->handle);
	}

	vgui_postmessage (VGS_UPDATE,0,0,0);
	return TRUE;
}
// Menu-bar select routine...
// Draws menu-bar with one item highlighted...
//
int vguiwin_mbarselect (int handle, int sel)
{
	VGUIWIN *win = vgui_activewin();
	int ofs,xa,yp,i,cyp,l,maxlen;

	xa=ofs=0;
	while ((win->mbar->list[ofs].handle!=handle) && (ofs<win->mbar->numitem))
	{
		xa+=vgui_strlen (win->mbar->list[ofs].caption)+8;
		ofs++;
	}
	if (ofs>=win->mbar->numitem) return sel;

	if (sel>=win->mbar->list[ofs].numitem) sel=0;
	 else if (sel<0) sel=win->mbar->list[ofs].numitem-1;

	yp = win->y1+14;
	if (win->caption) yp+=12;

	maxlen=0;
	for (i=0;i<win->mbar->list[ofs].numitem;i++)
		if ((l=vgui_strlen (win->mbar->list[ofs].list[i].caption))>maxlen) maxlen=l;


	cyp=0;

	for (i=0;i<win->mbar->list[ofs].numitem;i++)
	{
		if (win->mbar->list[ofs].list[i].flags & VGUIMBAR_SEPARATOR)
		{
			vgui_line (win->x1+6+xa,yp+cyp+2,win->x1+8+xa+maxlen,yp+cyp+2,VG_CDARK);
			vgui_line (win->x1+6+xa,yp+cyp+3,win->x1+8+xa+maxlen,yp+cyp+3,VG_CLIGHT);
			cyp+=4;
		}	else {
	  				 if (sel!=i)	vgui_printfxyc (win->x1+6+xa,yp+cyp+2,VG_CBLACK,"%s",win->mbar->list[ofs].list[i].caption);
							 else vgui_printfxyc (win->x1+6+xa,yp+cyp+2,VG_CWHITE,"%s",win->mbar->list[ofs].list[i].caption);
						 cyp+=10;
					 }
	}
	return sel;

}
// Pull the fucker..
void vguiwin_mbarpulldown (int handle)
{
	VGUIWIN *win = vgui_activewin ();
	int xa,yp,yf,num,ofs,i,maxlen,l,cyp;
	int sepnum = 0;

	ofs = 0;

	// Get ofs in list depending on handle, at same time..  calc xpos...
	xa=0;
	while ((win->mbar->list[ofs].handle!=handle) && (ofs<win->mbar->numitem))
	{
		xa+=vgui_strlen (win->mbar->list[ofs].caption)+8;
		ofs++;
	}
	// Check if legal...
	if (ofs>=win->mbar->numitem) return;

	// Step on it...  Calc position relative window position..
	// Hardcoded.. YHEAA!!!
	yp = win->y1+14;
	if (win->caption) yp+=12;

	// Print menubar caption...
	vgui_printfxy (win->x1+4+xa,win->y1+16,"%s",win->mbar->list[ofs].caption);

	// Items in current meny...
	num = win->mbar->list[ofs].numitem;

	// Get longest string...   to get correct Xpos..
	// AT the same time..  calculate separators
	maxlen=0;
	for (i=0;i<num;i++)
	{
		if ((l=vgui_strlen (win->mbar->list[ofs].list[i].caption))>maxlen) maxlen=l;
		if (win->mbar->list[ofs].list[i].flags & VGUIMBAR_SEPARATOR) sepnum++;
	}
	// Calculate ysize of menubar...
	yf = yp + 10 * win->mbar->list[ofs].numitem+4;
	yf = yf - sepnum*6;

	vguiwin_bar (win->x1+2+xa,yp,win->x1+10+xa+maxlen,yf,VG_CMEDIUM);

	// Draw box..
	vgui_line (win->x1+2+xa,win->y1+16,win->x1+2+xa,yf+1,VG_CLIGHT);
	vgui_line (win->x1+2+xa,yf,win->x1+10+xa+maxlen+1,yf,VG_CDARK);
	vgui_line (win->x1+10+xa+maxlen,yp,win->x1+10+xa+maxlen,yf,VG_CDARK);

	cyp=0;

	// Draw menubar items...
	for (i=0;i<num;i++)
	{
		if (win->mbar->list[ofs].list[i].flags & VGUIMBAR_SEPARATOR)
		{
			vgui_line (win->x1+6+xa,yp+cyp+2,win->x1+8+xa+maxlen,yp+cyp+2,VG_CDARK);
			vgui_line (win->x1+6+xa,yp+cyp+3,win->x1+8+xa+maxlen,yp+cyp+3,VG_CLIGHT);
			cyp+=4;
		}	else {
						 vgui_printfxyc (win->x1+6+xa,yp+cyp+2,VG_CBLACK,"%s",win->mbar->list[ofs].list[i].caption);
						 cyp+=10;
					 }
	}

	//vgui_postmessage (VGS_UPDATE,0,0,0);

}
/************************************************************************
 * Func: vguiwin_printfxy
 * Auth: Fredrik Kling
 * Date: 1997-08-04 - Implementation
 *
 * Desc: Skriver ut en formaterad strng i ett fnster...
 *
 ************************************************************************/
void vguiwin_resize (VGUIWIN *win,int xp, int yp)
{
	if (win==NULL) win = vgui_activewin ();
	win -> x2 = xp;
	win -> y2 = yp;
	vgui_postmessage (VGS_REDRAW,0,0,0);

}
/************************************************************************
 * Func: vguiwin_update
 * Auth: Fredrik Kling
 * Date: 1997-08-03 - Implementation
 *
 * Desc: Uppdaterar och ritar ut ett fnster... Om NULL ritar funktionen
 *		   om det aktiva fnstret...
 *
 ************************************************************************/
int vguiwin_update (VGUIWIN *win)
{
	XYZ p;
	int r;

	if (win==NULL) 	r=win_draw (vgui_activewin());
		else r=win_draw (win);
	return r;
}
void vguiwin_setup (VGUIWIN *win)
{

	// Preset some values...

	win->x1 = win-> y1 = 0;
	win->x2 = win-> y2 = 100;

	win -> id = win->handle = win->numgadget = 0;
	win -> flags = VGUINORMAL;

	win -> caption = NULL;
	win -> mbar = NULL;
	win -> gadgetlist = NULL;

}


