#include "system/xstdlib.h"
#include "dbfspack.h"

//-----------------------------------------------------------------------------
//
// Structures
//
//-----------------------------------------------------------------------------

typedef struct
{
	int init;

	DWORD look;

	DWORD m_len;
	DWORD m_off;

	const BYTE *ip;
	const BYTE *in;
	const BYTE *in_end;
  BYTE *out;

	DWORD textsize;
	DWORD codesize;

	DWORD lit_bytes;
	DWORD match_bytes;
	DWORD lazy;

  DWORD r1_lit;
	DWORD r1_m_len;

	DWORD m1a_m, m1b_m, m2_m, m3_m, m4_m;
	DWORD lit1_r, lit2_r, lit3_r;
} PACK;

typedef struct
{
	DWORD m_len;
	DWORD m_pos;
	DWORD look;
	int swd_char;
	PACK *c;

	DWORD b_size;
	DWORD hash_count;
	DWORD bbf, inptr;

	BYTE b [  0xbfff  +  2048  +  2048  - 1];

	WORD ll [  0xbfff  +  2048  ];
	WORD best [  0xbfff  +  2048  ];
	WORD ccnt [  16384  ];
	WORD cr3 [  16384  ];

	WORD cr2 [ 65536L ];

} SPACK;

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------

static int swd_init( SPACK  *s)
{
	DWORD i;
	int c;

	s->b_size = 0xbfff + 2048;
	if( s->b_size + 2048 >= 65535U )
		return( FALSE /*-1*/);

	s->hash_count = 0xbfff;
	for( i=0; i<16384; i++)
		s->ccnt[i] = 0;

	for( i=0; i<65536L; i++)
		s->cr2[i] = 65535U ;

	s->bbf = s->look = s->inptr = 0;
	while( s->look < 2048)
	{
		if( (c = ((*(s->c)).ip < (*(s->c)).in_end ? *((*(s->c)).ip)++ : (-1)) ) < 0)
			break;
		s->b[s->inptr++] =  ((BYTE) (c)) ;
		s->look++;
	}
	s->m_len =  1 ;
	return( TRUE /*0*/);
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------


static void swd_getbyte( SPACK  *s)
{
	int c;

	if (++s->bbf == s->b_size)
		s->bbf = 0;

	if ((c =  ((*(s->c)).ip < (*(s->c)).in_end ? *((*(s->c)).ip)++ : (-1)) ) < 0)
	{
		if (s->look > 0)
			--s->look;
		if (++s->inptr == s->b_size)
			s->inptr = 0;
	}
	else if (s->inptr <  2048  - 1)
	{
		s->b[s->inptr + s->b_size] = s->b[s->inptr] =  ((BYTE) (c)) ;
		++s->inptr;
	}
	else
	{
		s->b[s->inptr] =  ((BYTE) (c)) ;
		if (++s->inptr == s->b_size)
			s->inptr = 0;
	}
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------

static void _swd_remove_hash( SPACK  *s)
{
	if (s->hash_count == 0)
	{
		DWORD i;

		i =  (((40799u*(((((DWORD)s->b[s->inptr]<<5)^s->b[s->inptr+1])<<5)^s->b[s->inptr+2]))>>5) & (16384-1)) ;
		--s->ccnt[i];


		i =  (s->b[s->inptr] | ((unsigned)s->b[s->inptr+1]<<8)) ;
		if (s->cr2[i] == s->inptr)
			s->cr2[i] =  65535U ;

	}
	else
		--s->hash_count;
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------

static void swd_accept( SPACK  *s, DWORD j)
{
	while (j--)
	{
		DWORD i;

		_swd_remove_hash(s);


		i =  (((40799u*(((((DWORD)s->b[s->bbf]<<5)^s->b[s->bbf+1])<<5)^s->b[s->bbf+2]))>>5) & (16384-1)) ;
		s->ll[s->bbf] = s->cr3[i];
		s->cr3[i] =  ((WORD)(s->bbf)) ;
		s->best[s->bbf] =  2048  + 1;
		s->ccnt[i]++;



		i =  (s->b[s->bbf] | ((unsigned)s->b[s->bbf+1]<<8)) ;
		s->cr2[i] =  ((WORD)(s->bbf)) ;


		swd_getbyte(s);
	}

	s->m_len =  1 ;
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------

static DWORD _swd_findbest( SPACK  *s, DWORD cnt, DWORD ptr)
{
	register BYTE *b = s->b;
	register BYTE *pbbf = b + s->bbf;
	DWORD m_len = s->m_len;
	BYTE * const pxx = pbbf + s->look;
	DWORD i;
	BYTE ref1;

	i =  (b[s->bbf] | ((unsigned)b[s->bbf+1]<<8)) ;
	i = s->cr2[i];
	if (i ==  65535U )
		return( m_len);
	if (m_len <= 2)
	{
		m_len = 2;
		s->m_pos = i;
		if (m_len == s->look)
			return( m_len);
	}

	if (cnt == 0)
		return( m_len);



	ref1 = pbbf[m_len - 1];


	do {

		if (b[ptr + m_len - 1] == ref1 && b[ptr + m_len] == pbbf[m_len] &&
		    b[ptr] == pbbf[0] && b[ptr + 1] == pbbf[1])

		{
			register BYTE *p1 = pbbf + 3;
			register BYTE *p2 = b + ptr + 3;
			register BYTE *px = pxx;

			while (p1 < px && *p1 == *p2)
				p1++, p2++;

			i = p1 - pbbf;
			if (i > m_len)
			{
				s->m_pos = ptr;
				if ((m_len = i) == s->look || s->best[ptr] < i)
					return( m_len);

				ref1 = pbbf[m_len - 1];


			}
		}
		ptr = s->ll[ptr];
	} while (--cnt > 0);




	return( m_len);
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------

static void swd_findbest( SPACK  *s)
{
	DWORD i;
	DWORD cnt, ptr, start_len;
	const DWORD bbf = s->bbf;

	i =  (((40799u*(((((DWORD)s->b[bbf]<<5)^s->b[bbf+1])<<5)^s->b[bbf+2]))>>5) & (16384-1)) ;
	if ((cnt = s->ccnt[i]++) >  1024 )
		cnt =  1024 ;
	ptr = s->ll[bbf] = s->cr3[i];

	s->cr3[i] =  ((WORD)(bbf)) ;

	s->swd_char = s->b[bbf];
	s->m_pos =  0xbfff  + 1;
	if ((start_len = s->m_len) >= s->look)
	{
		if (s->look == 0)
			s->swd_char = -1;
		s->best[bbf] =  2048  + 1;
	}
	else
	{
		s->m_len = _swd_findbest(s,cnt,ptr);
		s->best[bbf] =  ((WORD)(s->m_len)) ;
		if (s->m_len > start_len)
		{
			if (s->m_pos < bbf)
				s->m_pos = bbf - s->m_pos - 1;
			else
				s->m_pos = s->b_size - 1 - s->m_pos + bbf;
		}
	}

	_swd_remove_hash(s);



	i =  (s->b[bbf] | ((unsigned)s->b[bbf+1]<<8)) ;
	s->cr2[i] =  ((WORD)(bbf)) ;


	swd_getbyte(s);
}


//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------

static int match_init (  PACK  *c,  SPACK  *s )
{
	s->c = c;

	c->init = 1;
	c->textsize = c->codesize  = 0;
	c->lit_bytes = c->match_bytes = c->lazy = 0;

	return( swd_init(s));
}


//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------

static int find_match (  PACK  *c,  SPACK  *s,
			 DWORD this_len, DWORD skip )
{
	int r;

	if (!c->init)
	{
		r = match_init(c,s);
		if (r != TRUE /*0*/)
		{
			c->look = 0;
			c->m_len = 0;
			return( r);
		}
	}

	if (skip > 0)
	{
		swd_accept(s, this_len - skip);
		c->textsize += this_len - skip + 1;
	}
	else
	{
		c->textsize += this_len - skip;
	}

	s->m_len =  1 ;
	swd_findbest(s);
	c->m_len = s->m_len;
	c->m_off = s->m_pos + 1;

	if (s->swd_char < 0)
	{
		c->look = 0;
		c->m_len = 0;
	}
	else
	{
		c->look = s->look + 1;
	}

	return( TRUE /*0*/);
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------

static  BYTE   *code_match (  PACK  *c,  BYTE   *op, DWORD m_len, DWORD m_off )
{
	c->match_bytes += m_len;

	if (m_len == 2)
	{
		m_off -= 1;
		*op++ =  ((BYTE) (0 | ((m_off & 3) << 2))) ;
		*op++ =  ((BYTE) (m_off >> 2)) ;
		c->m1a_m++;
	}
	else if (m_len <=  8  && m_off <=  0x0800 )
	{
		m_off -= 1;
		*op++ =  ((BYTE) (((m_len - 1) << 5) | ((m_off & 7) << 2))) ;
		*op++ =  ((BYTE) (m_off >> 3)) ;
		c->m2_m++;
	}
	else if (m_len ==  3  && m_off <=  (0x0400 + 0x0800)  && c->r1_lit >= 4)
	{
		m_off -= 1 +  0x0800 ;
		*op++ =  ((BYTE) (0 | ((m_off & 3) << 2))) ;
		*op++ =  ((BYTE) (m_off >> 2)) ;
		c->m1b_m++;
	}
	else if (m_off <=  0x4000 )
	{
		m_off -= 1;
		if (m_len <=  33 )
			*op++ =  ((BYTE) (32 | (m_len - 2))) ;
		else
		{
			m_len -=  33 ;
			*op++ =  32  | 0;
			while (m_len > 255)
			{
				m_len -= 255;
				*op++ = 0;
			}
			*op++ =  ((BYTE) (m_len)) ;
		}
		*op++ =  ((BYTE) ((m_off & 63) << 2)) ;
		*op++ =  ((BYTE) (m_off >> 6)) ;
		c->m3_m++;
	}
	else
	{
		DWORD k;

		m_off -= 0x4000;
		k = (m_off & 0x4000) >> 11;
		if (m_len <=  9 )
			*op++ =  ((BYTE) (16 | k | (m_len - 2))) ;
		else
		{
			m_len -=  9 ;
			*op++ =  ((BYTE) (16 | k | 0)) ;
			while (m_len > 255)
			{
				m_len -= 255;
				*op++ = 0;
			}
			*op++ =  ((BYTE) (m_len)) ;
		}
		*op++ =  ((BYTE) ((m_off & 63) << 2)) ;
		*op++ =  ((BYTE) (m_off >> 6)) ;
		c->m4_m++;
	}

	return( op);
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------

static BYTE *STORE_RUN ( PACK *c, BYTE *op, const BYTE *ii, DWORD t )
{
	c->lit_bytes += t;

	if (op == c->out && t <= 238)
	{
		*op++ =  ((BYTE) (17 + t)) ;
	}
	else if (t <= 3)
	{
		op[-2] |=  ((BYTE) (t)) ;
		c->lit1_r++;
	}
	else if (t <= 18)
	{
		*op++ =  ((BYTE) (t - 3)) ;
		c->lit2_r++;
	}
	else
	{
		DWORD tt = t - 18;

		*op++ = 0;
		while (tt > 255)
		{
			tt -= 255;
			*op++ = 0;
		}
		*op++ =  ((BYTE) (tt)) ;
		c->lit3_r++;
	}
	do *op++ = *ii++; while (--t > 0);

	return( op);
}

//-----------------------------------------------------------------------------
//
// Compress
//
//-----------------------------------------------------------------------------

int dbfs_compress( BYTE *in, DWORD in_len, BYTE *out, DWORD *out_len)
{
	BYTE *op;
	const BYTE *ii;
	DWORD lit;
	DWORD m_len, m_off;
	PACK cc;
	PACK * const c = &cc;
	SPACK * const swd = xmalloc( sizeof( SPACK));
	int r;


//	if (!lzo_assert( ((DWORD) (14 * 16384L * sizeof(short)))  >=  ((DWORD) (sizeof(SPACK))) ))
//		return  ( FALSE /* -1 */) ;


	c->init = 0;
	c->ip = c->in = in;
	c->in_end = in + in_len;
	c->out = out;
	c->m1a_m = c->m1b_m = c->m2_m = c->m3_m = c->m4_m = 0;
	c->lit1_r = c->lit2_r = c->lit3_r = 0;

	op = out;
	ii = c->ip;
	lit = 0;
	c->r1_lit = c->r1_m_len = 0;

	r = find_match(c,swd,0,0);
	if (r != TRUE /*0*/)
	{
    xfree( swd);
		return( r);
	}
	while (c->look > 0)
	{
		int lazy_match_min_gain = -1;
		DWORD ahead = 0;

		m_len = c->m_len;
		m_off = c->m_off;

		if (lit == 0)
			ii = c->ip - c->look;

		if ((m_len < 2) ||
		    (m_len == 2 && (m_off >  0x0400  || lit == 0 || lit >= 4 || op == out)))
		{

			m_len = 0;
		}
		else if (m_len ==  3  && m_off >  0x0800 )
		{

			if (m_off <=  (0x0400 + 0x0800)  && lit >= 4)
				;
			else if (lit >= 4)
				m_len = 0;
		}

		if (m_len > 0)
		{

			if (lit < 3)
				lazy_match_min_gain = 1;
			else if (lit == 3)
				lazy_match_min_gain = 3;
			else if (lit == 18)
				lazy_match_min_gain = 3;
			else
				lazy_match_min_gain = 1;
		}


		if (m_len > 0 && c->look > m_len)
		{
			r = find_match(c,swd,1,0);

			if (m_len ==  3 )
			{
				if (lit >= 4)
				{
					if (c->m_off >  (0x0400 + 0x0800) )
						lazy_match_min_gain += 1;
				}
				else
				{
					if (m_off <=  0x0800  && c->m_off >  0x0800 )
						lazy_match_min_gain += 1;
				}
			}
			else if (m_len <=  8  && m_off <=  0x0800  &&
			         c->m_off >  0x0800 )
			{
				lazy_match_min_gain += 1;
			}


			if (c->m_len <=  8  && c->m_off <=  0x0800  &&
			    m_off >  0x0800 )
			{
				if (lazy_match_min_gain > 0)
					lazy_match_min_gain -= 1;
			}


			if (m_len == 2)
				if (lazy_match_min_gain == 0)
					lazy_match_min_gain = 1;

			if (c->m_len >= m_len + lazy_match_min_gain)
			{
				c->lazy++;

				lit++;
				continue;
			}
			else
			{
				ahead = 1;
			}
		}


		if (m_len == 0)
		{

			lit++;
			r = find_match(c,swd,1,0);
		}
		else
		{

			if (lit > 0)
			{
				if( (op + lit) >= (out + in_len))
				{
					xfree( swd);
					return( FALSE);
				}
				op = STORE_RUN(c,op,ii,lit);
				c->r1_m_len = m_len;
				c->r1_lit = lit;
				lit = 0;
			}
			else
			{
				c->r1_lit = c->r1_m_len = 0;
			}


			op = code_match(c,op,m_len,m_off);
			r = find_match(c,swd,m_len,1+ahead);
		}

		c->codesize = op - out;
	}


	if (lit > 0)
	{
		if( (op + lit) >= (out + in_len))
		{
			xfree( swd);
			return( FALSE);
		}
		op = STORE_RUN(c,op,ii,lit);
	}

	*op++ =  16  | 1;
	*op++ = 0;
	*op++ = 0;


	c->codesize = op - out;

	*out_len = op - out;

	xfree( swd);
	return( TRUE /*0*/);
}

//-----------------------------------------------------------------------------
//
// Decompress
//
//-----------------------------------------------------------------------------

int dbfs_decompress( BYTE *in, DWORD in_len, BYTE *out, DWORD out_len)
{
	register BYTE *op;
	register const BYTE *ip;
	register DWORD t;
	register const BYTE *m_pos;

	const BYTE * const ip_end = in + in_len;
	BYTE * const op_end = out + out_len;

	op = out;
	ip = in;

	if (*ip > 17)
	{
		t = *ip++ - 17;
		if (op_end - op < (ptrdiff_t)(t)) goto output_overrun ;  if (ip_end - ip < (ptrdiff_t)(t+1)) goto input_overrun ;
		do *op++ = *ip++; while (--t > 0);
		goto first_literal_run;
	}

	while ( (ip < ip_end)  &&  1 )
	{
		t = *ip++;
		if (t >= 16)
			goto match;

		if (t == 0)
		{
			 if (ip_end - ip < (ptrdiff_t)(1)) goto input_overrun ;
			while (*ip == 0)
			{
				t += 255;
				ip++;
				 if (ip_end - ip < (ptrdiff_t)(1)) goto input_overrun ;
			}
			t += 15 + *ip++;
		}

		if (op_end - op < (ptrdiff_t)(t+3)) goto output_overrun ;  if (ip_end - ip < (ptrdiff_t)(t+4)) goto input_overrun ;

		* ( DWORD * ) op = * ( DWORD  * ) ip;
		op += 4; ip += 4;
		if (--t > 0)
		{
			if (t >= 4)
			{
				do {
					* ( DWORD * ) op = * ( DWORD * ) ip;
					op += 4; ip += 4; t -= 4;
				} while (t >= 4);
				if (t > 0) do *op++ = *ip++; while (--t > 0);
			}
			else
				do *op++ = *ip++; while (--t > 0);
		}

first_literal_run:

		t = *ip++;

		if (t >= 16)
			goto match;
		m_pos = op - 1 -  0x0800 ;
		m_pos -= t >> 2;
		m_pos -= *ip++ << 2;
		 if (m_pos < out) goto lookbehind_overrun ;  if (op_end - op < (ptrdiff_t)(3)) goto output_overrun ;
		*op++ = *m_pos++; *op++ = *m_pos++; *op++ = *m_pos;
		goto match_done;

		while ( (ip < ip_end)  &&  1 )
		{
match:
			if (t >= 64)
			{
				m_pos = op - 1;

				m_pos -= (t >> 2) & 7;
				m_pos -= *ip++ << 3;
				t = (t >> 5) - 1;

				 if (m_pos < out) goto lookbehind_overrun ;
				 if (op_end - op < (ptrdiff_t)(t+3-1)) goto output_overrun ;
				goto copy_match;
			}
			else if (t >= 32)
			{
				t &= 31;
				if (t == 0)
				{
					 if (ip_end - ip < (ptrdiff_t)(1)) goto input_overrun ;
					while (*ip == 0)
					{
						t += 255;
						ip++;
						 if (ip_end - ip < (ptrdiff_t)(1)) goto input_overrun ;
					}
					t += 31 + *ip++;
				}
				m_pos = op - 1;

				m_pos -= (* ( WORD  * ) ip) >> 2;
				ip += 2;

			}

			else if (t >= 16)
			{

				m_pos = op;
				m_pos -= (t & 8) << 11;
				t &= 7;
				if (t == 0)
				{
					 if (ip_end - ip < (ptrdiff_t)(1)) goto input_overrun ;
					while (*ip == 0)
					{
						t += 255;
						ip++;
						 if (ip_end - ip < (ptrdiff_t)(1)) goto input_overrun ;
					}
					t += 7 + *ip++;
				}

				m_pos -= (* ( WORD  * ) ip) >> 2;
				ip += 2;

				if (m_pos == op)
					goto eof_found;
				m_pos -= 0x4000;
			}

			else
			{
				m_pos = op - 1;
				m_pos -= t >> 2;
				m_pos -= *ip++ << 2;
				 if (m_pos < out) goto lookbehind_overrun ;  if (op_end - op < (ptrdiff_t)(2)) goto output_overrun ;
				*op++ = *m_pos++; *op++ = *m_pos;
				goto match_done;
			}



			 if (m_pos < out) goto lookbehind_overrun ;
			 if (op_end - op < (ptrdiff_t)(t+3-1)) goto output_overrun ;

			if (t >= 2 * 4 - (3 - 1) && (op - m_pos) >= 4)
			{
				* ( DWORD * ) op = * ( DWORD * ) m_pos;
				op += 4; m_pos += 4; t -= 4 - (3 - 1);
				do {
					* ( DWORD * ) op = * ( DWORD * ) m_pos;
					op += 4; m_pos += 4; t -= 4;
				} while (t >= 4);
				if (t > 0) do *op++ = *m_pos++; while (--t > 0);
			}
			else

			{
copy_match:
				*op++ = *m_pos++; *op++ = *m_pos++;
				do *op++ = *m_pos++; while (--t > 0);
			}

match_done:
			t = ip[-2] & 3;
			if (t == 0)
				break;


			if (op_end - op < (ptrdiff_t)(t)) goto output_overrun ;  if (ip_end - ip < (ptrdiff_t)(t+1)) goto input_overrun ;
			do *op++ = *ip++; while (--t > 0);
			t = *ip++;
		}
	}


	return( (ip == ip_end)? FALSE /*-3*/: FALSE /*-1*/);

eof_found:
	return( (ip == ip_end)? TRUE : FALSE /*-1*/);

input_overrun:
	return( FALSE /*-4*/);

output_overrun:
	return( FALSE /*-5*/);

lookbehind_overrun:
	return( FALSE /*-6*/);

}

