#pragma once

//#ifndef __DBFS_H
//#define __DBFS_H

#ifdef __WATCOMC__
#pragma library("misc.lib")
#endif

#ifdef __cplusplus
extern "C" {
#endif
//---------------------------------------------------------------------------//
#include "system/xstdio.h"

#define DBFS_ID "NOCDBFS"
#define DBFS_IDSIZE 8
#define DBFS_VERSION 0x0110

typedef struct s_DBFS DBFS;
typedef enum
{
	DBFSFLAG_READONLY = 1 << 0,
	DBFSFLAG_MODIFIED = 1 << 31,
}	DBFSFLAGS;
typedef struct s_DBFILE DBFILE;
typedef enum
{
	DBFILEFLAG_COMPRESSED = 1 << 0,
	DBFILEFLAG_CRYPTED = 1 << 1,
	DBFILEFLAG_NULLFILE = 1 << 2,
	DBFILEFLAG_MODIFIED = 1 << 31,
}	DBFILEFLAGS;


struct s_DBFS
{
	DBFSFLAGS flags;

	WORD files;
	DBFILE *filelist;

	char readname[256],writename[256];
	FILE *readfile,*writefile;

	int startdata;
	int starttoc;
};

struct s_DBFILE
{
	DBFILE *prev,*next;
	DBFS *dbfs;

	DBFILEFLAGS flags;

	DWORD flength,plength,length;
	DWORD crc;

	int filepos;

	char name[256];
};

extern int dbfspack;
extern int dbfscrypt;
extern int dbfserrno;
extern void( *dbfscallback)( char *statusstr);

void dbfsconfig( void ( *progress)( char *));
char *dbfserror();

DBFS *dbfsopen( char *filename);
DBFS *dbfscreate( char *filename);
void dbfsclose( DBFS *dbfs);

DBFILE *dbfilefind( DBFS *dbfs, char *filename);
DBFILE *dbfilecreate( DBFS *dbfs, char *filename);
int dbfileread( DBFILE *dbfile, BYTE *data);
int dbfilewrite( DBFILE *dbfile, BYTE *data, DWORD length);
int dbfiledelete( DBFILE *dbfile);

//---------------------------------------------------------------------------//
#ifdef __cplusplus
}
#endif
//#endif
