/* Copyright Stefan Hlln
 * May not be used without
 * the authors specific
 * authorization
 * el98shn@ing.umu.se       */

#include <windows.h>
#include <stdlib.h>
#include <math.h>

#include "isSynth.h"
#include "isController.h"
#include "isDelay.h"
#include "isChorus.h"

float **isBase::tempBuffer=NULL;

isSynth::isSynth()
{
	OutputDebugString("isSynth\n");

	bufferLength=1;
	if(isBase::tempBuffer==NULL)
	{
		isBase::tempBuffer=new float *[4];
	}
	for(int b=0;b<4;b++)
		tempBuffer[b]=NULL;
	
	for(b=0;b<3;b++)
		fxsend[b]=NULL;

	// set default volume and panning (center)
	for(int i=0;i<16;i++)
	{
		volume[i]=1.0f;
		panning[i]=0.5f;
		fx1Gain[i]=0.0f;
		fx2Gain[i]=0.0f;
		fx3Gain[i]=0.0f;
	}
	
	effectChain[0].SetEffect(is_DELAY,1);
	effectChain[0].SetEffect(is_CHORUS,0);

	effectChain[1].SetEffect(is_CHORUS,0);
	effectChain[2].SetEffect(is_DELAY,0);

	((isDelay *)effectChain[0].GetEffect(1))->dryMix=0.0f;
	((isDelay *)effectChain[0].GetEffect(1))->Update();
	
	((isDelay *)effectChain[2].GetEffect(0))->left.delay=64;
	((isDelay *)effectChain[2].GetEffect(0))->left.echoLength=64;
	((isDelay *)effectChain[2].GetEffect(0))->left.volume=0.5f;
	((isDelay *)effectChain[2].GetEffect(0))->left.feedback=0.5f;

	((isDelay *)effectChain[2].GetEffect(0))->right.delay=32;
	((isDelay *)effectChain[2].GetEffect(0))->right.echoLength=64;
	((isDelay *)effectChain[2].GetEffect(0))->right.volume=0.5f;
	((isDelay *)effectChain[2].GetEffect(0))->right.feedback=0.5f;

	((isDelay *)effectChain[2].GetEffect(0))->dryMix=0.0f;
	((isDelay *)effectChain[2].GetEffect(0))->Update();

	for(i=0;i<16;i++)
	instrument[i]=new isInstrument(samplePool);

	ccpu=0.0f;
}

isSynth::~isSynth()
{
	for(int b=0;b<4;b++)
		delete []tempBuffer[b];
		
	delete []fxsend[0];
	delete []fxsend[1];
	delete []fxsend[2];
}

void isSynth::Save(isFile *f)
{
	f->WriteInt('TNS+',4);
	int ins;

	// save samples
	samplePool.Save(f);
	// save each instrument
	for(ins=0;ins<16;ins++)
	{
		instrument[ins]->Save(f);
	}
	
	// save mixer settings for each instrument
	for(ins=0;ins<16;ins++)
	{
		f->WriteFloat(volume[ins]);
		f->WriteFloat(panning[ins]);

		f->WriteFloat(fx1Gain[ins]);
		f->WriteFloat(fx2Gain[ins]);
		f->WriteFloat(fx3Gain[ins]);
	}

	// save effect chains
	effectChain[0].Save(f);
	effectChain[1].Save(f);
	effectChain[2].Save(f);
	f->WriteInt('TNS-',4);
}

void isSynth::Load(isFile *f)
{
	f->ReadInt(4);
	int ins;
	// load samples
	samplePool.Load(f);
	// load each instrument
	for(ins=0;ins<16;ins++)
	{
		instrument[ins]->Load(f);
	}

	// load mixer settings for each instrument
	for(ins=0;ins<16;ins++)
	{
		volume[ins]=f->ReadFloat();
		panning[ins]=f->ReadFloat();

		fx1Gain[ins]=f->ReadFloat();
		fx2Gain[ins]=f->ReadFloat();
		fx3Gain[ins]=f->ReadFloat();
	}
	// load effect chains
	effectChain[0].Load(f);
	effectChain[1].Load(f);
	effectChain[2].Load(f);
	SetBufferSize(500);
	DWORD d='TNS-';
	if(d!=(unsigned)f->ReadInt(4))
	{
		MessageBox(NULL,"FUCK","FUCK",MB_OK);
	}
}

void isSynth::SetBufferSize( int length)
{
	if(bufferLength==length) return; // no change in bufferLength
	bufferLength=length;
	
	// they are all altered at the same moment, just check one, then work with them all
	if(tempBuffer[0]!=NULL) 
	{
		for(int b=0;b<4;b++)
			delete []tempBuffer[b];
	}
	for(int b=0;b<4;b++)
		tempBuffer[b]=new float[length];
	if(fxsend[0]!=NULL)
	{
		for(int b=0;b<3;b++)
			delete []fxsend[b];
	}
	for(b=0;b<3;b++)
		fxsend[b]=new float[length];
	
	// this is not for allocating buffers, just letting everything know the buffer length
	for(int i=0;i<16;i++)
		instrument[i]->SetBufferSize(length);
	
	effectChain[0].SetBufferSize(length);
	effectChain[1].SetBufferSize(length);
	effectChain[2].SetBufferSize(length);
}

void isSynth::GetSamples(float *left, float *right)
{
	/*
	// synthen r helt lst
	for(int a=0;a<bufferLength;a++)
		left[a]=right[a]=0.0f;
	return; */


	start=timer.getTime();

	int i,b;
	for(b=0;b<bufferLength;b++) // clear buffers before rendering instruments to them
		left[b]=right[b]=fxsend[0][b]=fxsend[1][b]=fxsend[2][b]=0.0f;
	for(i=0;i<8;i++)
	{
		if(!instrument[i]->IsActive()) continue; // if this instrument isn't play anything, skip to the next one.
		for(b=0;b<bufferLength;b++) // clear buffer before rendering instruments to it.
		{
			tempBuffer[3][b]=0.0f; 
		}

		instrument[i]->Play(tempBuffer[3]);
		
		// mix instrument to fxsends
		if(fx1Gain[i]!=0.0f) 
		{
			float mul=fx1Gain[i]*volume[i];
			for(b=0;b<bufferLength;b++)
			{
				fxsend[0][b]+=tempBuffer[3][b]*mul;
			}
		}
		if(fx2Gain[i]!=0.0f) 
		{
			float mul=fx2Gain[i]*volume[i];
			for(b=0;b<bufferLength;b++)
			{
				fxsend[1][b]+=tempBuffer[3][b]*mul;
			}
		}
		if(fx3Gain[i]!=0.0f) 
		{
			float mul=fx3Gain[i]*volume[i];
			for(b=0;b<bufferLength;b++)
			{
				fxsend[2][b]+=tempBuffer[3][b]*mul;
			}
		}
		
		// panning muls
		float leftMul,rightMul;
		leftMul=(1.0f-panning[i])*volume[i];
		rightMul=panning[i]*volume[i];
		for (b=0;b<bufferLength;b++)
		{
			left[b]+=tempBuffer[3][b]*leftMul;
			right[b]+=tempBuffer[3][b]*rightMul;
		}
	}
	
	// mix effect chains to main mix
	effectChain[0].Play(fxsend[0],fxsend[0],left,right);
	effectChain[1].Play(fxsend[1],fxsend[1],left,right);
	effectChain[2].Play(fxsend[2],fxsend[2],left,right);
		
	// clamp the synth output nicely
	float *l=left;
	float *r=right;
	for(b=0;b<bufferLength;b++)
	{
		// this takes 1% cpu
/*		*l=*l*(12**l**l + 144.0f) / (*l**l*(*l**l+60.0f) + 144.0f);
		*r=*r*(12**r**r + 144.0f) / (*r**r*(*r**r+60.0f) + 144.0f);*/

		// this takes 0.25% :)
		if(*l>1.0f) *l=1.0f;
		else if(*l<-1.0f) *l=-1.0f;
		if(*r>1.0f) *r=1.0f;
		else if(*r<-1.0f) *r=-1.0f;

		l++;
		r++;

	}

	end=timer.getTime();
	float time=(end-start);
	ccpu=time*100*44100.0f/bufferLength;

	return;
	
}

void isSynth::Event(int channel, isEVENT event)
{
	if(event.type==CONTROLLER)
		event.param2*=256;
	instrument[channel]->Event(event);
}