/* Copyright Stefan Hlln
 * May not be used without
 * the authors specific
 * authorization
 * el98shn@ing.umu.se       */

#include "isSamplePool.h"

#include <stdio.h>

isSamplePool::isSamplePool()
{
	for(int i=0;i<NR_OF_SAMPLES;i++)
	{
		sample[i].buffer=NULL;
		sample[i].loopStart=0;
		sample[i].loopEnd=0;
		sample[i].sampleLength=0;
		sample[i].pingpong=true;
		sample[i].loop=true;
		used[i]=false;
	}
/*	short *buffer;
	FILE *f=fopen("d:/tracker/cryonics.raw","rb");
	fseek(f,0,SEEK_END);
	int length=ftell(f)/2;
	buffer=new short[length];
	fseek(f,0,SEEK_SET);
	fread(buffer,2,length,f);
	fclose(f);
	Import(buffer,length,0);
	delete []buffer;*/
}

isSamplePool::~isSamplePool()
{

	for(int i=0;i<NR_OF_SAMPLES;i++)
	{
		if(sample[i].buffer)
		{
			delete []sample[i].buffer;
		}
	}
}

void isSamplePool::Load(isFile *f)
{
	unsigned char firstByte;

	for(int i=0;i<NR_OF_SAMPLES;i++)
	{
		firstByte=(unsigned char)f->ReadInt(1);
		used[i]=sample[i].loop=sample[i].pingpong=false;
		if(firstByte&0x01)
			used[i]=true;
		if(firstByte&0x02)
			sample[i].loop=true;		
		if(firstByte&0x04)
			sample[i].pingpong=true;

		if(used[i])
		{
			sample[i].sampleLength=f->ReadInt(3);
			if(sample[i].buffer)
				delete []sample[i].buffer;
			sample[i].buffer=new float[sample[i].sampleLength];

			for(int b=0;b<sample[i].sampleLength;b++)
				sample[i].buffer[b]=f->ReadInt(2)/32768.0f;
			
			sample[i].loopStart=f->ReadInt(3);
			sample[i].loopEnd=f->ReadInt(3);

		}
	}
}

void isSamplePool::Save(isFile *f)
{
	unsigned char firstByte;
	for(int i=0;i<NR_OF_SAMPLES;i++)
	{
		firstByte=0;
		if(used[i])
			firstByte|=0x01;
		if(sample[i].loop)
			firstByte|=0x02;
		if(sample[i].pingpong)
			firstByte|=0x04;
		f->WriteInt(firstByte,1);
		if(used[i])
		{
			f->WriteInt(sample[i].sampleLength,	3);
			for(int b=0;b<sample[i].sampleLength;b++)
				f->WriteInt((short)(sample[i].buffer[b]*32768.0f),2);

			f->WriteInt(sample[i].loopStart,3);
			f->WriteInt(sample[i].loopEnd,3);
				
		}
	}
}

void isSamplePool::Import(	short *buffer, unsigned int length, int toSampleNr )
{
	if(sample[toSampleNr].buffer!=NULL)
		delete []sample[toSampleNr].buffer;
	sample[toSampleNr].buffer=new float[length];

	for(unsigned int i=0;i<length;i++)
		sample[toSampleNr].buffer[i]=(buffer[i])/32768.0f;
	
	sample[toSampleNr].sampleLength=length;
	sample[toSampleNr].loopEnd=length;
	sample[toSampleNr].loopStart=length/2;

	used[toSampleNr]=true;
}