// SamplePoolEditor.cpp : implementation file
//

#include "stdafx.h"
#include "tracker.h"
#include "SamplePoolEditor.h"
#include "isSynth.h"
#include "isSamplePool.h"
#include "RawSampleView.h"
#include "trackerdoc.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSamplePoolEditor

IMPLEMENT_DYNCREATE(CSamplePoolEditor, CFormView)

CSamplePoolEditor::CSamplePoolEditor()
	: CFormView(CSamplePoolEditor::IDD)
{
	//{{AFX_DATA_INIT(CSamplePoolEditor)
	m_looping = FALSE;
	m_pingpong = FALSE;
	m_loopstart = 0;
	m_loopstop = 0;
	m_samplelength = _T("");
	//}}AFX_DATA_INIT

	m_synth = 0;
	m_sampleview = 0;

}

CSamplePoolEditor::~CSamplePoolEditor()
{
	delete m_sampleview;
}

void CSamplePoolEditor::DoDataExchange(CDataExchange* pDX)
{
	CFormView::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSamplePoolEditor)
	DDX_Control(pDX, IDC_BUTTON1, m_import);
	DDX_Control(pDX, IDC_LIST1, m_slotlist);
	DDX_Control(pDX, IDC_SPIN8, m_stopspin);
	DDX_Control(pDX, IDC_SPIN1, m_startspin);
	DDX_Check(pDX, IDC_CHECK2, m_looping);
	DDX_Check(pDX, IDC_CHECK3, m_pingpong);
	DDX_Text(pDX, IDC_EDIT2, m_loopstart);
	DDX_Text(pDX, IDC_EDIT3, m_loopstop);
	DDX_Text(pDX, IDC_EDIT4, m_samplelength);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSamplePoolEditor, CFormView)
	//{{AFX_MSG_MAP(CSamplePoolEditor)
	ON_LBN_SELCHANGE(IDC_LIST1, OnSelchangeList1)
	ON_EN_CHANGE(IDC_EDIT3, OnChangeEdit3)
	ON_EN_CHANGE(IDC_EDIT2, OnChangeEdit2)
	ON_BN_CLICKED(IDC_CHECK2, OnCheck2)
	ON_BN_CLICKED(IDC_CHECK3, OnCheck3)
	ON_BN_CLICKED(IDC_BUTTON1, OnButton1)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSamplePoolEditor diagnostics

#ifdef _DEBUG
void CSamplePoolEditor::AssertValid() const
{
	CFormView::AssertValid();
}

void CSamplePoolEditor::Dump(CDumpContext& dc) const
{
	CFormView::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CSamplePoolEditor message handlers

void CSamplePoolEditor::OnInitialUpdate() 
{
	CFormView::OnInitialUpdate();
	
	// TODO: Add your specialized code here and/or call the base class

	for (int i=0;i<32;i++) {
		_TCHAR tmp[1024];
		_stprintf(tmp,"%d",i);
		m_slotlist.AddString(tmp);
	}
	m_slotlist.SetCurSel(0);

	CTrackerDoc *doc = (CTrackerDoc*) GetDocument();	
	if (!doc) return;
	setSynth( doc->synth );


	RECT r;
	r.left = 330;
	r.top = 64;
	r.right = 700;
	r.bottom = 240;
	m_sampleview = new CRawSampleView();	 
	m_sampleview->Create( NULL, _T("AEWIND"), WS_VISIBLE | WS_TABSTOP, r, this, 0, 0 );

	m_startspin.SetRange( 0, 1000000 );	
	m_stopspin.SetRange( 0, 1000000 );		
	m_startspin.SetBuddy( GetDlgItem( IDC_EDIT2 ) );	
	m_stopspin.SetBuddy( GetDlgItem( IDC_EDIT3 ) );	

	newSlot(0);
}

void CSamplePoolEditor::OnSelchangeList1() 
{
	if (!m_synth)
		return;	
	// TODO: Add your control notification handler code here
	newSlot( m_slotlist.GetCurSel() );
}


void CSamplePoolEditor::setSynth(isSynth *synth)
{
	m_synth = synth;
	m_slotlist.SetCurSel(0);
	newSlot(0);
}

void CSamplePoolEditor::newSlot(int idx)
{	
	m_loopstart = m_synth->samplePool.sample[ idx ].loopStart;
	m_loopstop = m_synth->samplePool.sample[ idx ].loopEnd;
	m_looping = m_synth->samplePool.sample[ idx ].loop;
	m_pingpong = m_synth->samplePool.sample[ idx ].pingpong;	
	if (m_synth && m_sampleview)
		m_sampleview->setSample( &m_synth->samplePool.sample[ idx ] );

	m_samplelength.Format( _T("Sample length = %d"), m_synth->samplePool.sample[ idx ].sampleLength );

	UpdateData(FALSE);
	if (m_sampleview)
		m_sampleview->update();



	return;
}

void CSamplePoolEditor::updateStuff(void)
{	
	if (!UpdateData(TRUE))
		return;
	
	if (m_loopstart >= m_loopstop) {
		//MessageBox(  _T("Nu har du bakvnd loop\nSkall jag bertta fr farbror egon!"), _T("Du tror du kan baklngesloopa hur som helst!"), MB_OK);
		return;
	}

	if (!m_synth)
		return;

	int idx = m_slotlist.GetCurSel();
	if (!idx<0 || idx>=32)
		return;	

	m_synth->samplePool.sample[ idx ].loopStart = m_loopstart;
	m_synth->samplePool.sample[ idx ].loopEnd = m_loopstop;
	m_synth->samplePool.sample[ idx ].loop = m_looping;
	m_synth->samplePool.sample[ idx ].pingpong = m_pingpong;	
	
	if (m_sampleview) {
		m_sampleview->setSample( &m_synth->samplePool.sample[ idx ] );
		m_sampleview->update();
	}
}

void CSamplePoolEditor::OnChangeEdit3() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CFormView::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	updateStuff();
	
}

void CSamplePoolEditor::OnChangeEdit2() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CFormView::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	updateStuff();
}

void CSamplePoolEditor::OnCheck2() 
{
	// TODO: Add your control notification handler code here
	updateStuff();
}

void CSamplePoolEditor::OnCheck3() 
{
	// TODO: Add your control notification handler code here
	updateStuff();
	
}

void CSamplePoolEditor::OnButton1() 
{
	if (!m_synth)
		return;

	CTrackerDoc *doc = (CTrackerDoc*) GetDocument();	
	if (!doc) return;

	int idx = m_slotlist.GetCurSel();
	if (idx<0 || idx>=32) return;
	// TODO: Add your control notification handler code here
	CFileDialog fd(TRUE,_T("*.*"),0,0,_T("Raw files (*.*)|*.*|All files (*.*)|*.*||"),0);	
	if (fd.DoModal () == IDOK)
	{
		doc->pl->Pause();

		CString curFname = fd.GetPathName ();
		short *buffer;
		FILE *f=fopen( curFname,"rb");
		fseek(f,0,SEEK_END);
		int length=ftell(f)/2;
		buffer=new short[length];
		fseek(f,0,SEEK_SET);
		fread(buffer,2,length,f);
		fclose(f);
		m_synth->samplePool.Import(buffer,length,idx);
		delete []buffer;		

		m_slotlist.SetCurSel( idx );
		newSlot(idx);
		updateStuff();
		if (m_sampleview) {
			m_sampleview->setSample( &m_synth->samplePool.sample[ idx ] );
			m_sampleview->update();
		}		
		doc->pl->Resume();
	}
	
}
