// PropPageMidi.cpp : implementation file
//

#include "stdafx.h"
#include "tracker.h"
#include "PropPageMidi.h"
#include "instrEditor.h"
#include "MIDIInput.h"
#include "Globals.h"
#include "Configuration.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPropPageMidi property page

IMPLEMENT_DYNCREATE(CPropPageMidi, CPropertyPage)

CPropPageMidi::CPropPageMidi() : CPropertyPage(CPropPageMidi::IDD)
{
	//{{AFX_DATA_INIT(CPropPageMidi)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}

CPropPageMidi::~CPropPageMidi()
{
}

void CPropPageMidi::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPropPageMidi)
	DDX_Control(pDX, IDC_COMBO1, m_mididevice);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CPropPageMidi, CPropertyPage)
	//{{AFX_MSG_MAP(CPropPageMidi)
	ON_WM_HSCROLL()
	ON_CBN_SELCHANGE(IDC_COMBO1, OnSelchangeCombo1)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPropPageMidi message handlers

void CPropPageMidi::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	// TODO: Add your message handler code here and/or call default
	
	CPropertyPage::OnHScroll(nSBCode, nPos, pScrollBar);
}

BOOL CPropPageMidi::OnInitDialog() 
{
	CPropertyPage::OnInitDialog();
	

	// Slng in alla MIDI-devices i listan 
	m_mididevice.Clear();
	m_mididevice.InsertString( 0, _T("-- Disabled --") );

	UINT devCount = midiOutGetNumDevs();
	for (UINT i=0;i<devCount;i++) {
		MIDIINCAPS caps;
		if (MMSYSERR_NOERROR == midiInGetDevCaps( i, &caps, sizeof( MIDIINCAPS ) )) {
			m_mididevice.InsertString( i + 1, caps.szPname );						
		}			
	}

	m_mididevice.SetCurSel( g_midi_device );
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

BOOL CPropPageMidi::OnApply() 
{
	// TODO: Add your specialized code here and/or call the base class
	g_midi_device = m_mididevice.GetCurSel();
	g_midi_input->stop();

	if (g_midi_device)  {
		g_midi_input->start( g_midi_device - 1 );
		CONFIGURATION_SETDWORD( _T("MIDI"), _T("Device"), g_midi_device );
	}

	return CPropertyPage::OnApply();
}

void CPropPageMidi::OnSelchangeCombo1() 
{
	// TODO: Add your control notification handler code here
	SetModified(TRUE);
	
}
