// Just ps2.0 rendering path, not complete effect.
// See wings.fx

#ifdef ENABLE_PS20_PATH

static const half fGlossScale = 0.05;
static const half fGlossBias = 0.02;
static const half fIridescenseScale = 20.0;
static const half fIridescenseBias = 0.5;
static const half fTranslucency = 4.0;


SPosTexTanspLHV vsMain20( SPosTanspTex i ) {
	SPosTexTanspLHV o;
	o.pos = mul( i.pos, mWVP );
	gTangentLHV( (SPosTansp)i, mWorld, o.l, o.h, o.v );
	o.uv = i.uv;
	o.uv.x *= 2;
	return o;
}

half4 psMain20( SPosTexTanspLHV i ) : COLOR
{
	half4 col = tex2D( smpBase, i.uv );
	half3 n = tex2D( smpNormal, i.uv )*2-1;
	i.h = nrnorm( i.h );
	col.a *= fAlpha;

	half scatt = saturate( dot( -n, i.l ) ) * (1-col.a) * fTranslucency;
	half diff = saturate( dot( n, i.l ) ) + fLightAmbient;
	col.rgb *= scatt + diff;
	col.rgb *= col.a;

	half grad = dot( n, i.v ) * fIridescenseScale + fIridescenseBias;
	half3 irid = tex1D( smpGradient, grad );

	half gloss = 1.0 * ( saturate( dot( n, i.h ) ) * fGlossScale + fGlossBias );
	col.rgb += gloss * irid;

	return half4( col.rgb, col.a );
}


// Blur factor pass
#include "blur_11FFpath.fx"

technique tecPS20
< bool backToFront = true; >
{
	pass PBase {
		VertexShader = compile vs_1_1 vsMain20();
		PixelShader = compile ps_2_0 psMain20();
		ZWriteEnable = False;
		AlphaBlendEnable = True;
		SrcBlend = One;
		DestBlend = InvSrcAlpha;
	}
	pass PBlur {
		BLUR11_PASS
		AlphaBlendEnable = False;
	}
	pass PLast {
		BLUR_RESTORE
		ZWriteEnable = True;
	}
}

#endif
