// Just FFP rendering path, not complete effect.
// See water.fx


struct SWaterFF {
	float4 pos		: POSITION;
	float4 uv		: TEXCOORD0;
};

SWaterFF vsMainFFa( SPosTex i ) {
	SWaterFF o;
	o.pos = mul( i.pos, mWVP );
	o.uv = mul( i.pos, mWorldView );
	o.uv = mul( o.uv, mViewTexProj );
	return o;
}

// Blur factor pass
#include "blur_11FFpath.fx"


technique tecFFP {
	pass P0 {
		VertexShader = compile vs_1_1 vsMainFFa();
		PixelShader = NULL;
		AlphaBlendEnable = True;
		SrcBlend = One;
		DestBlend = InvSrcAlpha;
		
		TextureTransformFlags[0] = Projected;
		Sampler[0] = (smpRefl);
		TextureFactor = ( float4(0.6,0.6,0.6,0.7) );

		ColorOp[0] = Modulate;
		ColorArg1[0] = Texture;
		ColorArg2[0] = TFactor;
		AlphaOp[0] = SelectArg1;
		AlphaArg1[0] = TFactor;
		ColorOp[1] = Disable;
		AlphaOp[1] = Disable;
	}
	pass PBlur {
		BLURFF_PASS
		TextureTransformFlags[0] = Disable;
	}
	pass PLast {
		BLUR_RESTORE
		AlphaBlendEnable = False;
		Texture[0] = NULL;
		Texture[1] = NULL;
	}
}

