//
// Skybox - just plain textured.
//
// ps1.1, FFP
// 

#include "_lib.fx"

float4x4	mWVP;

texture		tBase;


SPosTex vsMain11( SPosTex i ) {
	SPosTex o;
	o.pos = mul( i.pos, mWVP );
	o.uv = i.uv;
	return o;
}

sampler2D smpBase = sampler_state {
	Texture = (tBase);
    MipFilter = Linear;	MinFilter = Linear; MagFilter = Linear;
    AddressU = Wrap; AddressV = Wrap;
};

#ifdef ENABLE_PS20_PATH

half4 psMain11( SPosTex i ) : COLOR
{
	half4 col = tex2D( smpBase, i.uv );
	return col;
}

technique tecPS11 {
	pass P0 {
		VertexShader = compile vs_1_1 vsMain11();
		PixelShader = compile ps_1_1 psMain11();
		ZWriteEnable = False;
	}
	pass PLast {
		ZWriteEnable = True;
	}
}

#endif


technique tecFFP {
	pass P0 {
		VertexShader = compile vs_1_1 vsMain11();
		PixelShader = NULL;
		ZWriteEnable = False;

		Sampler[0] = (smpBase);
		ColorOp[0] = SelectArg1;
		ColorArg1[0] = Texture;
		AlphaOp[0] = SelectArg1;
		AlphaArg1[0] = Texture;
		ColorOp[1] = Disable;
		AlphaOp[1] = Disable;
	}
	pass PLast {
		ZWriteEnable = True;
	}
}
