#ifndef __STRUCTS_FX
#define __STRUCTS_FX

// --------------------------------------------------------------------------
//  common structs


struct SPos {
	float4	pos		: POSITION;
};
struct SPosNormal {
	float4	pos		: POSITION;
	float3	normal	: NORMAL;
};
struct SPosNormalTex {
	float4	pos		: POSITION;
	float3	normal	: NORMAL;
	float2	uv		: TEXCOORD0;
};
struct SPosNormalTex2 {
	float4	pos		: POSITION;
	float3	normal	: NORMAL;
	float2	uv[2]	: TEXCOORD0;
};
struct SPosTex {
	float4 pos		: POSITION;
	float2 uv		: TEXCOORD0;
};
struct SPosTex2 {
	float4 pos		: POSITION;
	float2 uv[2]	: TEXCOORD0;
};
struct SPosTex3 {
	float4 pos		: POSITION;
	float2 uv[3]	: TEXCOORD0;
};
struct SPosTex4 {
	float4 pos		: POSITION;
	float2 uv[4]	: TEXCOORD0;
};
struct SPosColorTex {
	float4 pos		: POSITION;
	float4 color 	: COLOR;
	float2 uv		: TEXCOORD0;
};
struct SPosColor2Tex {
	float4 pos		: POSITION;
	float4 color[2]	: COLOR0;
	float2 uv		: TEXCOORD0;
};
struct SPosColorTex2 {
	float4 pos		: POSITION;
	float4 color	: COLOR;
	float2 uv[2]	: TEXCOORD0;
};
struct SPosTansp {
	float4 pos		: POSITION;
	float3 normal	: NORMAL;
	float3 tangent	: TANGENT;
	float3 binorm	: BINORMAL;
};
struct SPosTanspTex {
	float4 pos		: POSITION;
	float3 normal	: NORMAL;
	float3 tangent	: TANGENT;
	float3 binorm	: BINORMAL;
	float2 uv		: TEXCOORD0;
};
struct SPosTanspTex2 {
	float4 pos		: POSITION;
	float3 normal	: NORMAL;
	float3 tangent	: TANGENT;
	float3 binorm	: BINORMAL;
	float2 uv[2]	: TEXCOORD0;
};


struct SPosBlurc {
	float4	pos 	: POSITION;
	half4	blur	: COLOR0; // bluriness
};
struct SPosTexBlurc {
	float4	pos 	: POSITION;
	float2 	uv		: TEXCOORD0;
	half4	blur	: COLOR0; // bluriness
};
struct SPosTex4Blurc {
	float4	pos		: POSITION;
	float2 	uv[4]	: TEXCOORD0;
	half4	blur	: COLOR0; // bluriness
};
struct SPosTexTanspLHc {
	float4	pos		: POSITION;
	float2 	uv[2]	: TEXCOORD0;
	half3 	l		: COLOR0; // tangent space light
	half3 	h		: COLOR1; // tangent space half
};
struct SPosTexTanspLHBlurc {
	float4	pos		: POSITION;
	float2 	uv		: TEXCOORD0;
	half3 	l		: TEXCOORD1; // tangent space light
	half3 	h		: TEXCOORD2; // tangent space half
	half4	blur	: COLOR0; // bluriness
};
struct SPosTexTanspLHV {
	float4	pos		: POSITION;
	float2 	uv		: TEXCOORD0;
	half3 	l		: TEXCOORD1; // tangent space light
	half3 	h		: TEXCOORD2; // tangent space half
	half3	v		: TEXCOORD3; // tangent space view
};
struct SPosTex2TanspLHc {
	float4	pos		: POSITION;
	float2 	uv[3]	: TEXCOORD0;
	half3 	l		: COLOR0; // tangent space light
	half3 	h		: COLOR1; // tangent space half
};
struct SPosTex2TanspLHBlurc {
	float4	pos		: POSITION;
	float2 	uv[2]	: TEXCOORD0;
	half3 	l		: TEXCOORD2; // tangent space light
	half3 	h		: TEXCOORD3; // tangent space half
	half4	blur	: COLOR0; // bluriness
};
struct SPosTexWorldNV {
	float4	pos 	: POSITION;
	float2 	uv		: TEXCOORD0;
	half3 	n		: TEXCOORD1; // world space normal
	half3 	v		: TEXCOORD2; // world space view
};


#endif
