
#ifndef	_TEXT_H_
#define	_TEXT_H_


// Font structure used internally by TEXT

typedef struct {
	unsigned short		fontx;
	unsigned short		fonty;
	unsigned short		charhgt;
	unsigned short		fonthgt;	// used for CR, etc
	unsigned short		clut;
	unsigned short		tpage;
	unsigned char		u[128];
	unsigned char		v[128];
	unsigned char		w[128];
}	PSXFont;


// Font initialisation structure

typedef struct {
	int	fontnum;
	int	x,y;
	unsigned char *fontdata;
	int mode;						// 1=lower & upper case, 0=only single case
	int CRhgt;						// height of font for CR
	char *mapping;					// ASCII string to specify font ASCII map if required
	int transp;						// palette number for transparent color
}	PSXFontInit;



// Function Prototypes


#ifdef	__cplusplus
extern "C" {
#endif

void			Text_SetColor(unsigned long color);
void			Text_SetColor2(unsigned long color);

void			Text_SetupFont(PSXFontInit *ini);
void			Text_SetFont(int fontnum);
int				Text_GetFontHgt(void);
int				Text_GetCharHgt(void);
int				Text_GetCharWid(char c);
void			Text_InitText(long *ot);
void			Text_SetCursor(int x, int y);
void			Text_PrtMsg(int x, int y, char *msg, int prop, int transp);
int				Text_GetXPos(void);
int				Text_GetYPos(void);
void			Text_AddChar(char c);
int				Text_GetTextWidth(char *str);

int				strcmpi(char *, char *);
void			prints(char *string,...);
void			_format(char *out,char *string, ...);

int				fgets(char *out,int maxlen,char **in);

#ifdef	__cplusplus
}
#endif

#endif	//_TEXT_H_

