
#include "headers.h"


////////////////////////////////////////////////////////////////////////////////
// TEXT System
////////////////////////////////////////////////////////////////////////////////

#define		CHAR_SPACER		1		// slight bodge - # pixels between chars!!

#define		MAXPRIMS	256*8

unsigned long	*TH_primsptr;
unsigned long	TH_prims[(sizeof(POLY_FT4)/4)*MAXPRIMS];
unsigned long	TH_prims2[(sizeof(POLY_FT4)/4)*MAXPRIMS];

unsigned long	*TH_ot;

int 			TH_numprims;

int				CurFont=0;
PSXFont			PSFonts[4];

unsigned long	FGcolr;
unsigned long	FGcolr2;

// texthandler's cursor coordinates
int				TH_xpos;
int				TH_ypos;
int				TH_LMargin;
int				TH_hres=512;
int				TH_vres=256;
// other flags
int				TH_prop=0;
int				TH_transp=1;
short			TH_clutID,TH_tpageID;



////////////////////////////////////////////////////////////////////////////////
// Check X-pos for double-notch in font image
////////////////////////////////////////////////////////////////////////////////

int	IsEnd(unsigned char *data, int u)
{
	unsigned char byte;
	byte=*(data+0x100+u/2);
	if	((u&0x01))
		byte=(byte>>4)&0x0f;
	else
		byte=byte&0x0f;
	return((byte==1)?1:0);
}


////////////////////////////////////////////////////////////////////////////////
// Check X-pos for notch in font image
////////////////////////////////////////////////////////////////////////////////

int	IsNotch(unsigned char *data, int u)
{
	unsigned char byte;
	byte=*(data+0x80+u/2);
	if	((u&0x01))
		byte=(byte>>4)&0x0f;
	else
		byte=byte&0x0f;
	return((byte==1)?1:0);
}


////////////////////////////////////////////////////////////////////////////////
// Find a notch in the font image
////////////////////////////////////////////////////////////////////////////////

int FindNotch(unsigned char *data, int u)
{
	while	( !IsNotch(data,u) )
		u++;
	return(u);
}


////////////////////////////////////////////////////////////////////////////////
// Remove notches from font image
////////////////////////////////////////////////////////////////////////////////

void RemoveNotches(unsigned char *data, int hgt, int charhgt,int transp)
{
	int	i;
	unsigned char byte;

	while	(hgt>0)
		{
		for	(i=0;i<128;i++)
			{
			byte=*data;
			if	((byte&0xf0)==0x10)	byte=(byte&0x0f)|(transp<<4);
			if	((byte&0x0f)==0x01)	byte=(byte&0xf0)|transp;
			*data++=byte;
			}
		data+=(128*(charhgt-1));
		hgt-=charhgt;
		}
}


////////////////////////////////////////////////////////////////////////////////
// Set Font Color 1
////////////////////////////////////////////////////////////////////////////////

void Text_SetColor(unsigned long color)
{
	FGcolr=color;
}

////////////////////////////////////////////////////////////////////////////////
// Set Font Color 2
////////////////////////////////////////////////////////////////////////////////

void Text_SetColor2(unsigned long color)
{
	FGcolr2=color;
}


////////////////////////////////////////////////////////////////////////////////
// Setup a Font
////////////////////////////////////////////////////////////////////////////////

void Text_SetupFont(PSXFontInit *ini)
{
	int fontnum;
	int x;
	int y;
	unsigned char *fontdata;
	int mode;
	int CRhgt;
	char *mapping;
	int transp;

	RECT	rect;
	unsigned long *tim;
	int		i,wid,hgt,u,v,newu;
	unsigned char *data,*work,byte;

	unsigned short *pal;

	fontnum=ini->fontnum;
	x=ini->x;
	y=ini->y;
	fontdata=ini->fontdata;
	mode=ini->mode;
	CRhgt=ini->CRhgt;
	mapping=ini->mapping;
	transp=ini->transp;

	tim=(unsigned long *)fontdata;
	wid=((*(tim+15))&0xffff)*4;
	hgt=(*(tim+15)>>16)&0xffff;

	PSFonts[fontnum].fontx=x;
	PSFonts[fontnum].fonty=y;
	PSFonts[fontnum].fonthgt=CRhgt;

	for	(i=0;i<128;i++)
		{
		PSFonts[fontnum].u[i]=0;
		PSFonts[fontnum].v[i]=0;
		PSFonts[fontnum].w[i]=1;
		}

	PSFonts[fontnum].w[0]=16;	//space defaults to 16

	data=fontdata+64+0x80;

	while	(((*data)&0xf0)!=0x10)
		data+=0x80;
	PSFonts[fontnum].charhgt=(data-(fontdata+64))/0x80;

	data=fontdata+64;
	work=data;
	u=0;
	v=0;

if	(mapping)
	{
	char	map;
	while(*mapping)
		{
		map=(*mapping++)-32;
		PSFonts[fontnum].u[map]=u;
		PSFonts[fontnum].v[map]=v;
		newu=FindNotch(work,u);
		PSFonts[fontnum].w[map]=newu-u;
		u=newu;
		if	(IsEnd(work,u))
			{
			u=0;
			data+=0x80*PSFonts[fontnum].charhgt;
			work=data;
			v+=PSFonts[fontnum].charhgt;
			}
		else
			{
			u++;	// skip trailing notch
			}
		}

	if	(mode==0)
		{
		for	(i='a'-32;i<='z'-32;i++)
			{
			PSFonts[fontnum].u[i]=PSFonts[fontnum].u[i-32];
			PSFonts[fontnum].v[i]=PSFonts[fontnum].v[i-32];
			PSFonts[fontnum].w[i]=PSFonts[fontnum].w[i-32];
			}

		}
	}
else
	{
	for	(i=0;i<='~'-32;i++)
		{
		if	( (!mode) && (i>='a'-32) && (i<='z'-32) )
			{
			PSFonts[fontnum].u[i]=PSFonts[fontnum].u[i-32];
			PSFonts[fontnum].v[i]=PSFonts[fontnum].v[i-32];
			PSFonts[fontnum].w[i]=PSFonts[fontnum].w[i-32];
			if	(i=='z'-32)
				{
				newu=FindNotch(work,u);
				u=newu;
				u++;
				}
			}
		else
			{
			PSFonts[fontnum].u[i]=u;
			PSFonts[fontnum].v[i]=v;
			newu=FindNotch(work,u);
			PSFonts[fontnum].w[i]=newu-u;
			u=newu;
			if	(IsEnd(work,u))
				{
				u=0;
				data+=0x80*PSFonts[fontnum].charhgt;
				work=data;
				v+=PSFonts[fontnum].charhgt;
				}
			else
				{
				u++;	// skip trailing notch
				}
			}
		}
	}


	RemoveNotches(fontdata+64,hgt,PSFonts[fontnum].charhgt,(transp==-1)?0:transp);

	EnterCriticalSection();
	pal=(unsigned short *)fontdata+((8+12)/2);

	if	(transp!=-1)
		{
		*(pal+transp)=0x8000;
		}

//	PSFonts[fontnum].clut=LoadClut((unsigned long *)fontdata+(8+12)/4, x, y+hgt);	// shove CLUT right below image
	PSFonts[fontnum].clut=LoadClut2((unsigned long *)fontdata+(8+12)/4, x, y+hgt);	// shove CLUT right below image
	PSFonts[fontnum].tpage=LoadTPage((unsigned long *)fontdata+16, 0, 2, x, y, wid, hgt);
	DrawSync(0);
	ExitCriticalSection();

	CurFont=fontnum;
	FGcolr=FGcolr2=0x808080;
}


////////////////////////////////////////////////////////////////////////////////
// Set Current Font
////////////////////////////////////////////////////////////////////////////////

void Text_SetFont(int fontnum)
{
	CurFont=fontnum;
}

////////////////////////////////////////////////////////////////////////////////
// Get Font height (as used for CR)
////////////////////////////////////////////////////////////////////////////////

int Text_GetFontHgt(void)
{
	return(PSFonts[CurFont].fonthgt);
}

////////////////////////////////////////////////////////////////////////////////
// Get Font height (actual height)
////////////////////////////////////////////////////////////////////////////////

int Text_GetCharHgt(void)
{
	return(PSFonts[CurFont].charhgt);
}

////////////////////////////////////////////////////////////////////////////////
// Get character width
////////////////////////////////////////////////////////////////////////////////

int Text_GetCharWid(char c)
{
	return(PSFonts[CurFont].w[c-32]+CHAR_SPACER);
}


////////////////////////////////////////////////////////////////////////////////
// Set Cursor X,Y
////////////////////////////////////////////////////////////////////////////////

void Text_SetCursor(int x, int y)
{
	TH_LMargin = \
	TH_xpos = x;
	TH_ypos = y;
}

////////////////////////////////////////////////////////////////////////////////
// Init Text handler - call every game cycle
////////////////////////////////////////////////////////////////////////////////

void Text_InitText(long *ot)
{
	TH_primsptr=(Main_Cycles&1)?&TH_prims[0]:&TH_prims2[0];
	TH_numprims=0;
	TH_ot=ot;
}

////////////////////////////////////////////////////////////////////////////////
// Print a string
////////////////////////////////////////////////////////////////////////////////

void Text_PrtMsg(int x, int y, char *msg, int prop, int transp)
{
	TH_prop=prop;
	TH_transp=transp;
	TH_xpos = x;
	TH_ypos = y;
	while (*msg!=0)
		Text_AddChar(*msg++);
}

////////////////////////////////////////////////////////////////////////////////
// Get current cursor X-pos
////////////////////////////////////////////////////////////////////////////////

int	Text_GetXPos(void)
{
	return(TH_xpos);
}

////////////////////////////////////////////////////////////////////////////////
// Get current cursor Y-pos
////////////////////////////////////////////////////////////////////////////////

int	Text_GetYPos(void)
{
	return(TH_ypos);
}


////////////////////////////////////////////////////////////////////////////////
// Add a character to the primitive list
////////////////////////////////////////////////////////////////////////////////

void Text_AddChar(char c)
{
	u_short		cwidth, cindent;

	POLY_FT4	*ft4;
	SPRT		*sp;
	POLY_GT4	*gt4;

	int			u0,u1,v0,v1;

	unsigned char *rgb;

//	if	( (TH_xpos<-16) || (TH_xpos>320) || (TH_ypos<-16) || (TH_ypos>256) )	return;
//	if	( (TH_xpos<0) || (TH_xpos>TH_hres) || (TH_ypos<0) || (TH_ypos>TH_vres) )	return;

	if	(c=='\n')
		{
		TH_xpos=TH_LMargin;
		TH_ypos+=PSFonts[CurFont].fonthgt;
		return;
		}

	if	( (c<32) || (c>'~') ) c='?';
	c -= 32;
	cwidth = PSFonts[CurFont].w[(unsigned int)c];

	if	(c==0)								// special case for space - why waste an FT4 on blank crap?!
		{
		TH_xpos += cwidth+CHAR_SPACER;
		return;
		}

	u0=PSFonts[CurFont].u[(unsigned int)c];
	v0=(PSFonts[CurFont].fonty%256)+PSFonts[CurFont].v[(unsigned int)c];

	u1=u0+cwidth+0;
	v1=v0+PSFonts[CurFont].charhgt;

	if	(TH_numprims<MAXPRIMS)
		{
		TH_numprims++;
	if	(FGcolr&0xff000000)
		{
//gouraud
		gt4=(POLY_GT4 *)TH_primsptr;
		SetPolyGT4(gt4);
		SetSemiTrans(gt4, TH_transp);
		SetShadeTex(gt4, 0);
		gt4->x0=\
		gt4->x2=TH_xpos+0;
		gt4->y0=\
		gt4->y1=(TH_ypos);// /2);
		gt4->x1=\
		gt4->x3=gt4->x0+cwidth+0;
		gt4->y2=\
		gt4->y3=gt4->y0+PSFonts[CurFont].charhgt;
		gt4->u0=u0;
		gt4->v0=v0;
		gt4->u1=u1;
		gt4->v1=v0;
		gt4->u2=u0;
		gt4->v2=v1;
		gt4->u3=u1;
		gt4->v3=v1;
		gt4->tpage=PSFonts[CurFont].tpage;
		gt4->clut=PSFonts[CurFont].clut;
		gt4->r1=gt4->r0=(FGcolr>>16)&0xff;
		gt4->g1=gt4->g0=(FGcolr>>8)&0xff;
		gt4->b1=gt4->b0=(FGcolr)&0xff;
		gt4->r3=gt4->r2=(FGcolr2>>16)&0xff;
		gt4->g3=gt4->g2=(FGcolr2>>8)&0xff;
		gt4->b3=gt4->b2=(FGcolr2)&0xff;
		AddPrim(&TH_ot[0], gt4);
		TH_primsptr+=sizeof(POLY_GT4)/4;
		}
	else
		{
//standard
		ft4=(POLY_FT4 *)TH_primsptr;
		SetPolyFT4(ft4);
		SetSemiTrans(ft4, TH_transp);
		SetShadeTex(ft4, 0);
		ft4->x0=\
		ft4->x2=TH_xpos+0;
		ft4->y0=\
		ft4->y1=(TH_ypos);// /2);
		ft4->x1=\
		ft4->x3=ft4->x0+cwidth+0;
		ft4->y2=\
		ft4->y3=ft4->y0+PSFonts[CurFont].charhgt;
		ft4->u0=u0;
		ft4->v0=v0;
		ft4->u1=u1;
		ft4->v1=v0;
		ft4->u2=u0;
		ft4->v2=v1;
		ft4->u3=u1;
		ft4->v3=v1;
		ft4->tpage=PSFonts[CurFont].tpage;
		ft4->clut=PSFonts[CurFont].clut;
		ft4->r0=(FGcolr>>16)&0xff;
		ft4->g0=(FGcolr>>8)&0xff;
		ft4->b0=(FGcolr)&0xff;
		AddPrim(&TH_ot[0], ft4);
		TH_primsptr+=sizeof(POLY_FT4)/4;
		}

		}
	else
		{
		}

	TH_xpos += cwidth+CHAR_SPACER;
}


////////////////////////////////////////////////////////////////////////////////
// Get width of a string
////////////////////////////////////////////////////////////////////////////////

int Text_GetTextWidth(char *str)
{
	u_short		cwidth;
	char		c;
	int			ret;

	ret=0;

	while(c=*str++)
		{
		if	( (c<32) || (c>'~') ) c='?';
		c -= 32;
		cwidth = PSFonts[CurFont].w[(unsigned int)c];
		ret+=cwidth+CHAR_SPACER;
		}
	return(ret);
}


////////////////////////////////////////////////////////////////////////////////
// Case-insensitive STRCMP
////////////////////////////////////////////////////////////////////////////////

int strcmpi(char *src, char *dest)
{
	char src2[256];
	char dest2[256];
	int	i;

	strcpy(src2, src);
	strcpy(dest2, dest);

	i=0;
	while	(src2[i]!=0)
		{
		if	((src2[i]>='a')&&(src2[i]<='z'))
			src2[i]-=32;
		i++;
		}
	i=0;
	while	(dest2[i]!=0)
		{
		if	((dest2[i]>='a')&&(dest2[i]<='z'))
			dest2[i]-=32;
		i++;
		}

	return(strcmp(src2, dest2));
}


////////////////////////////////////////////////////////////////////////////////
// Format & Print string to display
////////////////////////////////////////////////////////////////////////////////

void prints(char *string, ...)
{
	char	msgbuf[2048];
	char	*msg;
	char	c;
	char	fmt[16];

	int		i;

	int		val_i;
	char	*val_s;
	char	val_c;

    va_list vl;

    va_start( vl, string );

	msg=(char *)&msgbuf[0];

	while(*string)
		{
		c=*string++;
		if	(c=='%')
			{
			if	(*string=='%')
				{ *msg++='%'; string++; }
			else
				{
// make fmt string now
				i=0;
				fmt[i++]='%';
				if	(isdigit(*string))
					{
// specifying length, eg %4d
					while(isdigit(*string))	{fmt[i++]=*string++;}
					}

				fmt[i++]=c=*string++;	// now get letter
				fmt[i]=0;

				switch(c)
					{
					case 'd':
						val_i = va_arg( vl, int );
						msg+=sprintf2(msg,&fmt[0],val_i);
						break;
					case 'x':
						val_i = va_arg( vl, int );
						msg+=sprintf2(msg,&fmt[0],val_i);
						break;
					case 's':
						val_s = va_arg( vl, char * );
						msg+=sprintf2(msg,&fmt[0],val_s);
						break;
					case 'c':
						val_c = va_arg( vl, char );
						msg+=sprintf2(msg,&fmt[0],val_c);
						break;
					default:
						i=0;
						while(fmt[i])	*msg++=fmt[i++];
						break;
					}
				}
			}
		else
			*msg++=c;
		}

	va_end(vl);

	*msg=0;

	Text_PrtMsg(TH_xpos, TH_ypos, &msgbuf[0], TH_prop, TH_transp);
}




////////////////////////////////////////////////////////////////////////////////
// Emulation of fgets() function
////////////////////////////////////////////////////////////////////////////////

int fgets(char *out,int maxlen,char **in)
{
	char *s,c;
	int	count;

	s=*in;

	count=0;

	while(maxlen--)
		{
		c=*s++;
		if	(c==0)
			{
			if (!count)
				{
				*in=s;
				return(0);
				}
			else
				{
				*in=--s;
				*out=0;
				return(count);
				}
			}

		if	((c==0x0d)||(c==0x0a))
			{
			while ((*s==0x0d)||(*s==0x0a))	s++;
			*in=s;
			*out=0;
			if	(!count)	return(1);
			else			return(count);
			}

		*out++=c;
		count++;

		}
}





