; XORgularity by bitl/7dump (2022)
; this is my first 256b-intro,
; so you can see a lot of silly things in this code ;)
; Enjoy!
; P.S.: this code for TASM (MS-DOS)!
; For compilation: "tasm xorgular.asm",  "tlink /t xorgular.obj")

.model tiny
.data
  X  DW 0
  Y  DW 0
  C1 DW 0
  C2 DW 0
  N  DW 0
  S  DW 80

.code
.386

org 0100h

start:
    mov al, 13h

    add dh, al
    ;mov fs, dx    ;use segment cs+1300h for framebuffer


;------>set pallete (ripped from 256b-intro Pyrit by Rrrola)<-----
P:
  shr cl,3     ; B@cl = 0..8..31,31..0
  int 10h      ; set video mode / color: bx=index dh=R ch=G cl=B
  movsx cx,bl  ; 0..127,128..255 (palette index)
  xor ch,cl    ; 0..127,127..0
  mov cl,ch
  mov ax,cx
  mul ax       ; R@dh = 0..16..63,63..16..0
  shr cx,1     ; G@ch = 0..63,63..0
  inc bl       ; keep default color 0
  js Q         ; R@dh = 0..63,63..16..0
  ;xchg cl,dh   ; B@cl = 0..16..63,63..0
Q:
  mov ax,1010h
  jnz P        ;bx=0 cx=0
;-------------------------------------

    push 0a000h
    pop es


@mainloop:

     inc N  ; incremental variable for moving


;---------------> Main render part <------------------
    cld
    ;xor si, si  ;if with framebuffer
    xor di, di   ;if without
    xor bx, bx
    mov cx, 64000
    mov Y, bx
    finit

    fild S            ; Speed & radius
    fild N            ; incremental var

                      ; calls trajectory for move radial-gradients textures

    fdiv st, st(1)
    fsin
    fmul st, st(1)
    fadd st, st(1)
    fadd st, st(1)

    fld st

    fdiv st, st(2)
    fcos
    fsin
    fmul st, st(2)
    fadd st, st(2)


    fild N
    fadd st, st(3)
    fdiv st, st(3)
    fsin
    fmul st, st(3)
    fadd st, st(3)
    fadd st, st(3)

    fld st

    fdiv st, st(4)
    fsin
    fmul st, st(4)
    fadd st, st(4)

    ;ok, X1,Y1, X2,Y2 coords of centers two radial gradient in FPU stack! :)

@renderloop:


  mov dl,2
  @innerloop:          ; two cicles for 1 and 2 radial gradient

                        ;c=Xc*log2((Y-Yc)*(Y-Yc)+(X-Xc)*(X-Xc)))

    fild Y              ;pixel Y-coord

    fsub st,st(1)
    fmul st,st

    fild X              ;pixel X-coord

    fsub st, st(3)
    fmul st,st

    faddp st(1),st

    fld st(2)

    fxch st(1)
    FYL2X

    cmp dl, 2
    je @C1

    fistp C2
    jmp @next

  @C1:
    fistp C1

  @next:             
    fxch st(4)      ;swap stored coordinates of center for calls 2th radial gradients
    fstp st
    fxch st(4)
    fstp st

    dec dl
  jnz @innerloop


@continue:
    mov al, byte ptr C1
    mov ah, byte ptr C2
    xor al,ah
    ; mov fs:[si],al   ;draw pixel to frame-buffer
    mov es:[di], al
    ;inc si ;if frame-buffer used
    inc di  ;if without frame-buffer
    inc bx
    mov X, bx
    cmp bx, 320
    je @incY
  loop @renderloop

jmp @nextframe

@incY:
    inc Y
    xor bx, bx
    mov X, bx
jmp @renderloop

@nextframe:
;----------------------------------------


;wait for vertical retrace
     mov  dx, 3DAh
@w1:
     in   al, dx
     test al, 8
     jnz  @w1
@w2:
     in   al, dx
     test al, 8
     jz   @w2



;copy buffer to screen (if we use frame-buffer)
;xor di, di
;xor si, si
;mov cx, 16000
;@copybuffer:
;      mov eax, fs:[si]
;      add si, 4
;      stosd
;loop @copybuffer


  in al, 60h              ; wait for ESC
  cbw
  dec ax
  jnz @mainloop            ; none received, start over


  ;EXIT
  mov ax, 3               ; back to text
  int 10h                 ; mode
  int 20h                 ; exit


end start
