// JPEG decoding example for SEGA Saturn
// Mic, 2009

#include <stdio.h>
#include <stdlib.h>
#include "vdp.h"
#include "djpegsat.h"


extern char image, image_end;

char scanlineBuffer[320*3];


int main()
{
	MPOFN = 0;
	SCYDN0 = 0;
	SCYIN0 = 0;
	SCXDN0 = 0;
	SCXIN0 = 0;
	CHCTLA = 0x32;		// 15-bit mode for NBG0
	BGON = 0x101;
	TVMD = 0x8010;		// Screen on, 320x240 pixels

	read_JPEG_init();

    for(;;)
    {
        wait_vblank_out();
        wait_vblank_in();

		read_JPEG_file(&image,					// Pointer to the JPEG data
		              (&image_end)-(&image),	// Size of JPEG data
		              (vu16*)VDP2_VRAM,			// Destination pointer
		              (vu16*)scanlineBuffer,	// Scanline buffer used for holding the the 24-bit RGB triplets for each pixel
		              512*2);					// Width of NBG0 * sizeof(one pixel)

     }

	read_JPEG_deinit();

	return 0;
}


