/*
GBCDEMO.C
Written by Jason
Quick, simple demonstration of how to write a multiple colored background image
using GBDK and pcx2gb

I used
pcx2gb o d 1.pcx 1.dat 1.map

Notes for idiots
----------------
A few quick things I know most people aren't smart enough to figure out.

1) pcx2gb has a small problem with the map file. Once you use it, you must open up
your map file and put commas at the end of each line.
2) the make.bat is set up like that for a reason. Despite it being written near eveywhere,
you must have byte 0x143 set to 0x80 or the gameboy won't be in color mode.
3) colors.h must be downloaded from http://www.gbdev.org/news/ and put in the include
directory. For those who still don't get it, d:\sdk\gbz80-gb\2-1-0\include\
4) the tiledata is defined in 1.dat
5) the tilemap is defined in 1.map
6) Read GBDoK written by Manfred Lizner and Jason.
7) Yes, you have to hand color your image. No, there is no pcx2gbc. The result is blocky
unless you have a nice image to base off of. Mine wasn't so lucky.
*/

// gameboy header file
#include <gb.h>

// color data. download this from www.gbdev.org/news/
#include <colors.h>

// picture data
#include "1.dat"
#include "1.map"

// colors to use for the background
UWORD picpalette[] = {
white,lightflesh,blue,black,
red,red,darkred,black,
black,black,black,black,
};

// color map. this picks which colors to use with the picture
unsigned char cgbmap[] = {
1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,
1,1,1,1,1,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,
1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,
1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,
1,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,
1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
2,2,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
2,2,2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,2,2,0,0,
2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,2,2,2,0,0,
2,2,2,2,2,2,0,0,0,0,0,0,0,0,2,2,2,2,2,0,
2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
};


// if you don't know this, don't use C
main()
{

	// set the lcd's palette
	set_bkg_palette( 0, 3, &picpalette[0] ); 

	// set the background characters
	set_bkg_data(0,250,tiledata); 

	// set the video bank register to 1, the tile color data
	VBK_REG = 1; 

	// set the color data
	set_bkg_tiles( 0, 0, 20, 18, cgbmap); 

	// set the video bank back to the visible tile data
	VBK_REG = 0; 

	// Set the background tiles to those loaded into the VRAM. 
	// You loaded the tiles from the set_bkg_data above
	set_bkg_tiles( 0, 0, 20, 15, tilemap); 

	// Show the background
	SHOW_BKG; 

	// Turn the display on
	DISPLAY_ON; 

	// return 0
	return(0);	
}
