;----------------------------------------------------------------------------;
; Get the command line and make the analysis of it (for sound card)...       ;
;----------------------------------------------------------------------------;


; These procedures need AFFICHE.INC to run




; Strings & variables
;---------------------

Device1     db  'SoundPlayer/Covox at LPT1 (mono)',13,10,'$'
Device2     db  'SoundPlayer/Covox at LPT2 (mono)',13,10,'$'
Device3     db  'Sound Blaster compatible (mono)',13,10,'$'
Device4     db  'Internal Shitty Speaker (mono)',13,10,'$'
Device5     db  'Two Sound Players LPT1+2 (Stereo)',13,10,'$'
Device6     db  'Sound Blaster Pro (stereo)',13,10,'$'
Device7     db  'Stereo SoundPlayer in LPT1 (stereo)',13,10,'$'
Device8     db  'Stereo SoundPlayer in LPT2 (stereo)',13,10,'$'

WrongCmd    db  13,10,'bad command line...',13,10,'$'
NoCmdLine   db  13,10,'No command line',13,10,'$'
ComandLine  db  13,10,'User parameters:',13,10,'$'
CmdPortS    db  '       at ','$'
CmdIRQS     db  'h, IRQ','$'
CmdDMAs     db  '& DMA','$'
CRLF        db  13,10,'$'

CommandLine db  127 dup (0)
IsCmdLine   db  0
	
Cmdport     dw  220h
CmdIRQ      dw  7h
CmdDMA      dw  1h
Cmddevice   dw  ?


; Procedures...
;---------------

GetCmdLine  proc near           ; Search for a command line, Set carry if none
	push    bx
	push    di
	clc                         ; clear carry
	mov     di,offset cs:[CommandLine]
	mov     bx,82h
	mov     al,es:[bx-2]
	cmp     al,0
	jne     TestNext
	jmp     @NoCmdLine
TestNext:
	mov     al,es:[bx]
	cmp     al,0
	jne     GetIt
	jmp     @NoCmdLine
GetIt:
	mov     al,es:[bx]
	inc     bx
	mov     cs:[di],al
	inc     di
	cmp     al,0Dh
	je      GotIt
	jmp     GetIt
GotIt:
	mov     cs:[di],10      ; there's already #13, add #10 and '$'...
	inc     di
	mov     cs:[di],'$'
EndMoveName:
	clc
	mov     IsCmdLine,1
	pop     di
	pop     bx
	ret
@NoCmdLine:
	mov     IsCmdLine,0
	pop     di
	pop     bx
	stc                 ; No command line -> set carry
	ret
GetCmdLine  Endp




GetCmdParam proc near
	mov     di,offset cs:[commandLine]
	xor     bx,bx
@@SetUpperCChar:
	mov     al,cs:[di+bx]
	cmp     al,'p'
	jne     tryIChar
	mov     al,'P'
	mov     cs:[di+bx],al
TryIchar:
	mov     al,cs:[di+bx]
	cmp     al,'i'
	jne     tryDchar
	mov     al,'I'
	mov     cs:[di+bx],al
TryDchar:
	mov     al,cs:[di+bx]
	cmp     al,'d'
	jne     tryTchar
	mov     al,'D'
	mov     cs:[di+bx],al
TryTChar:
	mov     al,cs:[di+bx]
	cmp     al,'t'
	jne     SkipTchar
	mov     al,'T'
	mov     cs:[di+bx],al
SkipTChar:
	cmp     cs:[di+bx],0Dh
	je      EndUpperCChar
	inc     bx
	jmp     @@SetUpperCChar
EndUpperCChar:

	mov     di,offset cs:[commandLine]
	xor     bx,bx
@@GetTheParam:
	mov     al,cs:[di+bx]
	cmp     al,'/'
	je      TryForIRQ
	cmp     al,0Dh
	je      EndGetCmdParam
	inc     bx
	jmp     short @@GetTheParam
TryForIRQ:
	inc     bx
	mov     al,cs:[di+bx]
	cmp     al,'I'
	jne     TryForDMA
	inc     bx
	mov     al,cs:[di+bx]
	cmp     al,48
	jb      ErrorCmdLine
	cmp     al,57
	ja      errorCmdLine
	xor     ah,ah
	sub     ax,48
	mov     CMDIrq,ax

	mov     dl,cs:[di+bx+1]
	cmp     dl,48
	jb      TryForDMA
	cmp     dl,57
	ja      TryForDMA
	xor     dh,dh
	sub     dx,48
	add     dx,10
	cmp     CMDIrq,1
	ja      ErrorCmdLine
	mov     CMDIrq,dx
	jmp     OtherParam
TryForDMA:
	cmp     al,'D'
	jne     TryForDevice
	inc     bx
	mov     al,cs:[di+bx]
	cmp     al,48
	jb      ErrorCmdLine
	cmp     al,57
	ja      errorCmdLine
	xor     ah,ah
	sub     ax,48
	mov     CMDdma,ax
	jmp     OtherParam
TryForDevice:
	cmp     al,'T'
	jne     TryForPort
	inc     bx
	mov     al,cs:[di+bx]
	cmp     al,49         ; no device 0 !
	jb      ErrorCmdLine
	cmp     al,56         ; only 8 devices !
	ja      errorCmdLine
	xor     ah,ah
	sub     ax,48
	mov     CMDDevice,ax
	jmp     OtherParam
TryForPort:
	cmp     al,'P'
	jne     OtherParam
	inc     bx
	mov     al,cs:[di+bx]
	cmp     al,48
	jb      ErrorCmdLine
	cmp     al,57
	ja      errorCmdLine
	xor     ah,ah
	sub     ax,48
	mov     ah,al
	mov     dl,cs:[di+bx+1]
	cmp     dl,48
	jb      ErrorCmdLine
	cmp     dl,57
	ja      errorCmdLine
	xor     dh,dh
	sub     dx,48
	mov     al,dl
	shl     al,4
	mov     dl,cs:[di+bx+2]
	cmp     dl,48
	jb      ErrorCmdLine
	cmp     dl,57
	ja      errorCmdLine
	xor     dh,dh
	sub     dx,48
	add     al,dl
	mov     CMDport,ax
	jmp     OtherParam
OtherParam:
	inc     bx
	jmp     @@GetTheParam
EndGetCmdParam:
	cmp     CMDdevice,0
	je      ErrorCmdLine
	ret
ErrorCmdLine:
	push    cs
	pop     ds
	mov     dx,offset WrongCmd
	mov     ah,9
	int     21h
	mov     ax,4c00h
	int     21h
	ret
GetCmdParam endp




AffCmdLine  proc near
	cmp     IsCmdLine,1
	je      @@CmdLineFound
	mov     dx,offset NoCmdLine
	call    AffString
	jmp     @@EndAffCmdLine
@@CmdLineFound:
	call    GetCmdParam
	mov     dx,offset ComandLine
	call    AffString
DeviceN1:
	cmp     CMDDevice,1
	jne     DeviceN2
	mov     dx,offset device1
	call    Affstring
DeviceN2:
	cmp     CMDDevice,2
	jne     DeviceN3
	mov     dx,offset device2
	call    Affstring
DeviceN3:
	cmp     CMDDevice,3
	jne     DeviceN4
	mov     dx,offset device3
	call    Affstring
DeviceN4:
	cmp     CMDDevice,4
	jne     DeviceN5
	mov     dx,offset device4
	call    Affstring
DeviceN5:
	cmp     CMDDevice,5
	jne     DeviceN6
	mov     dx,offset device5
	call    Affstring
DeviceN6:
	cmp     CMDDevice,6
	jne     DeviceN7
	mov     dx,offset device6
	call    Affstring
DeviceN7:
	cmp     CMDDevice,7
	jne     DeviceN8
	mov     dx,offset device7
	call    Affstring
DeviceN8:
	cmp     CMDDevice,8
	jne     NotDevice8
	mov     dx,offset device8
	call    Affstring
NotDevice8:
	cmp     CMDDevice,3
	je      WriteCMDparams
	cmp     CMDDevice,6
	je      WriteCMDparams
	mov     CMDPort,220h
	mov     CMDIRQ,7
	mov     CMDDMA,1
	jmp     @@EndAffCmdLine
WriteCMDparams:
	mov     dx,offset CmdPorts
	call    AffString
	mov     ax,CMDport
	call    affhexa
	mov     dx,offset CmdIRQs
	call    affstring
	mov     ax,CMDirq
	call    affdecimal
	mov     dx,offset CmdDMAs
	call    affstring
	mov     ax,CMDdma
	call    affdecimal
	mov     dx,offset CRLF
	call    AffString
@@EndAffCmdLine:
	ret
AffCmdLine  endp
