; -----------------------------------------------------------------------------
; ZX7 decoder by Einar Saukas
; "Mega" version (244 bytes, 30% faster)
; -----------------------------------------------------------------------------
; Parameters:
;   HL: source address (compressed data)
;   DE: destination address (decompressing)
; -----------------------------------------------------------------------------

dzx7:
        ld      a, $80
copy_byte_loop_ev:
        ldi                             ; copy literal byte
main_loop_ev:
        add     a, a                    ; check next bit
        jr      z, load_bits1           ; no more bits left?
        jr      c, length_size_start_od ; next bit indicates either literal or sequence

copy_byte_loop_od:
        ldi                             ; copy literal byte
main_loop_od:
        add     a, a                    ; check next bit
        jr      nc, copy_byte_loop_ev   ; next bit indicates either literal or sequence

length_size_start_ev:
; determine number of bits used for length (Elias gamma coding)
        push    de
        ld      bc, 1
        ld      d, b
length_size_loop_ev:
        inc     d
        add     a, a                    ; check next bit
        jr      z, load_bits2_ev        ; no more bits left?
        jr      nc, length_size_loop_ev
        jp      length_value_start_ev

length_size_start_od:
; determine number of bits used for length (Elias gamma coding)
        push    de
        ld      bc, 1
        ld      d, b
length_size_loop_od:
        inc     d
        add     a, a                    ; check next bit
        jr      z, load_bits2_od        ; no more bits left?
        jr      nc, length_size_loop_od
        jp      length_value_start_od

; determine length
length_value_loop_ev:
        add     a, a                    ; check next bit
        jr      z, load_bits3_ev        ; no more bits left?
        rl      c
        rl      b
        jr      c, exit_ev              ; check end marker
length_value_start_ev:
        dec     d
        jr      nz, length_value_loop_ev
        inc     bc                      ; adjust length
offset_start_od:
; determine offset
        ld      e, (hl)                 ; load offset flag (1 bit) + offset value (7 bits)
        inc     hl
        defb    $cb, $33                ; opcode for undocumented instruction "SLL E" aka "SLS E"
        jr      nc, offset_end_od       ; if offset flag is set, load 4 extra bits
        add     a, a                    ; check next bit
        rl      d                       ; insert first bit into D
        add     a, a                    ; check next bit
        jr      z, load_bits4           ; no more bits left?
        rl      d                       ; insert second bit into D
        add     a, a                    ; check next bit
        rl      d                       ; insert third bit into D
        add     a, a                    ; check next bit
        jr      z, load_bits5           ; no more bits left?
        ccf
        jr      c, offset_end_od
offset_inc_od:
        inc     d                       ; equivalent to adding 128 to DE
offset_end_od:
        rr      e                       ; insert inverted fourth bit into E
; copy previous sequence
        ex      (sp), hl                ; store source, restore destination
        push    hl                      ; store destination
        sbc     hl, de                  ; HL = destination - offset - 1
        pop     de                      ; DE = destination
        ldir
        pop     hl                      ; restore source address (compressed data)
        jp      main_loop_od

load_bits1:
        ld      a, (hl)                 ; load another group of 8 bits
        inc     hl
        rla
        jr      c, length_size_start_od ; next bit indicates either literal or sequence
        jp      copy_byte_loop_od

load_bits2_ev:
        ld      a, (hl)                 ; load another group of 8 bits
        inc     hl
        rla
        jr      nc, length_size_loop_ev
        jp      length_value_start_ev

load_bits2_od:
        ld      a, (hl)                 ; load another group of 8 bits
        inc     hl
        rla
        jr      nc, length_size_loop_od
        jp      length_value_start_od

load_bits3_ev:
        ld      a, (hl)                 ; load another group of 8 bits
        inc     hl
        rla
        rl      c
        rl      b
        jp      nc, length_value_start_ev ; check end marker
exit_ev:
        pop     de
        ret

load_bits4:
        ld      a, (hl)                 ; load another group of 8 bits
        inc     hl
        rla
        rl      d                       ; insert second bit into D
        add     a, a                    ; check next bit
        rl      d                       ; insert third bit into D
        add     a, a                    ; check next bit
        ccf
        jr      c, offset_end_od
        jp      offset_inc_od

load_bits5:
        ld      a, (hl)                 ; load another group of 8 bits
        inc     hl
        rla
        ccf
        jr      c, offset_end_od
        jp      offset_inc_od

; determine length
length_value_loop_od:
        add     a, a                    ; check next bit
        jr      z, load_bits3_od        ; no more bits left?
        rl      c
        rl      b
        jr      c, exit_od              ; check end marker
length_value_start_od:
        dec     d
        jr      nz, length_value_loop_od
        inc     bc                      ; adjust length
offset_start_ev:
; determine offset
        ld      e, (hl)                 ; load offset flag (1 bit) + offset value (7 bits)
        inc     hl
        defb    $cb, $33                ; opcode for undocumented instruction "SLL E" aka "SLS E"
        jr      nc, offset_end_ev       ; if offset flag is set, load 4 extra bits
        add     a, a                    ; check next bit
        jr      z, load_bits6           ; no more bits left?
        rl      d                       ; insert first bit into D
        add     a, a                    ; check next bit
        rl      d                       ; insert second bit into D
        add     a, a                    ; check next bit
        jr      z, load_bits7           ; no more bits left?
        rl      d                       ; insert third bit into D
        add     a, a                    ; check next bit
        ccf
        jr      c, offset_end_ev
offset_inc_ev:
        inc     d                       ; equivalent to adding 128 to DE
offset_end_ev:
        rr      e                       ; insert inverted fourth bit into E
; copy previous sequence
        ex      (sp), hl                ; store source, restore destination
        push    hl                      ; store destination
        sbc     hl, de                  ; HL = destination - offset - 1
        pop     de                      ; DE = destination
        ldir
        pop     hl                      ; restore source address (compressed data)
        jp      main_loop_ev

load_bits3_od:
        ld      a, (hl)                 ; load another group of 8 bits
        inc     hl
        rla
        rl      c
        rl      b
        jp      nc, length_value_start_od ; check end marker
exit_od:
        pop     de
        ret

load_bits6:
        ld      a, (hl)                 ; load another group of 8 bits
        inc     hl
        rla
        rl      d                       ; insert first bit into D
        add     a, a                    ; check next bit
        rl      d                       ; insert second bit into D
        add     a, a                    ; check next bit
        rl      d                       ; insert third bit into D
        add     a, a                    ; check next bit
        ccf
        jr      c, offset_end_ev
        jp      offset_inc_ev

load_bits7:
        ld      a, (hl)                 ; load another group of 8 bits
        inc     hl
        rla
        rl      d                       ; insert third bit into D
        add     a, a                    ; check next bit
        ccf
        jr      c, offset_end_ev
        jp      offset_inc_ev

; -----------------------------------------------------------------------------
