;
;==============================================================================
;File:      Header_Basic.asm
;Version:   0.6 - Jun/26/2013
;Author:    TK90X Fan (reikainosuke-tk@yahoo.com.br)
;Description:
;    Set of constants for TK90X Z80 assembler. This set contains constants for 
;    Sinclair BASIC editor and interpreter. Most labels are taken from Ian Logan
;    and Frank O'Hara's book 'The Complete Spectrum ROM Disassembly'.
;License:
;    This program is free software: you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation, either version 3 of the License, or
;    (at your option) any later version.
;
;    This program is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with this program.  If not, see <http://www.gnu.org/licenses/>.
;
;==============================================================================
;
;Constants
;---------
PrtBuffer   EQU 23296       ; Address of start of ZX Printer buffer area.
;
;ROM routines
;------------
; BASIC statements
CLEAR       EQU 7852
CLEAR_RUN   EQU 7855        ; Operand of CLEAR must be stored in the BC register
                            ;pair.
CLEAR_1     EQU 7863        ; Entry point used by RUN command.
NEW         EQU 4535        ; Same as BASIC.
RESTORE     EQU 7746
REST_RUN    EQU 7749        ; Entry point used by RUN command.
RUN         EQU 7841
; BASIC editor
MAIN_EXEC   EQU 4770        ; Main execution loop. 
MAIN_4      EQU 4867        ; Return point after interpretation of line of 
                            ;BASIC command or program. This value is stored in
                            ;the machine stack and pointed by ERR_SP. 
RECLAIM_1   EQU 6629        ; Reclaim BASIC memory from address pointed by DE 
                            ;to address pointed by HL-1 (byte pointed by HL is
                            ;untouched).
RECLAIM_2   EQU 6632        ; Same as above, but reclaim BC bytes from address
                            ;pointed by HL. 
SET_MIN     EQU 5808        ; Clear line editor area and beyond. 
MAKE_ROOM   EQU 5717        ; Open BC bytes of space in BASIC memory, starting 
    ;from address pointed by HL-1. After returning, the start of the new 'room' 
    ;is pointed by HL+1 and its end by DE. 
ONE_SPACE   EQU 5714        ; Same as MAKE_ROOM but opens 1 byte only. 
; BASIC interpreter
STMT_RET    EQU 7030        ; Address to return after succesfull interpretation
                            ;of statement. 
;
;System variables
;----------------
; RAM separation
CHANS       EQU 23631       ; Address of start of channel information area.
PROG        EQU 23635       ; Address of start of BASIC program area.
VARS        EQU 23627       ; Address of start of BASIC variable area.
E_LINE      EQU 23641       ; Address of start of edit line.
WORKSP      EQU 23649       ; Address of start of temporary workspace.
STKBOT      EQU 23651       ; Address of start of BASIC calculator stack.
STKEND      EQU 23653       ; Address of start of spare RAM.
ERR_SP      EQU 23613       ; Address of Z80 stack element used to return from
                            ;an error condition.
RAMTOP      EQU 23730       ; Address of last byte used by BASIC.
P_RAMT      EQU 23732       ; Address of last byte of physical RAM.
; BASIC editor and interpreter
DEFADD      EQU 23563       ; Address of first argument of user defined function  
                            ;(DEF FN) being currently invoked by FN.
ERRNR       EQU 23610       ; Current BASIC error code minus 1 (#FF=no error).
FLAGS       EQU 23611       ; Flags.
LISTSP      EQU 23615       ; Return address from automatic listing.
MODE        EQU 23617       ; Cursor mode: K, L, C, E or G. 
NEWPPC      EQU 23618       ; Next line to be executed.
NSPPC       EQU 23620       ; Next instruction to be executed.
PPC         EQU 23621       ; Current line number being executed.
SUBPPC      EQU 23622       ; Current instruction being executed.
E_PPC       EQU 23625       ; Current line, pointed by the cursor.
DEST        EQU 23629       ; Address of a variable being assigned.
NXTLIN      EQU 23637       ; Address of next line to be interpreted.
DATADD      EQU 23639       ; Address after the last byte that has been read by
                            ;a READ statement.
K_CUR       EQU 23643       ; Address of cursor.
CHADD       EQU 23645       ; Address of next character to be interpreted.
CH_ADD      EQU CHADD       ; Alias for CHADD. 
X_PTR       EQU 23647       ; Address of character after '?' marker. 
BREG        EQU 23655       ; Z80 B register used by calculator. 
MEM         EQU 23656       ; Address of start of calculator area. 
FLAGS2      EQU 23658       ; Flags.
S_TOP       EQU 23660       ; Number of first line of automatic listing.
OLDPPC      EQU 23662       ; Line number where CONTINUE will jump to.
OSCPPC      EQU 23664       ; Instruction number where CONTINUE will jump to. 
FLAGX       EQU 23665       ; Flags.
STRLEN      EQU 23666       ; Length of string to be modified.
T_ADDR      EQU 23668       ; Address of next element in syntax table. 
FRAMES      EQU 23672       ; 3-byte counter for maskable interrupts.
PFLAG       EQU 23697       ; Flags.
; Spare variables
SPARE       EQU 23681       ; Not used.
SPARE2      EQU 23728       ; Not used.
NMIVCT      EQU 23728       ; Alias for SPARE2.
