#ifndef _NPMOD32_H_
#define _NPMOD32_H_

////////////////////////////////////////////////////////////////////////
// NPMOD32.DLL export functions

typedef LPVOID (WINAPI *LPMODPLUGCREATE)(UINT argc, LPSTR argn[], LPSTR argv[]);
typedef LPVOID (WINAPI *LPMODPLUGCREATEEX)(LPCSTR);
typedef BOOL (WINAPI *LPMODPLUGDESTROY)(LPVOID);
typedef BOOL (WINAPI *LPMODPLUGLOAD)(LPVOID, LPCSTR);
typedef BOOL (WINAPI *LPMODPLUGSETWINDOW)(LPVOID, HWND);
typedef BOOL (WINAPI *LPMODPLUGPLAY)(LPVOID);
typedef BOOL (WINAPI *LPMODPLUGSTOP)(LPVOID);
typedef DWORD (WINAPI *LPMODPLUGGETVERSION)();
typedef BOOL (WINAPI *LPMODPLUGISREADY)(LPVOID);
typedef BOOL (WINAPI *LPMODPLUGISPLAYING)(LPVOID);
typedef DWORD (WINAPI *LPMODPLUGGETMAXPOSITION)(LPVOID);
typedef DWORD (WINAPI *LPMODPLUGGETCURRENTPOSITION)(LPVOID);
typedef BOOL (WINAPI *LPMODPLUGSETCURRENTPOSITION)(LPVOID, DWORD);

/*
// Supported callback functions in the latest 1.90.03:
typedef BOOL (WINAPI *LPMODPLUGCALLBACK)(LPWAVEFORMATEX, LPWAVEHDR);
typedef BOOL (WINAPI *LPMODPLUGREGISTERCALLBACK)(LPMODPLUGCALLBACK);
// 1.90.04: Query Song Time in milliseconds: ModPlug_GetSongLength()
typedef DWORD (WINAPI *LPMODPLUGGETSONGLENGTH)();
*/

// 1.91: VU-Meter
typedef UINT (WINAPI *LPMODPLUGGETVUMETER)(LPVOID);

extern LPMODPLUGCREATEEX pModPlugCreateEx;
extern LPMODPLUGDESTROY pModPlugDestroy;
extern LPMODPLUGSETWINDOW pModPlugSetWindow;
extern LPMODPLUGLOAD pModPlugLoad;
extern LPMODPLUGGETVUMETER pModPlugGetVUMeter;
extern LPMODPLUGPLAY pModPlugPlay;
extern LPMODPLUGSTOP pModPlugStop;
extern LPMODPLUGSETCURRENTPOSITION pModPlugSetCurrentPosition;

BOOL AudioInit();
BOOL AudioExit();

#endif
