#include <string.h>
#include "utils.h"
#include "gbal.h"



/* Turn mosaic on/off for BG2 and set block size to xdim*ydim */

void mosaic(int onoff, int xdim, int ydim)
{
  if (onoff) 
  {
    BG2CNT |= MOSAIC_ON;
    MOSAIC = ((ydim << MOSAIC_YDIM_SHIFT) | xdim);
  } else
    /* Clear bit 6 */
    BG2CNT &= MOSAIC_OFF;
}



/* Fade the specified layers to black (brightness decrease) */

void FadeToBlack(int layers)
{
int i,j;

  BLDMOD = (CFX_LUM_DEC | layers);
  COLY = 0;

  /* Fade out */
  for (i=0; i<17; i++)
  {
    for (j=0;j<2800;j++) gbalVSync();
    COLY = i;
  }
}



/* Fade the specified layers from black (brightness decrease) */

void FadeFromBlack(int layers)
{
int i,j;

  BLDMOD = (CFX_LUM_DEC | layers);
  COLY = 16;

  /* Fade in */
  for (i=16; i>=0; i--)
  {
    for (j=0;j<2800;j++) gbalVSync();
    COLY = i;
  }
}



/* Clear all 128 entries of the OAM */

void ClearOAM()
{
  int i;
 
   for( i=0; i < 128; i++ )
   {
	 OAM[i].Attrib0 = 0;
	 OAM[i].Attrib1 = 0;
	 OAM[i].Attrib2 = 0;
	 OAM[i].RotateScale = 0;
  }
}




/* Font is assumed to be 16-color and use 1-d mapping */

void LoadFont(char *dest, font_struct *f, char *font_set, char *font_data, int numchars)
{ 
 int i;

  f->fontptr = dest;

  /* Determine the asciicode to localcode "function" */
  for (i=0;i<256;i++) f->ascii2local[i] = font_set[i];

  DMACopyInstant(dest, font_data, (numchars<<5));
  f->palette = 0;
}



int PutsxyOBJ(int x, int y, char *str, font_struct *f, int OAMoffs)
{
 int i,slen;
 char c;

  slen = strlen(str);
 
  for (i = 0; i < slen; i++)
  {
     c = f->ascii2local[str[i]];
     OAM[i+OAMoffs].Attrib0 = (y&255);
     OAM[i+OAMoffs].Attrib1 = (x&255);
     OAM[i+OAMoffs].Attrib2 = (c) | (f->palette<<12);
     x += 8;
  }
  return slen;
}

int PutsxyOBJ256(int x, int y, char *str, font_struct *f, int OAMoffs)
{
 int i,slen;
 char c;

  slen = strlen(str);
 
  for (i = 0; i < slen; i++)
  {
     c = f->ascii2local[str[i]];
     OAM[i+OAMoffs].Attrib0 = (y&255);
     OAM[i+OAMoffs].Attrib1 = (x&255);
     OAM[i+OAMoffs].Attrib2 = (c+c);
     x += 8;
  }
  return slen;
}



/* Put the string str at bg<layer> coordinate x,y */

void PutsxyBG(int x, int y, char *str, font_struct *f, int layer)
{
 int i,slen;
 char c;

  slen = strlen(str);
  for (i = 0; i < slen; i++)
  {
     c = f->ascii2local[str[i]];
     *(u16 *)(VRAM + (layer<<11) + (y<<6) + ((x+i)<<1)) =
                                 (c)|(f->palette<<12);
  }
}

void PutsxyBG256(int x, int y, char *str, font_struct *f, int layer)
{
 int i,slen;
 char c;

  slen = strlen(str);
  for (i = 0; i < slen; i++)
  {
     c = f->ascii2local[str[i]];
     *(u16 *)(VRAM + (layer<<11) + (y<<6) + ((x+i)<<1)) = c;  }
}




/* Convert a 1:23:8 fixed point number to 1:19:8 fixed point */

int f1_23_8_to_f1_19_8(int f)
{
u32 temp;
  temp = (u32)f; 
  return (int)((temp&0x7FFFFFF) | ((f<0) ? BIT27 : 0));
}




/* Convert a 1:23:8 fixed point number to 1:7:8 fixed point */

short f1_23_8_to_f1_7_8(int f)
{
u32 temp;
  temp = (u32)f;  
  return (short)((temp&0x7FFF) | ((f<0) ? BIT15 : 0));
}